/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GFP19350A ( PACKAGE BODY )                                               */
/* Created : 2021/07/01 16:06:09                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP19350A AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19350A
*	処理名			:	登録前確認(警告)ﾁｪｯｸ(ｴﾝﾄﾘｰ系)
*	作成日			:	2012/08/27
*	作成者			:	XXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19350A (
	 PO_KEKKA		OUT		NUMBER												-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT		ERR_MSG_ARRAY										-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PO_RC1			OUT		CUST_CURSOR											-- 結果ｶｰｿﾙ
	,PI_ARGS		IN		ARG_ARRAY											-- 条件配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)	:= 'GFP19350A';					-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)	:= 'GF9350';					-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)	:= TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS');	-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(10)	:= PI_ARGS(9);					-- ﾛｸﾞｲﾝﾕｰｻﾞｰ
--
	-- 変数定義
	G_I				NUMBER;
	G_ERRSTP		VARCHAR2(1000)	:= NULL;
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;
	G_CDKH			VARCHAR2(1)		:= NULL;
	G_RTN			BOOLEAN;
--
	-- 条件配列
	G_SYSTEM_ID		GF41.SYSTEM_ID%TYPE		:= PI_ARGS(1);						-- ｼｽﾃﾑID
	G_LANG			GF41.LANG%TYPE			:= PI_ARGS(2);						-- 言語
	G_CLM			GF41.CLM%TYPE			:= PI_ARGS(3);						-- 項目
	G_NAME_JA		GF41.NAME_JA%TYPE		:= PI_ARGS(4);						-- 名称（漢字）
	G_LABEL_NAME	GF41.LABEL_NAME%TYPE	:= PI_ARGS(5);						-- 表示名称
	G_KBSAKU		GF41.KBSAKU%TYPE		:= PI_ARGS(6);						-- 作成区分
	G_CDTAN			GF41.CDTAN%TYPE			:= PI_ARGS(7);						-- 担当者
	G_UNIQ			GF41.UNIQ%TYPE			:= PI_ARGS(8);						-- ﾕﾆｰｸ
	G_USRSET		GF41.USRSET%TYPE		:= PI_ARGS(9);						-- 登録者
--
	-- ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERR_CHECK_RTN RETURN BOOLEAN;
/*******************************************************************************
*	ERR_CHECK_RTN 確認(警告)ﾁｪｯｸ
*******************************************************************************/
FUNCTION ERR_CHECK_RTN
RETURN BOOLEAN
IS
	L_CNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='ERR_CHECK_RTN';
--
	G_ERRSTP:='ERR_CHECK_RTN_CHECK1';
	IF G_NAME_JA = G_LABEL_NAME THEN
		--「名称と表示名称に、同一の名称をセットしています。」
		HYBS.SET_ERRMSGS(PO_ERRMSGS												-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,1														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,'GFE0008'												-- ｴﾗｰﾒｯｾｰｼﾞID
						);
	END IF;
--
	RETURN TRUE;
END ERR_CHECK_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	-- 処理結果(2:異常)
	PO_KEKKA := 2;
--
	G_DISP_KEY := ' SYSTEM_ID='|| G_SYSTEM_ID||
				  ' LANG='|| G_LANG||
				  ' CLM='|| G_CLM||
				  ' UNIQ='|| G_UNIQ;
--
	-- 初期処理
	G_RTN := ERR_CHECK_RTN;
--
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);
--
	-- 結果ｶｰｿﾙ
	OPEN PO_RC1 FOR
		SELECT SYSDATE FROM DUAL;
--
/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,'GFE0005'												-- 共通SPｴﾗｰ発生
						,G_DISP_KEY												-- ｷｰ項目
						);
		-- 処理結果(2:異常)
		PO_KEKKA := 2;
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;
--
	WHEN OTHERS THEN
		-- ｵﾗｸﾙｴﾗｰ
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,1														-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		-- 処理結果(2:異常)
		PO_KEKKA := 2;
		-- 結果ｶｰｿﾙ
		OPEN PO_RC1 FOR
			SELECT SYSDATE FROM DUAL;
--
END GF19350A;
--
END GFP19350A;
;
