/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.ColorMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class JsChartTag
extends CommonTagSupport {
    private static final String VERSION = "7.0.1.3 (2018/11/12)";
    private static final long serialVersionUID = 701320181112L;
    private static final String STREAMING_JS = "common/option/chartjs-plugin-streaming.min.js";
    private static final String SCRIPT_STREAMING_JS = "<script type=\"text/javascript\" src=\"/" + HybsSystem.getContextName() + "/jsp/common/option/chartjs-plugin-streaming.min.js?v=20210908171653\" ><!-- --></script>" + CR;
    public static final String CTYPE_LINE = "line";
    public static final String CTYPE_BAR = "bar";
    public static final String CTYPE_HBAR = "horizontalBar";
    public static final String CTYPE_RADAR = "radar";
    public static final String CTYPE_POLAR = "polarArea";
    public static final String CTYPE_PIE = "pie";
    public static final String CTYPE_DOUGHNUT = "doughnut";
    private static final Set<String> CTYPE_SET = new ArraySet((Object[])new String[]{"line", "bar", "horizontalBar", "radar", "polarArea", "pie", "doughnut"});
    private static final Set<String> SET_CI_TYPE = new ArraySet((Object[])new String[]{"radar", "polarArea", "pie", "doughnut"});
    private static final String TYPE_CATEGORY = "category";
    private static final String TYPE_LINEAR = "linear";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_REALTIME = "realtime";
    private static final Set<String> SET_POSITION = new ArraySet((Object[])new String[]{"top", "right", "bottom", "left"});
    private static final Set<String> SET_TIMEUNIT = new ArraySet((Object[])new String[]{"year", "quarter", "month", "week", "day", "hour", "minute", "second"});
    private static final Set<String> SET_XSCALE = new ArraySet((Object[])new String[]{"category", "time", "linear", "realtime"});
    private static final Set<String> SET_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private static final String CANVAS_NAME = "hybscanvas";
    private static final String MARK_DEF_ADJUST = "-6";
    private static final String TIME_FORMAT_JA = "{year:'YYYY\u5e74',quarter:'YYYY\u5e74M\u6708',month:'YYYY\u5e74M\u6708',week:'M\u6708D\u65e5',day:'M\u6708D\u65e5',hour:'D\u65e5 H\u6642',minute:'H\u6642m\u5206',second:'m\u5206s\u79d2'}";
    private static final String TIME_FORMAT = "{year:'YYYY',quarter:'YYYY/M',month:'YYYY/M',week:'M/D',day:'M/D',hour:'D HH',minute:'HH:mm',second:'HH:mm:ss'}";
    private static final boolean USE_QUOTE = false;
    private static final boolean NO_QUOTE = true;
    private final transient List<JsChartData> jsChartData = new ArrayList<JsChartData>();
    private transient JsChartData jsXAxis = new JsChartData();
    private String chartBody;
    private String chartType;
    private String labelColumn;
    private String id;
    private String height = "400";
    private String width = "400";
    private String title;
    private String titlePosition;
    private String legendPosition;
    private String legendDisplay;
    private boolean usePointStyle;
    private boolean useLegend;
    private String barWidthPer = "0.8";
    private String onClick;
    private String plugins;
    private String xscaleType = "category";
    private String xposition;
    private boolean valueQuot;
    private String tableId = "h_tblmdl";
    private String markValues;
    private String markColors;
    private String markLbls;
    private String markAdjust;
    private String xmarkValues;
    private String xmarkColors;
    private String markWidth = "2";
    private String markDash;
    private String markFontSize = "10";
    private boolean useZoom;
    private String varColumns;
    private boolean useZeroDataOmit;
    private boolean useRenderer;
    private String sortColumn;
    private String optChart;
    private String optOptions;

    @Override
    protected void release2() {
        super.release2();
        this.jsChartData.clear();
        this.jsXAxis = new JsChartData();
        this.chartBody = null;
        this.chartType = null;
        this.id = null;
        this.height = "400";
        this.width = "400";
        this.labelColumn = null;
        this.title = null;
        this.titlePosition = null;
        this.legendPosition = null;
        this.legendDisplay = null;
        this.usePointStyle = false;
        this.useLegend = false;
        this.barWidthPer = "0.8";
        this.onClick = null;
        this.plugins = null;
        this.xscaleType = TYPE_CATEGORY;
        this.xposition = null;
        this.valueQuot = false;
        this.tableId = "h_tblmdl";
        this.markValues = null;
        this.markColors = null;
        this.markLbls = null;
        this.markAdjust = null;
        this.xmarkValues = null;
        this.xmarkColors = null;
        this.markWidth = "2";
        this.markDash = null;
        this.markFontSize = "10";
        this.useZoom = false;
        this.varColumns = null;
        this.useZeroDataOmit = false;
        this.useRenderer = false;
        this.sortColumn = null;
        this.optChart = null;
        this.optOptions = null;
    }

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.chartBody = this.getBodyString();
        if (this.chartBody != null) {
            this.chartBody = this.chartBody.trim();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.id = this.id == null ? this.tableId : this.id;
        this.jspPrint(this.jsChartOutput());
        return 6;
    }

    private String jsChartOutput() {
        char[] cArray;
        int n;
        int n2;
        int n3;
        int n4;
        String[] stringArray;
        Object object;
        int n5;
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = "cd_" + this.id;
        String string2 = "chart_" + this.id;
        Object object2 = (DBTableModel)this.getObject(this.tableId);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.sortColumn})) {
            n5 = object2.getColumnNo(this.sortColumn, false);
            object = new DBTableModelSorter();
            ((DBTableModelSorter)object).setModel((DBTableModel)this.getObject(this.tableId));
            ((DBTableModelSorter)object).sortByColumn(n5, true);
            object2 = object;
        }
        n5 = object2.getRowCount();
        object = this.jsChartData.iterator();
        while (object.hasNext()) {
            JsChartData jsChartData = (JsChartData)object.next();
            stringArray = jsChartData.getChartColumn();
            int n6 = object2.getColumnNo((String)stringArray, false);
            if (n6 < 0) {
                object.remove();
                continue;
            }
            if (!this.useZeroDataOmit) continue;
            n4 = 1;
            for (int i = 0; i < n5; ++i) {
                String string3 = (String)object2.getValue(i, n6);
                if (!StringUtil.isNotNull((CharSequence[])new CharSequence[]{string3}) || "0".equals(string3) || "0.0".equals(string3) || "0.00".equals(string3)) continue;
                n4 = 0;
                break;
            }
            if (n4 == 0) continue;
            object.remove();
        }
        int n7 = this.jsChartData.size();
        stringArray = new String[n7];
        int[] nArray = new int[n7];
        n4 = object2.getColumnNo(this.labelColumn, false);
        DBColumn dBColumn = object2.getDBColumn(n4);
        for (n3 = 0; n3 < n7; ++n3) {
            String string4;
            stringArray[n3] = string4 = this.jsChartData.get(n3).getChartColumn();
            nArray[n3] = object2.getColumnNo(string4, false);
        }
        if (TYPE_REALTIME.equals(this.xscaleType)) {
            stringBuilder.append(SCRIPT_STREAMING_JS);
        }
        stringBuilder.append("<canvas class=\"").append(CANVAS_NAME).append("\" id=\"").append(this.id).append("\" width=\"").append(this.width).append("\" height=\"").append(this.height).append("\"><!-- --></canvas>").append(CR).append("<script>").append(CR).append(this.chartBody);
        n3 = TYPE_CATEGORY.equals(this.xscaleType) ? 1 : 0;
        boolean bl = TYPE_LINEAR.equals(this.xscaleType);
        boolean bl2 = TYPE_TIME.equals(this.xscaleType);
        Object object3 = object2;
        IntFunction<String> intFunction = arg_0 -> this.lambda$jsChartOutput$0((DBTableModel)object3, n4, bl, dBColumn, arg_0);
        this.setVarArray(stringBuilder, this.labelColumn, n5, n3 != 0 || bl2 || this.useRenderer, intFunction);
        for (n2 = 0; n2 < n7; ++n2) {
            n = nArray[n2];
            this.setVarArray(stringBuilder, stringArray[n2], n5, this.valueQuot, arg_0 -> JsChartTag.lambda$jsChartOutput$1((DBTableModel)object3, n, arg_0));
        }
        if (bl) {
            for (n2 = 0; n2 < n7; ++n2) {
                String string5 = stringArray[n2];
                stringBuilder.append("var LI_").append(string5).append("=[];").append(CR);
                this.jsChartData.get(n2).setChartColumn("LI_" + string5);
            }
            stringBuilder.append("for(var i=0; i<").append(this.labelColumn).append(".length; i++){");
            for (n2 = 0; n2 < n7; ++n2) {
                String string6 = stringArray[n2];
                stringBuilder.append("LI_").append(string6).append("[i]={x:").append(this.labelColumn).append("[i],y:").append(string6).append("[i]};");
            }
            stringBuilder.append("};").append(CR);
        }
        String[] stringArray2 = StringUtil.csv2Array((String)this.varColumns);
        for (n = 0; n < stringArray2.length; ++n) {
            int n8 = object2.getColumnNo(stringArray2[n], false);
            boolean bl3 = object2.getDBColumn(n8).isNumberType();
            this.setVarArray(stringBuilder, stringArray2[n], n5, !bl3, arg_0 -> JsChartTag.lambda$jsChartOutput$2((DBTableModel)object3, n8, arg_0));
        }
        if (!SET_CI_TYPE.contains(this.chartType)) {
            this.jsXAxis.setId("x0");
            this.jsXAxis.setUseTime(bl2);
            if (bl2 && !this.jsXAxis.contains(TYPE_TIME, "displayFormats")) {
                if ("ja".equalsIgnoreCase(this.getLanguage())) {
                    this.jsXAxis.addTime("displayFormats", TIME_FORMAT_JA, true);
                } else {
                    this.jsXAxis.addTime("displayFormats", TIME_FORMAT, true);
                }
            }
            if (CTYPE_BAR.equals(this.chartType) || CTYPE_HBAR.equals(this.chartType)) {
                this.jsXAxis.addAxis("categoryPercentage", this.barWidthPer, true);
            }
            String string7 = this.xposition != null ? this.xposition : (bl ? "bottom" : (CTYPE_HBAR.equals(this.chartType) ? "left" : null));
            this.jsXAxis.addAxis("position", string7, false);
            stringBuilder.append(this.jsXAxis.getAxis()).append(CR);
        }
        if (CTYPE_HBAR.equals(this.chartType)) {
            char[] cArray2 = new char[2];
            cArray2[0] = 120;
            cArray = cArray2;
            cArray2[1] = 121;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = 121;
            cArray = cArray3;
            cArray3[1] = 120;
        }
        char[] cArray4 = cArray;
        for (JsChartData jsChartData : this.jsChartData) {
            stringBuilder.append(jsChartData.getDataset(cArray4[0])).append(CR).append(jsChartData.getAxis()).append(CR);
        }
        stringBuilder.append("var ").append(string).append("={labels:").append(this.labelColumn).append(",datasets:[");
        for (JsChartData jsChartData : this.jsChartData) {
            stringBuilder.append(jsChartData.getDatasetKey()).append(',');
        }
        stringBuilder.append("]};").append(CR).append("var ").append(string2).append("=new Chart(").append(this.id).append(",{type:'").append(this.chartType).append("',data:").append(string);
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.plugins})) {
            stringBuilder.append(",plugins: [").append(this.plugins).append(']');
        }
        stringBuilder.append(",options:{responsive:false");
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.onClick})) {
            stringBuilder.append(",onClick:function(event,obj){").append(this.onClick).append('}');
        }
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{this.title})) {
            stringBuilder.append(",title:{display:true");
            this.setProp(stringBuilder, ",text:'", this.title, "'");
            this.setProp(stringBuilder, ",position:'", this.titlePosition, "'");
            stringBuilder.append('}');
        }
        if (this.useLegend) {
            stringBuilder.append(",legend:{");
            this.setProp(stringBuilder, "display:", this.legendDisplay, ",");
            this.setProp(stringBuilder, "position:'", this.legendPosition, "',");
            if (this.usePointStyle) {
                stringBuilder.append("labels:{usePointStyle: true}");
            }
            stringBuilder.append('}');
        }
        if (!SET_CI_TYPE.contains(this.chartType)) {
            stringBuilder.append(",scales:{").append(cArray4[0]).append("Axes:[");
            for (JsChartData jsChartData : this.jsChartData) {
                if (!jsChartData.isUseAxis()) continue;
                stringBuilder.append(jsChartData.getAxisKey()).append(',');
            }
            stringBuilder.append("],").append(cArray4[1]).append("Axes:[");
            stringBuilder.append(this.jsXAxis.getAxisKey()).append("]}");
            String[] stringArray3 = StringUtil.csv2Array((String)this.markValues);
            String[] stringArray4 = StringUtil.csv2Array((String)this.xmarkValues);
            int n9 = stringArray3.length;
            int n10 = stringArray4.length;
            if (n9 > 0 || n10 > 0) {
                String[] stringArray5;
                stringBuilder.append(",annotation:{annotations:[");
                if (n9 > 0) {
                    stringArray5 = StringUtil.csv2Array((String)this.markLbls, (char)',', (int)n9);
                    String[] stringArray6 = StringUtil.csv2Array((String)this.markAdjust, (char)',', (int)n9, (String)MARK_DEF_ADJUST);
                    String[] stringArray7 = this.colorCsv(this.markColors, n9);
                    for (int i = 0; i < n9; ++i) {
                        stringBuilder.append("{type:'line',scaleID:'y0Ax',mode:'horizontal'");
                        this.setProp(stringBuilder, ",borderWidth:", this.markWidth);
                        this.setProp(stringBuilder, ",borderDash:", this.markDash);
                        this.setProp(stringBuilder, ",value:", stringArray3[i]);
                        this.setProp(stringBuilder, ",borderColor:'", stringArray7[i], "'");
                        if (!stringArray5[i].isEmpty()) {
                            stringBuilder.append(",label:{enabled:'true',position:'left',backgroundColor:'rgba(0,0,0,0)'");
                            this.setProp(stringBuilder, ",yAdjust:", stringArray6[i]);
                            this.setProp(stringBuilder, ",content:'", stringArray5[i], "'");
                            this.setProp(stringBuilder, ",fontColor:'", stringArray7[i], "'");
                            this.setProp(stringBuilder, ",fontSize:", this.markFontSize);
                            stringBuilder.append('}');
                        }
                        stringBuilder.append("},");
                    }
                }
                if (n10 > 0) {
                    stringArray5 = this.colorCsv(this.xmarkColors, n10);
                    for (int i = 0; i < n10; ++i) {
                        stringBuilder.append("{type:'line',scaleID:'x0Ax',mode:'vertical'");
                        this.setProp(stringBuilder, ",borderWidth:", this.markWidth);
                        this.setProp(stringBuilder, ",borderDash:", this.markDash);
                        this.setProp(stringBuilder, ",value:'", stringArray4[i], "'");
                        this.setProp(stringBuilder, ",borderColor:'", stringArray5[i], "'");
                        stringBuilder.append("},");
                    }
                }
                stringBuilder.append("]}");
            }
            if (this.useZoom) {
                stringBuilder.append(",pan:{enabled:true,mode:'xy'},zoom:{enabled:true,drag:false,mode:'xy'}");
            }
        }
        this.setProp(stringBuilder, ",", this.optOptions);
        stringBuilder.append('}');
        this.setProp(stringBuilder, ",", this.optChart);
        stringBuilder.append("});").append(CR);
        if (this.useZoom) {
            stringBuilder.append("window.onload=function(){$('#").append(this.id).append("').dblclick(function(){window.").append(string2).append(".resetZoom();});}");
        }
        stringBuilder.append(CR).append("</script>");
        return stringBuilder.toString();
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2);
        }
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2).append(string3);
        }
    }

    private void setVarArray(StringBuilder stringBuilder, String string, int n, boolean bl, IntFunction<String> intFunction) {
        stringBuilder.append(" var ").append(string).append("=[");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            String string2 = intFunction.apply(i);
            if (bl) {
                stringBuilder.append('\"').append(string2).append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append("];").append(CR);
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (StringUtil.isNotNull((CharSequence[])new CharSequence[]{string}) && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append(']').append(CR).append(set);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    private String[] colorCsv(String string, int n) {
        int n2;
        String[] stringArray = new String[n];
        String[] stringArray2 = ColorMap.getColorKeys((String)string);
        int n3 = Math.min(stringArray.length, stringArray2.length);
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = stringArray2[n2];
        }
        for (n2 = n3; n2 < stringArray.length; ++n2) {
            stringArray[n2] = stringArray2[0];
        }
        return stringArray;
    }

    protected void addJsChartData(JsChartData jsChartData) {
        this.jsChartData.add(jsChartData);
    }

    protected int getJsChartDataSize() {
        return this.jsChartData.size();
    }

    protected boolean isOneColor() {
        return CTYPE_LINE.equalsIgnoreCase(this.chartType) || CTYPE_RADAR.equalsIgnoreCase(this.chartType);
    }

    public void setChartType(String string) {
        this.chartType = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (!this.check(this.chartType, CTYPE_SET)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\u30c1\u30e3\u30fc\u30c8\u30bf\u30a4\u30d7\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("chartType=[").append(this.chartType).append(']').append(CR).append(CTYPE_SET);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setLabelColumn(String string) {
        this.labelColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.labelColumn);
    }

    public void setId(String string) {
        this.id = StringUtil.nval((String)this.getRequestParameter(string), (String)this.id);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setTitle(String string) {
        this.title = StringUtil.nval((String)this.getRequestParameter(string), (String)this.title);
    }

    public void setTitlePosition(String string) {
        this.titlePosition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.titlePosition);
        this.checkPara(this.titlePosition, SET_POSITION, "titlePosition");
    }

    public void setLegendDisplay(String string) {
        this.legendDisplay = StringUtil.nval((String)this.getRequestParameter(string), (String)this.legendDisplay);
        if (this.legendDisplay != null) {
            this.checkPara(this.legendDisplay, SET_BOOLEAN, "legendDisplay");
            this.useLegend = true;
        }
    }

    public void setLegendPosition(String string) {
        this.legendPosition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.legendPosition);
        if (this.legendPosition != null) {
            this.checkPara(this.legendPosition, SET_POSITION, "legendPosition");
            this.useLegend = true;
        }
    }

    public void setUsePointStyle(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.usePointStyle = Boolean.parseBoolean(string2);
            this.useLegend = true;
        }
    }

    public void setBarWidthPer(String string) {
        this.barWidthPer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.barWidthPer);
    }

    public void setOnClick(String string) {
        this.onClick = StringUtil.nval((String)this.getRequestParameter(string), (String)this.onClick);
    }

    public void setPlugins(String string) {
        this.plugins = StringUtil.nval((String)this.getRequestParameter(string), (String)this.plugins);
    }

    public void setXposition(String string) {
        this.xposition = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(this.xposition, SET_POSITION, "position");
    }

    public void setXscaleType(String string) {
        this.xscaleType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xscaleType);
        try {
            this.checkPara(this.xscaleType, SET_XSCALE, "xscaleType");
        }
        catch (HybsSystemException hybsSystemException) {
            System.err.println(hybsSystemException.getMessage());
        }
        this.jsXAxis.addAxis("type", this.xscaleType, false);
    }

    public void setXlabel(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            String string3 = "{display: true,labelString:'" + string2 + "'}";
            this.jsXAxis.addAxis("scaleLabel", string3, true);
        }
    }

    public void setXscaleCallback(String string) {
        this.jsXAxis.addTicks("callback", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXbeginAtZero(String string) {
        this.jsXAxis.addTicks("beginAtZero", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXmax(String string) {
        this.jsXAxis.addTicks("max", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXmin(String string) {
        this.jsXAxis.addTicks("min", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setXstepSize(String string) {
        this.jsXAxis.addTicks("stepSize", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setOptChart(String string) {
        this.optChart = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optChart);
    }

    public void setOptOptions(String string) {
        this.optOptions = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optOptions);
    }

    public void setOptAxis(String string) {
        this.jsXAxis.addOptions("axis", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptTicks(String string) {
        this.jsXAxis.addOptions("ticks", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptScaleLabel(String string) {
        this.jsXAxis.addOptions("scaleLabel", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setOptGridLines(String string) {
        this.jsXAxis.addOptions("gridLines", StringUtil.nval((String)this.getRequestParameter(string), null));
    }

    public void setTimeUnit(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.checkPara(string2, SET_TIMEUNIT, "timeUnit");
        this.jsXAxis.addTime("unit", string2, false);
    }

    public void setTimeMax(String string) {
        this.jsXAxis.addTime("max", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeMin(String string) {
        this.jsXAxis.addTime("min", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeUnitStepSize(String string) {
        this.jsXAxis.addTime("unitStepSize", StringUtil.nval((String)this.getRequestParameter(string), null), true);
    }

    public void setTimeSetFormat(String string) {
        this.jsXAxis.addTime("format", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setTimeLblFormat(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            StringBuilder stringBuilder = new StringBuilder(200).append("{year:'").append(string2).append("',quarter:'").append(string2).append("',month:'").append(string2).append("',week:'").append(string2).append("',day:'").append(string2).append("',hour:'").append(string2).append("',minute:'").append(string2).append("',second:'").append(string2).append("'}");
            this.jsXAxis.addTime("displayFormats", stringBuilder.toString(), true);
        }
    }

    public void setTooltipFormat(String string) {
        this.jsXAxis.addTime("tooltipFormat", StringUtil.nval((String)this.getRequestParameter(string), null), false);
    }

    public void setMarkValues(String string) {
        this.markValues = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markValues);
    }

    public void setMarkColors(String string) {
        this.markColors = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markColors);
    }

    public void setMarkLbls(String string) {
        this.markLbls = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markLbls);
    }

    public void setMarkAdjust(String string) {
        this.markAdjust = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markAdjust);
    }

    public void setXmarkValues(String string) {
        this.xmarkValues = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xmarkValues);
    }

    public void setXmarkColors(String string) {
        this.xmarkColors = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xmarkColors);
    }

    public void setMarkWidth(String string) {
        this.markWidth = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markWidth);
    }

    public void setMarkDash(String string) {
        this.markDash = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markDash);
    }

    public void setMarkFontSize(String string) {
        this.markFontSize = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markFontSize);
    }

    public void setUseZeroDataOmit(String string) {
        this.useZeroDataOmit = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZeroDataOmit);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSortColumn(String string) {
        this.sortColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sortColumn);
    }

    public void setValueQuot(String string) {
        this.valueQuot = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.valueQuot);
    }

    public void setUseZoom(String string) {
        this.useZoom = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZoom);
    }

    public void setVarColumns(String string) {
        this.varColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.varColumns);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("X_AXIS=").append(this.jsXAxis).append(CR);
        this.jsChartData.forEach(jsChartData -> stringBuilder.append("Y_AXIS=").append(this.jsXAxis).append(CR));
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("id", (Object)this.id).println("tableId", (Object)this.tableId).println("chartType", (Object)this.chartType).println("width", (Object)this.width).println("height", (Object)this.height).println("barWidthPer", (Object)this.barWidthPer).println("title", (Object)this.title).println("titlePosition", (Object)this.titlePosition).println("legendPosition", (Object)this.legendPosition).println("legendDisplay", (Object)this.legendDisplay).println("xscaleType", (Object)this.xscaleType).println("optOptions", (Object)this.optOptions).println("optChart", (Object)this.optChart).fixForm().println().println((Object)stringBuilder).toString();
    }

    private static /* synthetic */ String lambda$jsChartOutput$2(DBTableModel dBTableModel, int n, int n2) {
        return (String)dBTableModel.getValue(n2, n);
    }

    private static /* synthetic */ String lambda$jsChartOutput$1(DBTableModel dBTableModel, int n, int n2) {
        return (String)dBTableModel.getValue(n2, n);
    }

    private /* synthetic */ String lambda$jsChartOutput$0(DBTableModel dBTableModel, int n, boolean bl, DBColumn dBColumn, int n2) {
        String string = (String)dBTableModel.getValue(n2, n);
        return this.useRenderer && !bl ? StringUtil.jsonFilter((String)dBColumn.getRendererValue(n2, string)) : string;
    }
}

