/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.LabelDataLoader;

final class CodeDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String SEL_CLM = "select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO";
    private static final String QUERY = "select a.* from (select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,0 as SNO from GEA04 where SYSTEM_ID='**' and FGJ='1' union all select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,1 as SNO from GEA04 where SYSTEM_ID=? and FGJ='1' union all select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,2 as SNO from GEA04 where SYSTEM_ID=? and FGJ='1' ) a order by a.SNO,a.KBSAKU,a.CLM,a.SEQNO,a.CODELVL,a.CODE";
    private static final String QUERY2 = "select a.* from (select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,0 as SNO from GEA04 where SYSTEM_ID='**' and CLM=? and FGJ='1' union all select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,1 as SNO from GEA04 where SYSTEM_ID=? and CLM=? and FGJ='1' union all select CLM,CODE,'' as LNAME,'' as SNAME,CODELVL,CODEGRP,CODE_PARAM,ROLES,SYSTEM_ID,KBSAKU,'' as RSNAME,'' as RLNAME,'' as DESCRIPT,SEQNO,2 as SNO from GEA04 where SYSTEM_ID=? and CLM=? and FGJ='1' ) a order by a.SNO,a.KBSAKU,a.CLM,a.SEQNO,a.CODELVL,a.CODE";
    private final Map<String, CodeData> codeDtMap = Collections.synchronizedMap(new WeakHashMap());
    private final String SYSTEM_ID;
    private final String BASE_SYS_ID;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final LabelDataLoader LABEL_LOADER;

    CodeDataLoader(String string, String string2, boolean bl, LabelDataLoader labelDataLoader) {
        this.SYSTEM_ID = string;
        this.BASE_SYS_ID = string2;
        this.LABEL_LOADER = labelDataLoader;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("CodeDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        String string;
        String[] stringArray = new String[]{this.BASE_SYS_ID, this.SYSTEM_ID};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        HashMap<String, LinkedHashMap<String, String[]>> hashMap = new HashMap<String, LinkedHashMap<String, String[]>>();
        int n = stringArray2.length;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        LinkedHashMap<String, String[]> linkedHashMap = null;
        for (int i = 0; i < n; ++i) {
            String string5 = stringArray2[i][0];
            String string6 = stringArray2[i][1];
            string = stringArray2[i][8];
            String string7 = stringArray2[i][9];
            if (!(string2 != null && string2.equals(string5) && string3.equals(string) && string4.equals(string7))) {
                linkedHashMap = new LinkedHashMap<String, String[]>();
                hashMap.put(string5, linkedHashMap);
                string2 = string5;
                string3 = string;
                string4 = string7;
            }
            String string8 = string5 + "." + string6;
            LabelData labelData = this.LABEL_LOADER.getLabelData(string8);
            stringArray2[i][2] = labelData.getLongLabel();
            stringArray2[i][3] = labelData.getShortLabel();
            stringArray2[i][10] = labelData.getRawShortLabel();
            stringArray2[i][11] = labelData.getRawLongLabel();
            stringArray2[i][12] = labelData.getDescription();
            linkedHashMap.put(string6, stringArray2[i]);
        }
        String[] stringArray3 = hashMap.keySet().toArray(new String[hashMap.size()]);
        int n2 = stringArray3.length;
        for (int i = 0; i < n2; ++i) {
            string = stringArray3[i];
            linkedHashMap = (LinkedHashMap<String, String[]>)hashMap.get(string);
            this.codeDtMap.put(string, new CodeData(string, linkedHashMap));
        }
        System.out.println("  CodeDataLoader [" + n2 + "] loaded");
    }

    public CodeData getCodeData(String string) {
        CodeData codeData = this.codeDtMap.get(string);
        if (codeData == null) {
            String[] stringArray = new String[]{string, this.BASE_SYS_ID, string, this.SYSTEM_ID, string};
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n = stringArray2.length;
            String string2 = null;
            String string3 = null;
            LinkedHashMap<String, String[]> linkedHashMap = null;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray2[i][8];
                String string5 = stringArray2[i][1];
                String string6 = stringArray2[i][9];
                if (string2 == null || !string2.equals(string4) || !string3.equals(string6)) {
                    linkedHashMap = new LinkedHashMap<String, String[]>();
                    string2 = string4;
                    string3 = string6;
                }
                String string7 = string + "." + string5;
                LabelData labelData = this.LABEL_LOADER.getLabelData(string7);
                stringArray2[i][2] = labelData.getLongLabel();
                stringArray2[i][3] = labelData.getShortLabel();
                stringArray2[i][10] = labelData.getRawShortLabel();
                stringArray2[i][11] = labelData.getRawLongLabel();
                stringArray2[i][12] = labelData.getDescription();
                linkedHashMap.put(string5, stringArray2[i]);
            }
            if (linkedHashMap != null) {
                codeData = new CodeData(string, linkedHashMap);
                this.codeDtMap.put(string, codeData);
            }
        }
        return codeData;
    }

    public CodeData getCodeData(String string, String string2) {
        CodeData codeData = this.codeDtMap.get(string);
        if (codeData == null) {
            String[] stringArray = new String[]{string};
            String[][] stringArray2 = DBUtil.dbExecute((String)string2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n = stringArray2.length;
            LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = new String[13];
                String string3 = stringArray2[i][1];
                stringArray3[0] = string;
                stringArray3[1] = string3;
                stringArray3[2] = stringArray2[i][2];
                stringArray3[3] = stringArray2[i][3];
                linkedHashMap.put(string3, stringArray3);
            }
            if (!linkedHashMap.isEmpty()) {
                codeData = new CodeData(string, linkedHashMap);
                this.codeDtMap.put(string, codeData);
            }
        }
        return codeData;
    }

    public void clear(String string) {
        CodeData codeData = this.codeDtMap.remove(string);
        if (codeData != null) {
            String string2 = codeData.getColumn();
            for (int i = 0; i < codeData.getSize(); ++i) {
                this.LABEL_LOADER.clear(string2 + "." + codeData.getCodeKey(i));
            }
        }
    }

    public void clear() {
        this.codeDtMap.clear();
    }
}

