/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.filter.FileResponseTransform;

public class FileResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream filestream;
    protected boolean isClosed;
    protected ServletOutputStream output;
    private final String filename;

    public FileResponseStream(ServletResponse servletResponse, String string) throws IOException {
        this.filename = string;
        this.isClosed = false;
        this.output = servletResponse.getOutputStream();
        this.filestream = new ByteArrayOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.filestream.flush();
            if (this.filename.indexOf("fileDownload:") >= 0) {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.filename.replace("fileDownload:", "")));
                this.filestream.writeTo(bufferedOutputStream);
                Closer.ioClose((Closeable)bufferedOutputStream);
            } else {
                String string = this.filestream.toString("UTF-8");
                FileResponseTransform fileResponseTransform = new FileResponseTransform();
                string = fileResponseTransform.replace(this.filename, string);
                PrintWriter printWriter = FileUtil.getPrintWriter((File)new File(this.filename), (String)"UTF-8");
                printWriter.print(string);
                Closer.ioClose((Closeable)printWriter);
            }
            System.out.println(this.filename + " Saved");
            this.output.flush();
        }
        catch (Throwable throwable) {
            System.out.println(this.filename + " Error! " + throwable);
        }
        finally {
            this.isClosed = true;
            Closer.ioClose((Closeable)this.filestream);
            Closer.ioClose((Closeable)this.output);
        }
    }

    public void flush() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.filestream.flush();
        this.output.flush();
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            return;
        }
        this.filestream.write((byte)n);
        this.output.write((int)((byte)n));
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            return;
        }
        this.output.write(byArray, n, n2);
        this.filestream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.isClosed;
    }

    public boolean isReady() {
        return false;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

