/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTrees;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import org.opengion.fukurou.taglet.AbstractDocTree;
import org.opengion.fukurou.taglet.DocTreeWriter;

public class DocTreeSpecific
extends AbstractDocTree {
    private static final String SELECT_PACKAGE = "org.opengion";
    private static final boolean USE_PRIVATE = false;
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String OG_REV = "og.rev";
    private static final String OG_GROUP = "og.group";
    private static final String DOC_VERSION = "version";
    private static final String DOC_AUTHOR = "author";
    private static final String DOC_SINCE = "since";
    private static final String CONSTRUCTOR = "\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    private static final String METHOD = "\u30e1\u30bd\u30c3\u30c9";
    private String version;
    private String outfile;
    private int debugLevel;
    private final Set<String> mtdClsSet = new HashSet<String>();
    private Types typUtil;

    @Override
    public boolean run(DocletEnvironment docletEnvironment) {
        try (DocTreeWriter docTreeWriter = new DocTreeWriter(this.outfile, "UTF-8");){
            docTreeWriter.printTag("<?xml version=\"1.0\" encoding=\"", "UTF-8", "\" ?>");
            docTreeWriter.printTag("<javadoc>");
            docTreeWriter.printTag("  <version>", this.version, "</version>");
            docTreeWriter.printTag("  <description></description>");
            this.writeContents(docletEnvironment, docTreeWriter);
            docTreeWriter.printTag("</javadoc>");
        }
        catch (Throwable throwable) {
            this.reporter.print(Diagnostic.Kind.ERROR, throwable.getMessage());
        }
        return true;
    }

    private void writeContents(DocletEnvironment docletEnvironment, DocTreeWriter docTreeWriter) {
        DocTrees docTrees = docletEnvironment.getDocTrees();
        Elements elements = docletEnvironment.getElementUtils();
        this.typUtil = docletEnvironment.getTypeUtils();
        for (TypeElement typeElement : ElementFilter.typesIn(docletEnvironment.getIncludedElements())) {
            String string = String.valueOf(typeElement.getQualifiedName());
            docTreeWriter.setClassName(string);
            String string2 = String.valueOf(typeElement.getSimpleName());
            StringBuilder stringBuilder = new StringBuilder();
            typeElement.getModifiers().forEach(modifier -> stringBuilder.append(modifier).append(' '));
            ElementKind elementKind = typeElement.getKind();
            if (ElementKind.CLASS.equals((Object)elementKind)) {
                stringBuilder.append("class");
            }
            String string3 = stringBuilder.toString().trim();
            TypeMirror typeMirror = typeElement.getSuperclass();
            String string4 = TypeKind.NONE.equals((Object)typeMirror.getKind()) ? "" : typeMirror.toString();
            String string5 = Stream.of(typeElement.getInterfaces()).map(list -> String.valueOf(list)).collect(Collectors.joining(","));
            DocCommentTree docCommentTree = docTrees.getDocCommentTree(typeElement);
            List<? extends DocTree> list2 = docCommentTree == null ? EMPTY_LIST : docCommentTree.getFirstSentence();
            List<? extends DocTree> list3 = docCommentTree == null ? EMPTY_LIST : docCommentTree.getFullBody();
            Map<String, List<String>> map = this.blockTagsMap(docCommentTree);
            String string6 = this.getBlockTag(OG_FOR_SMPL, map, "");
            String string7 = this.getBlockTag(OG_REV, map, "\n");
            String string8 = this.getBlockTag(DOC_VERSION, map, "");
            String string9 = this.getBlockTag(DOC_AUTHOR, map, "");
            String string10 = this.getBlockTag(DOC_SINCE, map, "");
            String string11 = this.getBlockTag(OG_GROUP, map, ",");
            docTreeWriter.printTag("<classDoc>");
            docTreeWriter.printTag("  <fullName>", string, "</fullName>");
            docTreeWriter.printTag("  <modifiers>", string3, "</modifiers>");
            docTreeWriter.printTag("  <className>", string2, "</className>");
            docTreeWriter.printTag("  <superClass>", string4, "</superClass>");
            docTreeWriter.printTag("  <interface>", string5, "</interface>");
            docTreeWriter.printTag("  <createVer>", string8, "</createVer>");
            docTreeWriter.printTag("  <author>", string9, "</author>");
            docTreeWriter.printTag("  <since>", string10, "</since>");
            docTreeWriter.printTag("  <description>", list2, "</description>");
            docTreeWriter.printTag("  <contents>", list3, "</contents>");
            docTreeWriter.printTag("  <classGroup>", string11, "</classGroup>");
            docTreeWriter.printTag("  <formSample>", string6, "</formSample>");
            docTreeWriter.printTag("  <history>", string7, "</history>");
            if (this.debugLevel >= 2 && (list3.isEmpty() || list2.isEmpty()) && string4.isEmpty()) {
                System.err.println("\u2461\u8b66\u544a2:\u30b3\u30e1\u30f3\u30c8C=\t" + typeElement);
            }
            int n = 0;
            this.mtdClsSet.clear();
            TypeElement typeElement2 = typeElement;
            String string12 = string;
            while (typeElement2 != null) {
                DocCommentTree docCommentTree2;
                docTreeWriter.setClassName(string12);
                TypeMirror typeMirror2 = typeElement2.getSuperclass();
                StringBuilder stringBuilder2 = new StringBuilder().append(typeMirror2);
                int n2 = stringBuilder2.indexOf("<");
                int n3 = stringBuilder2.indexOf(">", n2);
                while (n2 > 0) {
                    stringBuilder2.delete(n2, n3 + 1);
                    n2 = stringBuilder2.indexOf("<");
                    n3 = stringBuilder2.indexOf(">", n2);
                }
                string12 = stringBuilder2.toString();
                String string13 = n == 0 ? "" : string12;
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement2.getEnclosedElements())) {
                    docCommentTree2 = docTrees.getDocCommentTree(executableElement);
                    if (docCommentTree2 == null || !this.isAction(executableElement, n)) continue;
                    this.menberTag(executableElement, docCommentTree2, CONSTRUCTOR, docTreeWriter, n, string13);
                }
                for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                    docCommentTree2 = docTrees.getDocCommentTree(executableElement);
                    if (docCommentTree2 == null || !this.isAction(executableElement, n)) continue;
                    this.menberTag(executableElement, docCommentTree2, METHOD, docTreeWriter, n, string13);
                }
                if (!string12.startsWith(SELECT_PACKAGE)) break;
                n = 1;
                typeElement2 = elements.getTypeElement(string12);
            }
            docTreeWriter.printTag("</classDoc>");
        }
    }

    private boolean isAction(ExecutableElement executableElement, int n) {
        boolean bl = executableElement.getModifiers().contains((Object)Modifier.PRIVATE);
        boolean bl2 = !executableElement.getTypeParameters().isEmpty();
        boolean bl3 = !this.mtdClsSet.add(String.valueOf(executableElement)) || n > 0 && bl || bl2;
        return !bl3;
    }

    private void menberTag(ExecutableElement executableElement, DocCommentTree docCommentTree, String string, DocTreeWriter docTreeWriter, int n, String string2) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder(200);
        executableElement.getModifiers().forEach(modifier -> stringBuilder.append(modifier).append(' '));
        if (ElementKind.METHOD.equals((Object)executableElement.getKind())) {
            stringBuilder.append(executableElement.getReturnType());
        }
        String string3 = stringBuilder.toString();
        String string4 = String.valueOf(executableElement.getSimpleName());
        StringBuilder stringBuilder2 = new StringBuilder().append(string4).append('(');
        boolean bl = false;
        for (VariableElement object42 : executableElement.getParameters()) {
            bl = true;
            object2 = this.typUtil.asElement(object42.asType());
            object = object2 == null ? String.valueOf(object42.asType()) : String.valueOf(object2.getSimpleName());
            stringBuilder2.append((String)object).append(' ').append(object42.getSimpleName()).append(',');
        }
        if (bl) {
            stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        }
        stringBuilder2.append(')');
        String string5 = stringBuilder2.toString();
        List<? extends DocTree> list = docCommentTree == null ? EMPTY_LIST : docCommentTree.getFirstSentence();
        object2 = docCommentTree == null ? EMPTY_LIST : docCommentTree.getFullBody();
        object = this.blockTagsMap(docCommentTree);
        String string6 = this.getBlockTag(OG_REV, (Map<String, List<String>>)object, "\n");
        StringBuilder stringBuilder3 = new StringBuilder();
        if (docCommentTree != null) {
            for (DocTree docTree : docCommentTree.getBlockTags()) {
                String string7 = String.valueOf(docTree).trim();
                if (string7.contains(OG_REV)) continue;
                stringBuilder3.append(string7).append('\n');
            }
        }
        String string8 = stringBuilder3.toString().trim();
        String string9 = String.valueOf(n);
        docTreeWriter.printTag("  <menber>");
        docTreeWriter.printTag("    <type>", string, "</type>");
        docTreeWriter.printTag("    <name>", string4, "</name>");
        docTreeWriter.printTag("    <modifiers>", string3, "</modifiers>");
        docTreeWriter.printTag("    <signature>", string5, "</signature>");
        docTreeWriter.printTag("    <position>", "", "</position>");
        docTreeWriter.printTag("    <extendClass>", string2, "</extendClass>");
        docTreeWriter.printTag("    <extendFlag>", string9, "</extendFlag>");
        docTreeWriter.printTag("    <description>", list, "</description>");
        docTreeWriter.printTag("    <contents>", (List<? extends DocTree>)object2, "</contents>");
        docTreeWriter.printTag("    <tagText>", string8, "</tagText>");
        docTreeWriter.printTag("    <history>", string6, "</history>");
        docTreeWriter.printTag("  </menber>");
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] optionArray = new Doclet.Option[]{new AbstractDocTree.AbstractOption(new String[]{"-outfile", "-version", "-debugLevel"}){

            @Override
            public boolean process(String string, List<String> list) {
                if ("-outfile".equalsIgnoreCase(string)) {
                    DocTreeSpecific.this.outfile = list.get(0);
                } else if ("-version".equalsIgnoreCase(string)) {
                    DocTreeSpecific.this.version = list.get(0);
                } else if ("-debugLevel".equalsIgnoreCase(string)) {
                    DocTreeSpecific.this.debugLevel = Integer.parseInt(list.get(0));
                }
                return true;
            }
        }};
        return new HashSet<Doclet.Option>(Arrays.asList(optionArray));
    }
}

