<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<style type="text/css">
		fieldset { display:inline-block; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0100"
	title	= "ﾃﾞｰﾀ登録"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:text>
<table>
	<tr>
		<td><b>{@LBL.DY_HATU}：</b></td><td>{@DATE.YMDF @DY_HATU}</td><td width="20px"> </td>
		<td><b>{@LBL.SET_GRP}：</b></td><td>{@SET_GRP}{@SEL_KEY}</td>
		<td><b>{@LBL.SET_KEY}：</b></td><td>{@SET_KEY}</td><td width="20px"> </td>
	</tr>
</table>
</og:text>

<jsp:directive.include file="colorCSS.jsp" />

<og:value command="SQL">
	select count(*) as CNT from GG10 where DY_HATU='{@DY_HATU}' and SET_KEY='{@SET_KEY}' and SET_GRP in ( '{@SET_GRP}','{@SEL_KEY}' ) and rownum=1
</og:value>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	'{@DY_HATU}' as DY_HATU	,
				'{@SET_KEY}' as SET_KEY	,
				COALESCE( B.SET_GRP	,A.SET_GRP	) as SET_GRP		,
				COALESCE( B.TOKEN	,A.TOKEN	) as TOKEN			,
				COALESCE( B.TANI	,C.TANI		) as TANI			,
				B.VAL , B.RIYU										,
				COALESCE( B.JUDG	,'0'		) as JUDG			,
				COALESCE( A.TKN_NM	,C.TKN_NM	) as TKN_NM			,
				C.VIEW_LEN , C.DATA_TYPE , C.BIKO					,
				D.SEL_NM , D.MARKER									,
				A.ROWNO , A.COLNO , A.COLSPAN , A.ROWSPAN			,
				A.CDREC , A.CDDISP , A.E_MIN , A.W_MIN , A.W_MAX , A.E_MAX	,
				B.UNIQ,B.FGJ,B.USRSET,B.DYSET,B.USRUPD,B.DYUPD
		from GG02 A left outer join GG10 B
				on  A.SET_GRP	= B.SET_GRP
				and A.TOKEN		= B.TOKEN
				and B.SET_KEY	= '{@SET_KEY}'
					left outer join GG01 C
					on A.TOKEN = C.TOKEN
						left outer join GG03 D
						on  D.SEL_TYPE = '0'
						and D.SEL_KEY  = 'TKN_GRP'
						and D.SEL_VAL  = C.TKN_GRP
		where A.SET_GRP in ( '{@SET_GRP}','{@SEL_KEY}' )
		and   A.FGJ		= '1'
		order by ROWNO,COLNO
</og:query>

<og:columnEditor columns="DY_HATU,SET_KEY,SET_GRP,TOKEN"	must="true" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit action="INSERT" keys="sqlType" vals="INSERT" value="entry" noWritable="null"     caseKey="{@CNT}"	caseVal="0" />
		<og:submit action="MODIFY" keys="sqlType" vals="MODIFY" value="entry" columnWritable="VAL,TANI,JUDG,RIYU"		caseKey="{@CNT}" caseVal="1" />
<!--	<og:submit action="DELETE" keys="sqlType" vals="DELETE" value="entry" columnWritable="null" caseKey="{@CNT}"	caseVal="1" />	-->
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTokenTable"
		command    = "{@command}"
		noDisplay  = "DY_HATU,SET_KEY,SET_GRP,UNIQ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
		useScrollBar = "false"
		bgColorCycle = "0"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
