<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0050"
	title	= "判定結果一覧"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<og:value command="SET" key="YMDFROM" value='{@NVL.DYFROM "@DATE.YMD M-1"}' />	<!-- １ヶ月前 -->
<og:value command="SET" key="YMDTO"   value='{@NVL.DYTO    @DATE.YMD     }' />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	 A.DY_HATU
				,COALESCE(C.SEL_NM,A.SET_KEY) AS SET_KEY
				,COALESCE(B.SEL_NM,A.SET_GRP) AS SET_GRP
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='0') AS {@LBL.JUDG.0}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='1') AS {@LBL.JUDG.1}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='2') AS {@LBL.JUDG.2}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='3') AS {@LBL.JUDG.3}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='4') AS {@LBL.JUDG.4}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='5') AS {@LBL.JUDG.5}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='6') AS {@LBL.JUDG.6}
				,(select count(*) from GG10 D where D.DY_HATU=A.DY_HATU and D.SET_KEY=A.SET_KEY and D.SET_GRP=A.SET_GRP and D.JUDG='9') AS {@LBL.JUDG.9}
		from GG10 A left outer join GG03 B
				on  A.SET_GRP = B.SEL_VAL
				and B.SEL_TYPE='1' and B.SEL_KEY='SET_GRP' and B.FGJ='1'
				 left outer join GG03 C
					on  C.SEL_VAL = A.SET_KEY
					and C.SEL_TYPE='2' and C.FGJ='1'
	<og:where>
		<og:and value = "A.DY_HATU	&gt;= '{@YMDFROM}'"		/>
		<og:and value = "A.DY_HATU	&lt;= '{@YMDTO}'"		/>
		<og:and value = "A.SET_KEY	=    '{@SET_KEY}'"		/>
		<og:and value = "A.JUDG		=    '{@JUDG}'"			/>
		<og:and value = "A.SET_GRP	like '{@SET_GRP}'"		/>
	</og:where>
	group by A.DY_HATU,C.SEL_NM,A.SET_KEY,B.SEL_NM,A.SET_GRP,A.JUDG
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DY_HATU,A.SET_KEY,A.SET_GRP" />
</og:query>

<og:viewLink command="NEW">
	<og:link column="DY_HATU" gamenId="GG0100" href="index.jsp" target="CONTENTS"
		keys="command,DY_HATU,SET_KEY,SET_GRP"
		vals="NEW,[DY_HATU],[SET_KEY],[SET_GRP]" />
</og:viewLink>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
