<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0020"
	title	= "雛形設定ﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	A.SET_GRP,A.TOKEN
				,COALESCE(A.TKN_NM,B.TKN_NM) AS TKN_NM
				,B.VIEW_LEN,B.TANI,B.DATA_TYPE,B.TKN_GRP
				,A.ROWNO,A.COLNO,A.COLSPAN,A.ROWSPAN
				,A.CDREC,A.CDDISP,A.E_MIN,A.W_MIN,A.W_MAX,A.E_MAX
				,A.UNIQ,A.FGJ,A.USRSET,A.DYSET,A.USRUPD,A.DYUPD
				,B.BIKO
		from GG02 A left outer join GG01 B
				on A.TOKEN = B.TOKEN
	<og:where>
		<og:and value = "A.SET_GRP	= '{@SET_GRP}'"		/>
		<og:and value = "A.TOKEN	like '{@TOKEN}'"		/>
		<og:and value = "( A.TKN_NM like '{@TKN_NM}' or B.TKN_NM like '{@TKN_NM}' )" />
		<og:and value = "A.BIKO		like '{@BIKO}'"			/>
		<og:and value = "A.CDREC	= '{@CDREC}'"			/>
		<og:and value = "A.CDDISP	= '{@CDDISP}'"			/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SET_GRP,A.ROWNO,A.COLNO" />
</og:query>

<og:columnEditor columns="TOKEN,UNIQ"	must="true" />
<og:columnEditor column="SET_GRP"		must="true"
	editor="DBMENU"
	param="select SEL_VAL,SEL_NM || ':' || SEL_VAL from GG03 where SEL_KEY='SET_GRP' and SEL_TYPE='0' and FGJ='1' order by SEQNO"
/>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="FGJ,SET_GRP,TOKEN"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
