<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0010"
	title	= "ﾄｰｸﾝﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	TOKEN,SEQNO,TKN_NM,VIEW_LEN,TANI,DATA_TYPE,TKN_GRP,BIKO,
				UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD
		from GG01
	<og:where>
		<og:and value = "TOKEN		like  '{@TOKEN}'"	/>
		<og:and value = "TKN_NM		like '{@CLM}'"		/>
		<og:and value = "DATA_TYPE	= '{@DATA_TYPE}'"	/>
		<og:and value = "TKN_GRP	= '{@TKN_GRP}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SEQNO,TOKEN" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="TOKEN,SEQNO,DATA_TYPE"	must="true" />

<og:columnEditor columns="TANI,TKN_GRP"	addNoValue="true" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="FGJ,TOKEN"  />
		<og:submit  action="DELETE"  columnWritable="null" />

		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GG02" /></strong></legend>
			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='1' で、SET_GRP をキーに登録している選択肢 -->
			<og:column  name="SET_GRP" useRequestValue="false" td="no" editor="DBMENU"
					param="select SEL_VAL,SEL_NM,'',SEL_GRP,SEL_TYPE,SEQNO from GG03 where SEL_TYPE='1' and SEL_KEY='SET_GRP' and FGJ='1'
							order by 5,4,6,1,2"
			/>
			<og:submit action="COPY" noWritable="null" lbl="GG{@LBL.COPY}" value="gg02update"  />
		</fieldset>
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
