<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2021"
	title	= "テーブルカラム(マスタ利用)"
	date	= "2013/05/30"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- 定義マスタと違う箇所の色を変更するため、GF03のデータも抜きます -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	select * from (
		select	A.TBLSYU,A.TABLE_NAME,B.NAME_JA AS TABLENAME_JA,A.SEQNO,A.CLM,'' as PUP
				,A.NAME_JA,A.CLS_NAME,A.USE_LENGTH,A.DATA_DEFAULT,A.NOT_NULL,A.KBCLM,
				A.RENDERER,A.EDITOR,A.DBTYPE,A.BIKO,A.SYSTEM_ID,A.FGJ,A.UNIQ
				,CASE WHEN C.CLM=A.CLM THEN '0' ELSE '1' END  as DEF_CLM
				,CASE WHEN C.NAME_JA=A.NAME_JA THEN '0' ELSE '1' END  as DEF_NAME_JA
				,CASE WHEN C.CLS_NAME=A.CLS_NAME THEN '0' ELSE '1' END  as DEF_CLS_NAME
				,CASE WHEN C.USE_LENGTH=A.USE_LENGTH THEN '0' WHEN C.USE_LENGTH is NULL and A.USE_LENGTH is NULL THEN '0' ELSE '1' END  as DEF_USE_LENGTH
				,CASE WHEN C.DATA_DEFAULT=A.DATA_DEFAULT THEN '0' WHEN C.DATA_DEFAULT is NULL and A.DATA_DEFAULT is NULL THEN '0' ELSE '1' END  as DEF_DATA_DEFAULT
				,CASE WHEN C.RENDERER=A.RENDERER THEN '0' ELSE '1' END  as DEF_RENDERER
				,CASE WHEN C.EDITOR=A.EDITOR THEN '0' ELSE '1' END  as DEF_EDITOR
				,CASE WHEN C.DBTYPE=A.DBTYPE THEN '0' ELSE '1' END  as DEF_DBTYPE
				,CASE WHEN C.BIKO=A.BIKO THEN '0' WHEN C.BIKO IS NULL and A.BIKO is NULL THEN '0' ELSE '1' END  as DEF_BIKO
		from (GF05 A LEFT OUTER JOIN GF02 B
					ON	A.SYSTEM_ID		= B.SYSTEM_ID
					AND	A.TBLSYU		= B.TBLSYU
					AND	A.TABLE_NAME	= B.TABLE_NAME
					AND	B.FGJ			= '1')
				LEFT OUTER JOIN GF03 C
					ON	A.SYSTEM_ID		= C.SYSTEM_ID
					AND	A.CLM			= C.CLM
					AND C.FGJ			= '1'
	<og:where>
		<og:and value = "A.FGJ         in  ('0','1')"			/>
		<og:and value = "A.SYSTEM_ID   =    '{@SYSTEM_ID}'"		/>
		<og:and value = "A.TBLSYU      =    '{@TBLSYU}'"		/>
		<og:and value = "A.TABLE_NAME  like '{@TABLE_NAME}'"	/>
		<og:and value = "A.CLM         like '{@CLM}'"			/>
		<og:and value = "A.NAME_JA     like '{@NAME_JA}'"		/>
		<og:and value = "A.KBCLM       =    '{@KBCLM}'"			/>
		<og:and value = "A.CLS_NAME    =    '{@CLS_NAME}'"		/>
		<og:and value = "A.RENDERER    =    '{@RENDERER}'"		/>
		<og:and value = "A.EDITOR      =    '{@EDITOR}'"		/>
		<og:and value = "A.DBTYPE      =    '{@DBTYPE}'"		/>
		<og:and value = "A.NOT_NULL    =    '{@NOT_NULL}'"		/>
		<og:and value = "A.USE_LENGTH  =    '{@USE_LENGTH}'"	/>
		<og:and value = "A.BIKO        like '{@BIKO}'"			/>
	</og:where>
	)
	<og:equals val1="{@DIF}" val2="1">
		where ( DEF_CLM = '1' or DEF_NAME_JA= '1'
					or DEF_CLS_NAME = '1'
					or DEF_USE_LENGTH = '1'
					or DEF_DATA_DEFAULT = '1'
					or DEF_DATA_DEFAULT = '1'
					or DEF_EDITOR = '1'
					or DEF_DBTYPE  = '1'
					or DEF_BIKO = '1'
				)
	</og:equals>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,TBLSYU,TABLE_NAME,SEQNO" />
</og:query>
<og:viewLink command="{@command}">
	<og:link column="TABLE_NAME" gamenId="GF2030" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="10"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU,FGJ"
		vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU],1" />
	<og:link column="SEQNO" gamenId="GF2040" href="index.jsp" target="CONTENTS"
		onLink="[SEQNO]" markList="10"
		keys="command,SYSTEM_ID,TABLE_NAME,TBLSYU,FGJ"
		vals="NEW,[SYSTEM_ID],[TABLE_NAME],[TBLSYU],1" />
	<og:link column="CLM" gamenId="GF2005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,[SYSTEM_ID],[CLM],1" />
</og:viewLink>

<!-- カラム定義マスタ関係 -->
<og:viewMarker command="{@command}" isRenderer="false">
	<og:popup column="PUP" href="popup.jsp" gamenId="GF2005"
			keys="SYSTEM_ID,CLM" 
			vals="[SYSTEM_ID],[CLM].value" 
			rtnKeys="CLM,NAME_JA,CLS_NAME,USE_LENGTH,DATA_DEFAULT,RENDERER,EDITOR,DBTYPE,BIKO" />
</og:viewMarker>
<og:viewMarker command="{@command}" >
	<og:columnMarker column="CLM" onMark="[DEF_CLM]" ><div style="background-color:pink;width:100%">[CLM]</div></og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[DEF_NAME_JA]" ><div style="background-color:pink;width:100%">[NAME_JA]</div></og:columnMarker>
	<og:columnMarker column="CLS_NAME" onMark="[DEF_CLS_NAME]" ><div style="background-color:pink;width:100%">[CLS_NAME]</div></og:columnMarker>
	<og:columnMarker column="USE_LENGTH" onMark="[DEF_USE_LENGTH]" ><div style="background-color:pink;width:100%">[USE_LENGTH]</div></og:columnMarker>
	<og:columnMarker column="DATA_DEFAULT" onMark="[DEF_DATA_DEFAULT]" ><div style="background-color:pink;width:100%">[DATA_DEFAULT]</div></og:columnMarker>
	<og:columnMarker column="RENDERER" onMark="[DEF_RENDERER]" ><div style="background-color:pink;width:100%">[RENDERER]</div></og:columnMarker>
	<og:columnMarker column="EDITOR" onMark="[DEF_EDITOR]" ><div style="background-color:pink;width:100%">[EDITOR]</div></og:columnMarker>
	<og:columnMarker column="DBTYPE" onMark="[DEF_DBTYPE]" ><div style="background-color:pink;width:100%">[DBTYPE]</div></og:columnMarker>
	<og:columnMarker column="BIKO" onMark="[DEF_BIKO]" ><div style="background-color:pink;width:100%">[BIKO]</div></og:columnMarker>
</og:viewMarker>

<!--
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},TABLE_NAME,TABLENAME_JA" />
-->

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="TABLENAME_JA" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="TBLSYU,TABLE_NAME"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />

	　<og:submit  value="insertGF03" command="ENTRY" lbl="insertGF03" />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,FGJ,PUP,DEF_CLM,DEF_NAME_JA,DEF_CLS_NAME,DEF_USE_LENGTH,DEF_DATA_DEFAULT,DEF_RENDERER,DEF_EDITOR,DEF_DBTYPE,DEF_BIKO"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<og:hidden name="maxRowCount" value="{@maxRowCount}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
