<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0002"
	title	= "画面"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
>
	5.5.1.5 (2012/04/12) Takahashi Masakazu **はSEQ再セットしない
	5.7.7.3 (2014/06/27) Takahashi Masakazu 削除時条件追加
</og:comment>

<!-- history.back() で戻るボタンを表示します。 -->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />

<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="CLM"	action="TBLSET"	value="[GUIKEY]" />
	<og:columnSet command="{@command}" columnId="KBLBL"	action="SET"	value="4" conditionKey="GUILVL" conditionList="1|2"  />
</og:entry>

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<!-- 7.2.9.5 (2020/11/28) ROLES はｷｰ項目から除外 ADDRESS をｷｰ項目に追加 -->
<og:dataCheck
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	sqlType			= "{@sqlType}"
	from			= "GEA11"
	where			= "SYSTEM_ID=[SYSTEM_ID] and GUIKEY=[GUIKEY] and COALESCE(ADDRESS,'x')=COALESCE([ADDRESS],'x') and KBSAKU=[KBSAKU]"
	uniqCheckClms	= "SYSTEM_ID,GUIKEY,ADDRESS,KBSAKU"
	errRemove		= "{@errRemove}"
/>

<og:transaction>
	<!-- ROLES は null があり得るので、その対策 ||'@' を両端に付ける -->
	<og:tableUpdate
		dbid				= "{@MEM.TO_DBID}"
		command				= "{@command}"
		queryType			= "JDBCTableUpdate"
		commitTableModel	= "false">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA11"
			names			= "GUIKEY,ADDRESS,SEQNO,GUILVL,NAME_JA,LABEL_CLM,GROUPS,ROLES,RWMODE,KBLINK,TARGET,PARAM,SYSTEM_ID,KBSAKU,COMMENTS,RELEASE_NOTES,CDKH,RDC_CODE"
			where			= "SYSTEM_ID=[SYSTEM_ID] and GUIKEY=[GUIKEY] and COALESCE(ADDRESS,'x')=COALESCE([ADDRESS],'x') and KBSAKU=[KBSAKU]"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>

	<!-- ﾗﾍﾞﾙは、削除以外はキーでマージします。 -->
	<og:equals val1="COPY|MODIFY|INSERT|MERGE" val2="{@sqlType}" contains="true">
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			resourceType	= "GEA08" >
			<og:tableUpdateParam
				sqlType		= "MERGE"
				table		= "GEA08"
				names		= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,KBLBL,SYSTEM_ID,RELEASE_NOTES,CDKH,RDC_CODE"
				where		= "SYSTEM_ID=[SYSTEM_ID] and CLM=[CLM] and LANG='ja' and KBSAKU=[KBSAKU]"
				constKeys	= "FGLOAD,LANG"
				constVals	= "1,ja"
			/>
		</og:tableUpdate>
	</og:equals>

	<!-- ﾗﾍﾞﾙﾘｿｰｽの削除は、画面IDが存在しない、KBLBL:ﾗﾍﾞﾙ区分='3' を削除します。 -->
	<og:equals val1="DELETE" val2="{@sqlType}">
		<og:query
			dbid		= "{@MEM.TO_DBID}"
			command		= "NEW"
			maxRowCount	= "0" >
				SELECT A.UNIQ,A.SYSTEM_ID,'D' as CDKH
				FROM   GEA08 A
				WHERE  A.SYSTEM_ID = '{@MEM.SYSTEM_ID}'
				AND    A.KBLBL     in ( '3','4' )
				AND    not exists (
							select 0 from GEA11 B
							where A.SYSTEM_ID = B.SYSTEM_ID
							and   A.CLM       = B.GUIKEY
						)
		</og:query>

		<og:tableUpdate
			dbid		= "{@MEM.TO_DBID}"
			command		= "{@command}"
			queryType	= "JDBCTableUpdate"
			selectedAll	= "true" >
			<og:tableUpdateParam
				sqlType			= "{@sqlType}"
				table			= "GEA08"
				where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
				names			= "CDKH"
				logicalDelete	= "{@logicalDelete}"
			/>
		</og:tableUpdate>
	</og:equals>

	<!-- SEQNOの再セット -->
	<og:query
		dbid		= "{@MEM.TO_DBID}"
		command		= "NEW"
		maxRowCount	= "0" >
			select	SEQNO,GUILVL,UNIQ,SYSTEM_ID
			FROM   GEA11
			WHERE  SYSTEM_ID IN ('{@MEM.SYSTEM_ID}','{@U_BASE}')
			AND    FGJ       IN ( '0','1' )
			ORDER  BY SEQNO
	</og:query>
	<!-- 7.3.2.0 (2021/03/19) SYSTEM_IDが「**」の場合 SEQに 9990000 を加算する (任意) -->
	<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,BREAK_CLM,SYSTEM_ID" vals="SEQNO,GUILVL,SYSTEM_ID" selectedAll="true" />
	<og:tableUpdate
		dbid		= "{@MEM.TO_DBID}"
		command		= "{@command}"
		selectedAll	= "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GEA11 SET
				SEQNO  = [SEQNO]
			WHERE UNIQ = [UNIQ]
			AND SEQNO != [SEQNO]
			AND SYSTEM_ID IN ('{@MEM.SYSTEM_ID}','{@U_BASE}')
	</og:tableUpdate>
</og:transaction>

<!-- リソースキャッシュのクリア -->
<og:engine guiClear="true" />

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="GUI"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
