<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2016/03/08"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:query command="NEW" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
	select 
		TABLE_OWNER,
		TABLE_NAME,
		INDEX_NAME,
		ANALYZED,
		LAST_ANALYZED,
		PARTITIONED,
		PARTITION_NAME
	from
	 (
		select
			dt.owner TABLE_OWNER,
			dt.table_name	,
			'' PARTITION_NAME,
			'' INDEX_NAME,
			'NO' PARTITIONED,
			'1' dummy,
			dt.last_analyzed,
			decode(nvl(dt.num_rows,999),999,'X','O') ANALYZED
		from 
			sys.dba_tables dt
		where dt.owner not in 
					('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OSE$HTTP$ADMIN','OUTLN')
			and dt.table_name not like '%$%'
			and dt.owner like '{@OWNER}%'
			and dt.partitioned='NO'
		union
		select
			dtp.table_owner TABLE_OWNER,
			dtp.table_name,
			dtp.partition_name PARTITION_NAME,
			''	INDEX_NAME,
			'YES'	PARTITIONED,
			'2'		dummy,
			dtp.last_analyzed,
			decode(nvl(dtp.num_rows,999),999,'X','O') TABLE_ANALYZE_STAT
		from 
			sys.dba_tab_partitions dtp
		where dtp.table_owner not in 
					('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OSE$HTTP$ADMIN','OUTLN')
			and dtp.table_name not like '%$%'
			and dtp.table_owner like '{@OWNER}%'
	 union
	 select
			dt.owner TABLE_OWNER,
			dt.table_name,
			''	PARTITION_NAME,
			di.index_name	INDEX_NAME,
			'NO'	PARTITIONED,
			'3'		dummy,
			di.last_analyzed,
			decode(nvl(di.num_rows,999),999,'X','O') TABLE_ANALYZE_STAT
		from 
			sys.dba_indexes di,
			sys.dba_tables dt
		where dt.owner not in 
					('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OSE$HTTP$ADMIN','OUTLN')
			and dt.table_name not like '%$%'
			and dt.owner like '{@OWNER}%'
			and di.partitioned='NO'
			and dt.owner = di.table_owner 
			and dt.table_name = di.table_name
	union
	 select
			dt.owner TABLE_OWNER,
			dt.table_name,
			dip.partition_name PARTITION_NAME,
			dip.index_name	INDEX_NAME,
			'YES'	PARTITIONED,
			'3'		dummy,
			dip.last_analyzed,
			decode(nvl(dip.num_rows,999),999,'X','O') TABLE_ANALYZE_STAT
		from 
			sys.dba_indexes di,	 
			sys.dba_ind_partitions dip,
			sys.dba_tables dt
		where dt.owner not in 
					('SYS','SYSTEM','WMSYS','CTXSYS','MDSYS','ORDSYS','AURORA$JIS$UTILITY$','OSE$HTTP$ADMIN','OUTLN')
			and dt.table_name not like '%$%'
			and dt.owner like '{@OWNER}%'
			and di.partitioned='YES'
			and dt.owner = di.table_owner 
			and dt.table_name = di.table_name
			and di.owner= dip.index_owner
			and di.index_name = dip.index_name
	)
	order by TABLE_OWNER,table_name,dummy,INDEX_NAME,PARTITION_NAME
</og:query>

<og:viewLink command="{@command}">
	<og:link column="TABLE_NAME" href="analyze.jsp" 
		keys="command,TABLE_OWNER,TABLE_NAME,DBID" vals="NEW,[TABLE_OWNER],[TABLE_NAME],{@DBID}" />
	<og:link column="INDEX_NAME" href="analyze.jsp" 
		keys="command,TABLE_OWNER,INDEX_NAME,DBID" vals="NEW,[TABLE_OWNER],[INDEX_NAME],{@DBID}" />
</og:viewLink>


<og:link href="analyze.jsp" 
	keys="command,TABLE_OWNER,DBID" vals="NEW,{@OWNER},{@DBID}" >
<b>All Tables and Indexes ( OWNER={@OWNER} )</b>
</og:link>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "0"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
