/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ImageUtil;

public class ImageResizer {
    private final BufferedImage inputImage;
    private final int inSizeX;
    private final int inSizeY;

    public ImageResizer(String string) {
        this.inputImage = ImageUtil.readFile(string);
        this.inSizeX = this.inputImage.getWidth();
        this.inSizeY = this.inputImage.getHeight();
    }

    public void resizeByPixel(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.inSizeX > this.inSizeY) {
            n2 = n;
            n3 = this.inSizeY * n / this.inSizeX;
        } else {
            n2 = this.inSizeX * n / this.inSizeY;
            n3 = n;
        }
        this.convert(this.inputImage, string, n2, n3);
    }

    public void resizeByPixel(String string, int n, int n2) {
        this.convert(this.inputImage, string, n, n2);
    }

    public void resizeByRatio(String string, double d) {
        int n = (int)((double)this.inSizeX * d);
        int n2 = (int)((double)this.inSizeY * d);
        this.convert(this.inputImage, string, n, n2);
    }

    private void convert(BufferedImage bufferedImage, String string, int n, int n2) {
        if (!ImageUtil.isWriterSuffix(string)) {
            String string2 = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306f" + ImageUtil.WRITER_SUFFIXES + "\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002File=[" + string + "]";
            throw new OgRuntimeException(string2);
        }
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = n3 == 0 ? new BufferedImage(n, n2, 7) : new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransformOp affineTransformOp = null;
        affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n / (double)this.inSizeX, (double)n2 / (double)this.inSizeY), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        ImageUtil.saveFile(bufferedImage2, string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.ImageResizer [Input Filename] [OutputFilename] [-max=maxResize] [-ratio=ratio] [-x=sizeX] [-y=sizeY]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = -1;
        double d = -1.0;
        int n2 = -1;
        int n3 = -1;
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-max=")) {
                n = Integer.parseInt(stringArray[i].substring(5));
            }
            if (stringArray[i].startsWith("-ratio=")) {
                d = Double.parseDouble(stringArray[i].substring(7));
            }
            if (stringArray[i].startsWith("-x=")) {
                n2 = Integer.parseInt(stringArray[i].substring(3));
            }
            if (!stringArray[i].startsWith("-y=")) continue;
            n3 = Integer.parseInt(stringArray[i].substring(3));
        }
        ImageResizer imageResizer = new ImageResizer(string);
        if (n > 0) {
            imageResizer.resizeByPixel(string2, n);
        }
        if (d > 0.0) {
            imageResizer.resizeByRatio(string2, d);
        }
        if (n2 > 0 && n3 > 0) {
            imageResizer.resizeByPixel(string2, n2, n3);
        }
    }
}

