/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.XLogger;

public class DirWatch
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(DirWatch.class.getName());
    public static final long INIT_DELAY = 5L;
    public static final long PERIOD = 30L;
    public static final long TIME_DIFF = 60L;
    private final Path sPath;
    private final boolean useTree;
    private Consumer<Path> action = path -> System.out.println("DirWatch Path=" + path);
    private final PathMatcherSet pathMchSet = new PathMatcherSet();
    private DirectoryStream.Filter<Path> filter;
    private ScheduledFuture<?> stFuture;

    public DirWatch(Path path) {
        this(path, false);
    }

    public DirWatch(Path path2, boolean bl) {
        this.sPath = path2;
        this.useTree = bl;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMchSet.addPathMatcher(pathMatcher);
    }

    public void setPathEndsWith(String ... stringArray) {
        this.pathMchSet.addEndsWith(stringArray);
    }

    public void callback(Consumer<Path> consumer) {
        if (consumer != null) {
            this.action = consumer;
        }
    }

    public void start() {
        this.start(5L, 60L, 30L);
    }

    public void start(long l, long l2, long l3) {
        LOGGER.info(() -> "DirWatch Start: " + this.sPath + " Tree=" + this.useTree + " Delay=" + l + " Period=" + l2 + " TimeDiff=" + l3);
        this.filter = path -> Files.isDirectory(path, new LinkOption[0]) || this.pathMchSet.matches((Path)path) && l3 * 1000L < System.currentTimeMillis() - path.toFile().lastModified();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.stFuture = scheduledExecutorService.scheduleAtFixedRate(this, l, l2, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.stFuture != null && !this.stFuture.isDone()) {
            LOGGER.info(() -> "DirWatch Stop: [" + this.sPath + "]");
            this.stFuture.cancel(true);
        }
    }

    @Override
    public void run() {
        try {
            LOGGER.debug(() -> "DirWatch Running: " + this.sPath + " Tree=" + this.useTree);
            if (Files.exists(this.sPath, new LinkOption[0])) {
                this.execute(this.sPath);
            } else {
                MsgUtil.errPrintln("MSG0002", this.sPath);
            }
        }
        catch (Throwable throwable) {
            MsgUtil.errPrintln(throwable, "MSG0021", this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, this.filter);){
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                Path path2 = iterator.next();
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (!this.useTree) continue;
                    this.execute(path2);
                    continue;
                }
                Consumer<Path> consumer = this.action;
                synchronized (consumer) {
                    this.action.accept(path2);
                }
            }
            return;
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0005", path);
        }
    }
}

