/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.mail.MailModuleUtil;
import org.opengion.hayabusa.mail.MailPattern;
import org.opengion.hayabusa.resource.LDAPSearch;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class MailSenderTag
extends CommonTagSupport {
    private static final String VERSION = "5.8.1.1 (2014/11/14)";
    private static final long serialVersionUID = 581120141114L;
    private transient MailTX mail = null;
    private String host = HybsSystem.sys("COMMON_MAIL_SERVER");
    private String charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
    private String from = null;
    private String[] to = null;
    private String[] cc = null;
    private String[] bcc = null;
    private String[] replyTo = null;
    private String subject = null;
    private String[] filename = null;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String smtpPort = HybsSystem.sys("SMTP_PORT");
    private String authType = HybsSystem.sys("MAIL_SEND_AUTH");
    private String authPort = HybsSystem.sys("MAIL_SEND_AUTH_PORT");
    private String authUser = HybsSystem.sys("MAIL_SEND_AUTH_USER");
    private String authPass = HybsSystem.sys("MAIL_SEND_AUTH_PASSWORD");
    private boolean useLDAP = false;
    private String ldapKey = HybsSystem.sys("LDAP_MAILSEND_KEY");
    private String ldapVals = HybsSystem.sys("LDAP_MAILSEND_VALS");
    private boolean useDB = false;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private boolean useHistory = HybsSystem.sysBool("USE_MAILSENDER_HISTORY");
    private String message;

    @Override
    public int doStartTag() {
        this.mail = new MailTX(this.host, this.charset, this.smtpPort, this.authType, this.authPort, this.authUser, this.authPass);
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.message = this.getBodyString();
        this.mail.setMessage(this.message);
        return 0;
    }

    @Override
    public int doEndTag() {
        Object object;
        String[] stringArray;
        this.debugPrint();
        if (this.useLDAP) {
            stringArray = StringUtil.csv2Array((String)this.ldapVals);
            object = new LDAPSearch();
            ((LDAPSearch)object).setAttributes(stringArray);
            ((LDAPSearch)object).init();
            this.from = this.setLDAPAddress((LDAPSearch)object, this.from);
            this.to = this.setLDAPAddress((LDAPSearch)object, this.to);
            this.cc = this.setLDAPAddress((LDAPSearch)object, this.cc);
            this.bcc = this.setLDAPAddress((LDAPSearch)object, this.bcc);
            this.replyTo = this.setLDAPAddress((LDAPSearch)object, this.replyTo);
        } else if (this.useDB) {
            stringArray = new String[]{this.from};
            this.from = this.getAddressArray(stringArray)[0];
            this.to = this.getAddressArray(this.to);
            this.cc = this.getAddressArray(this.cc);
            this.bcc = this.getAddressArray(this.bcc);
            this.replyTo = this.getAddressArray(this.replyTo);
        }
        this.mail.setFrom(this.from);
        this.mail.setTo(this.to);
        this.mail.setCc(this.cc);
        this.mail.setBcc(this.bcc);
        this.mail.setReplyTo(this.replyTo);
        this.mail.setSubject(this.subject);
        this.mail.setDebug(this.isDebug());
        stringArray = null;
        if (this.filename != null && this.filename.length > 0) {
            stringArray = new String[this.filename.length];
            object = HybsSystem.url2dir(this.fileURL);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = StringUtil.urlAppend((String)object, (String)this.filename[i], (String[])new String[0]);
            }
            this.mail.setFilename(stringArray);
        }
        this.mail.sendmail();
        if (this.useHistory) {
            object = new MailModuleUtil();
            ((MailModuleUtil)object).setInitParams(this.sys("SYSTEM_ID"), this.from, this.to, this.cc, this.bcc, this.message, this.subject, this.getUserInfo("ID"), this.getGUIInfoAttri("KEY"), stringArray);
            ((MailModuleUtil)object).commitMailDB();
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.mail = null;
        this.host = HybsSystem.sys("COMMON_MAIL_SERVER");
        this.charset = HybsSystem.sys("MAIL_DEFAULT_CHARSET");
        this.from = null;
        this.to = null;
        this.cc = null;
        this.bcc = null;
        this.replyTo = null;
        this.subject = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = null;
        this.useLDAP = false;
        this.ldapKey = HybsSystem.sys("LDAP_MAILSEND_KEY");
        this.ldapVals = HybsSystem.sys("LDAP_MAILSEND_VALS");
        this.useDB = false;
        this.smtpPort = HybsSystem.sys("SMTP_PORT");
        this.authType = HybsSystem.sys("MAIL_SEND_AUTH");
        this.authPort = HybsSystem.sys("MAIL_SEND_AUTH_PORT");
        this.authUser = HybsSystem.sys("MAIL_SEND_AUTH_USER");
        this.authPass = HybsSystem.sys("MAIL_SEND_AUTH_PASSWORD");
        this.useHistory = HybsSystem.sysBool("USE_MAILSENDER_HISTORY");
        this.message = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String setLDAPAddress(LDAPSearch lDAPSearch, String string) {
        if (string == null) return string;
        if (string.indexOf(64) >= 0) return string;
        List<String[]> list = lDAPSearch.search(this.ldapKey + "=" + string);
        if (list.size() == 1) {
            String[] stringArray = list.get(0);
            if (this.ldapVals.indexOf(44) >= 0) return stringArray[0] + "<" + stringArray[1] + ">";
            return stringArray[0];
        }
        String string2 = "LDAP\u691c\u7d22\u306e\u7d50\u679c\u3001\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u8a2d\u5b9a\u5024=[" + string + "] , \u691c\u7d22\u30ad\u30fc=[" + this.ldapKey + "] , \u691c\u7d22\u5c5e\u6027=[" + this.ldapVals + "]";
        throw new HybsSystemException(string2);
    }

    private String[] setLDAPAddress(LDAPSearch lDAPSearch, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.setLDAPAddress(lDAPSearch, stringArray[i]);
        }
        return stringArray2;
    }

    public void setFrom(String string) {
        this.from = StringUtil.nval((String)this.getRequestParameter(string), (String)this.from);
    }

    public void setTo(String string) {
        this.to = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setCc(String string) {
        this.cc = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setBcc(String string) {
        this.bcc = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setReplyTo(String string) {
        this.replyTo = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setHost(String string) {
        this.host = StringUtil.nval((String)this.getRequestParameter(string), (String)this.host);
    }

    public void setSubject(String string) {
        this.subject = this.getRequestParameter(string);
    }

    public void setFilename(String string) {
        this.filename = StringUtil.csv2ArrayOnly((String)this.getRequestParameter(string));
    }

    public void setCharset(String string) {
        this.charset = StringUtil.nval((String)this.getRequestParameter(string), (String)this.charset);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setUseLDAP(String string) {
        this.useLDAP = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLDAP);
    }

    public void setLdapKey(String string) {
        this.ldapKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.ldapKey);
    }

    public void setLdapVals(String string) {
        this.ldapVals = StringUtil.nval((String)this.getRequestParameter(string), (String)this.ldapVals);
    }

    public void setUseDB(String string) {
        this.useDB = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useDB);
    }

    public void setSmtpPort(String string) {
        this.smtpPort = StringUtil.nval((String)this.getRequestParameter(string), (String)this.smtpPort);
    }

    public void setAuthType(String string) {
        this.authType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authType);
    }

    public void setAuthPort(String string) {
        this.authPort = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authPort);
    }

    public void setAuthUser(String string) {
        this.authUser = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authUser);
    }

    public void setAuthPass(String string) {
        this.authPass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authPass);
    }

    public void setUseHistory(String string) {
        this.useHistory = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useHistory);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String[] getAddressArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = (String[])stringArray.clone();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray3 = this.getUserAddr(string);
            if (stringArray3 == null || stringArray3.length <= 0) continue;
            string = stringArray3[0] != null ? stringArray3[0] + "<" + stringArray3[1] + ">" : stringArray3[1];
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    private String[] getUserAddr(String string) {
        String[] stringArray = null;
        if (string.contains("@")) {
            stringArray = new String[]{"", string};
        } else {
            String[] stringArray2 = new String[]{string};
            String[][] stringArray3 = DBUtil.dbExecute((String)MailPattern.selGE35, (String[])stringArray2, (ApplicationInfo)this.getApplicationInfo(), (String)this.DBID);
            if (stringArray3.length > 0) {
                stringArray = stringArray3[0];
            } else {
                String string2 = "\u30e6\u30fc\u30b6\u30fc\u60c5\u5831\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002\u30e6\u30fc\u30b6\u30fcID\uff1a" + string;
                throw new HybsSystemException(string2);
            }
        }
        return stringArray;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("host", (Object)this.host).println("charset", (Object)this.charset).println("from", (Object)this.from).println("to", (Object[])this.to).println("cc", (Object[])this.cc).println("bcc", (Object[])this.bcc).println("replyTo", (Object[])this.replyTo).println("subject", (Object)this.subject).println("filename", (Object[])this.filename).println("fileURL", (Object)this.fileURL).println("useLDAP", (Object)this.useLDAP).println("ldapKey", (Object)this.ldapKey).println("ldapVals", (Object)this.ldapVals).println("useDB", (Object)this.useDB).println("useHistory", (Object)this.useHistory).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

