/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet.multipart;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.Closer;
import org.opengion.hayabusa.servlet.multipart.FilePart;
import org.opengion.hayabusa.servlet.multipart.ParamPart;
import org.opengion.hayabusa.servlet.multipart.Part;

public class MultipartParser {
    private final ServletInputStream in;
    private final String boundary;
    private FilePart lastFilePart;
    private final byte[] buf = new byte[8192];
    private static final String DEFAULT_ENCODING = "MS932";
    private String encoding = "MS932";

    public MultipartParser(HttpServletRequest httpServletRequest, int n) throws IOException {
        String string = null;
        String string2 = httpServletRequest.getHeader("Content-Type");
        String string3 = httpServletRequest.getContentType();
        if (string2 == null && string3 != null) {
            string = string3;
        } else if (string3 == null && string2 != null) {
            string = string2;
        } else if (string2 != null && string3 != null) {
            String string4 = string = string2.length() > string3.length() ? string2 : string3;
        }
        if (string == null || !string.toLowerCase(Locale.JAPAN).startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int n2 = httpServletRequest.getContentLength();
        if (n > 0 && n2 > n) {
            throw new IOException("\u767b\u9332\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u304c\u4e0a\u9650(" + n / 1024 / 1024 + "MB)\u3092\u8d8a\u3048\u3066\u3044\u307e\u3059\u3002" + " \u767b\u9332\u30d5\u30a1\u30a4\u30eb=" + n2 / 1024 / 1024 + "MB");
        }
        String string5 = this.extractBoundary(string);
        if (string5 == null) {
            throw new IOException("Separation boundary was not specified");
        }
        this.in = httpServletRequest.getInputStream();
        this.boundary = string5;
        String string6 = this.readLine();
        if (string6 == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!string6.startsWith(this.boundary)) {
            throw new IOException("Corrupt form data: no leading boundary: " + string6 + " != " + this.boundary);
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public Part readNextPart() throws IOException {
        CharSequence charSequence;
        String string;
        if (this.lastFilePart != null) {
            Closer.ioClose((Closeable)this.lastFilePart.getInputStream());
            this.lastFilePart = null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.readLine();
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return null;
        }
        while (string2 != null && string2.length() > 0) {
            string = null;
            boolean bl = true;
            charSequence = new StringBuilder(100);
            charSequence.append(string2);
            while (bl) {
                string = this.readLine();
                if (string != null && (string.startsWith(" ") || string.startsWith("\t"))) {
                    charSequence.append(string);
                    continue;
                }
                bl = false;
            }
            arrayList.add(charSequence.toString());
            string2 = string;
        }
        if (string2 == null) {
            return null;
        }
        string = null;
        String string3 = null;
        charSequence = null;
        Object object = "text/plain";
        for (String string4 : arrayList) {
            Object object2;
            if (string4.toLowerCase(Locale.JAPAN).startsWith("content-disposition:")) {
                object2 = this.extractDispositionInfo(string4);
                string = object2[1];
                string3 = object2[2];
                charSequence = object2[3];
                continue;
            }
            if (!string4.toLowerCase(Locale.JAPAN).startsWith("content-type:") || (object2 = this.extractContentType(string4)) == null) continue;
            object = object2;
        }
        if (string3 == null) {
            return new ParamPart(string, this.in, this.boundary, this.encoding);
        }
        if ("".equals(string3)) {
            string3 = null;
        }
        this.lastFilePart = new FilePart(string, this.in, this.boundary, (String)object, string3, (String)charSequence);
        return this.lastFilePart;
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] stringArray = new String[4];
        String string2 = string.toLowerCase(Locale.JAPAN);
        int n = string2.indexOf("content-disposition: ");
        int n2 = string2.indexOf(59);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string);
        }
        String string3 = string2.substring(n + 21, n2);
        if (!"form-data".equals(string3)) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string2.indexOf("name=\"", n2);
        n2 = string2.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string);
        }
        String string4 = string.substring(n + 6, n2);
        String string5 = null;
        String string6 = null;
        n = string2.indexOf("filename=\"", n2 + 2);
        n2 = string2.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string6 = string5 = string.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string5 = string5.substring(n3 + 1);
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string5;
        stringArray[3] = string6;
        return stringArray;
    }

    private String extractContentType(String string) throws IOException {
        String string2 = null;
        String string3 = string.toLowerCase(Locale.JAPAN);
        if (string3.startsWith("content-type")) {
            int n = string3.indexOf(32);
            if (n == -1) {
                throw new IOException("Content type corrupt: " + string);
            }
            string2 = string3.substring(n + 1);
        } else if (string3.length() > 0) {
            throw new IOException("Malformed line after disposition: " + string);
        }
        return string2;
    }

    private String readLine() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuilder.append(new String(this.buf, 0, n, this.encoding));
        } while (n == this.buf.length);
        if (stringBuilder.length() == 0) {
            return null;
        }
        String string = stringBuilder.toString();
        int n2 = stringBuilder.length();
        if (n2 >= 2 && stringBuilder.charAt(n2 - 2) == '\r') {
            string = string.substring(0, n2 - 2);
        } else if (n2 >= 1 && stringBuilder.charAt(n2 - 1) == '\n') {
            string = string.substring(0, n2 - 1);
        }
        return string;
    }
}

