/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.report.ExcelLayout;

public class HybsHSSFListener
implements HSSFListener {
    private SSTRecord sstrec;
    private int sheetNo = -1;
    private int sheetSize = 0;
    private boolean trace = false;
    private ExcelLayout laynot = null;

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                if (this.trace && record instanceof BoundSheetRecord) {
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    System.out.println("Sheet named: " + boundSheetRecord.getSheetname());
                }
                ++this.sheetSize;
                break;
            }
            case 2057: {
                if (!(record instanceof BOFRecord)) break;
                BOFRecord bOFRecord = (BOFRecord)record;
                if (bOFRecord.getType() == 5) {
                    if (!this.trace) break;
                    System.out.println("Encountered workbook");
                    break;
                }
                if (bOFRecord.getType() != 16) break;
                ++this.sheetNo;
                if (!this.trace) break;
                System.out.println("Encountered sheet [" + this.sheetNo + "]");
                break;
            }
            case 252: {
                if (!(record instanceof SSTRecord)) break;
                this.sstrec = (SSTRecord)record;
                this.laynot = new ExcelLayout(this.sheetSize);
                if (!this.trace) break;
                System.out.println("SSTRecord:[" + this.sstrec.getNumUniqueStrings() + "]");
                break;
            }
            case 253: {
                if (!(record instanceof LabelSSTRecord)) break;
                LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                int n = labelSSTRecord.getRow();
                short s = labelSSTRecord.getColumn();
                UnicodeString unicodeString = this.sstrec.getString(labelSSTRecord.getSSTIndex());
                String string = unicodeString.getString();
                if (string == null || string.indexOf("{@") < 0) break;
                if (this.trace) {
                    System.out.println("String cell id,sheet,row,col=[" + labelSSTRecord.getSSTIndex() + "," + this.sheetNo + "," + n + "," + s + "] => " + string);
                }
                this.laynot.addModel(this.sheetNo, string, n, s);
                break;
            }
            default: {
                LogWriter.log((String)("\u60f3\u5b9a\u5916\u306e\u30a4\u30d9\u30f3\u30c8\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002=[" + record.getSid() + "]"));
            }
        }
    }

    public ExcelLayout getLayout() {
        return this.laynot;
    }

    public int getSheetSize() {
        return this.sheetSize;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelLayout makeExcelLayout(File file, boolean bl) throws IOException {
        HybsHSSFListener hybsHSSFListener;
        FileInputStream fileInputStream = null;
        DocumentInputStream documentInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
            documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
            HSSFRequest hSSFRequest = new HSSFRequest();
            hybsHSSFListener = new HybsHSSFListener();
            hybsHSSFListener.setTrace(bl);
            hSSFRequest.addListener((HSSFListener)hybsHSSFListener, (short)2057);
            hSSFRequest.addListener((HSSFListener)hybsHSSFListener, (short)133);
            hSSFRequest.addListener((HSSFListener)hybsHSSFListener, (short)252);
            hSSFRequest.addListener((HSSFListener)hybsHSSFListener, (short)253);
            HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
            hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        }
        catch (Throwable throwable) {
            Closer.ioClose(fileInputStream);
            Closer.ioClose(documentInputStream);
            throw throwable;
        }
        Closer.ioClose((Closeable)fileInputStream);
        Closer.ioClose((Closeable)documentInputStream);
        return hybsHSSFListener.getLayout();
    }
}

