/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.IntIndex;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.TextCache;

public class Cache
extends BaseHashMap {
    private int reserveCount;
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private final BaseHashMap.BaseHashIterator objectIterator;
    private boolean updateAccess;
    private CachedObject[] rowTable;
    private long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch shadowTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        super(dataFileCache.capacity(), 3, 0, true);
        this.maxCapacity = dataFileCache.capacity();
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
        this.objectIterator = new BaseHashMap.BaseHashIterator(true);
        this.updateAccess = true;
        this.comparator = this.rowComparator;
        this.reserveCount = dataFileCache instanceof TextCache || dataFileCache instanceof DataFileCacheSession ? 0 : 8;
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public CachedObject get(long l) {
        int n;
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        if ((n = this.getObjectLookup(l)) == -1) {
            return null;
        }
        this.accessTable[n] = ++this.accessCount;
        CachedObject cachedObject = (CachedObject)this.objectKeyTable[n];
        return cachedObject;
    }

    void put(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        if (!this.preparePut(n)) {
            long l = this.size() + this.reserveCount >= this.capacity ? (long)this.capacity : this.bytesCapacity / 1024L;
            throw Error.error(471, String.valueOf(l));
        }
        this.putNoCheck(cachedObject);
    }

    void putUsingReserve(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        this.preparePut(n);
        if (this.size() >= this.capacity) {
            throw Error.error(471, String.valueOf(this.capacity));
        }
        this.putNoCheck(cachedObject);
    }

    boolean preparePut(int n) {
        boolean bl;
        boolean bl2 = this.size() + this.reserveCount >= this.capacity;
        boolean bl3 = bl = (long)n + this.cacheBytesLength > this.bytesCapacity;
        if (bl2 || bl) {
            this.cleanUp(false);
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl4 = bl = (long)n + this.cacheBytesLength > this.bytesCapacity;
            if (!bl2 && !bl) {
                return true;
            }
            this.clearUnchanged();
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl5 = bl = (long)n + this.cacheBytesLength > this.bytesCapacity;
            if (!bl2 && !bl) {
                return true;
            }
            this.cleanUp(true);
            bl2 = this.size() + this.reserveCount >= this.capacity;
            boolean bl6 = bl = (long)n + this.cacheBytesLength > this.bytesCapacity;
            if (bl2) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE ROWS limit reached");
            }
            if (bl) {
                this.dataFileCache.logInfoEvent("dataFileCache CACHE SIZE limit reached");
            }
            if (bl2 || bl) {
                return false;
            }
        }
        return true;
    }

    private void putNoCheck(CachedObject cachedObject) {
        if (this.accessCount > 0x7FEFFFFF) {
            this.updateAccessCounts();
            this.resetAccessCount();
            this.updateObjectAccessCounts();
        }
        Object object = super.addOrRemoveObject(cachedObject, cachedObject.getPos(), false);
        cachedObject.setInMemory(true);
        this.cacheBytesLength += (long)cachedObject.getStorageSize();
    }

    CachedObject release(long l) {
        CachedObject cachedObject = (CachedObject)super.addOrRemoveObject(null, l, true);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        cachedObject.setInMemory(false);
        return cachedObject;
    }

    public void releaseRange(IntIndex intIndex, int n) {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)this.objectIterator.next();
            long l = cachedObject.getPos();
            int n2 = (int)(l / (long)n);
            int n3 = intIndex.findFirstEqualKeyIndex(n2);
            if (n3 < 0) continue;
            cachedObject.setInMemory(false);
            this.objectIterator.remove();
            this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        }
    }

    private void updateAccessCounts() {
        if (this.updateAccess) {
            for (int i = 0; i < this.objectKeyTable.length; ++i) {
                int n;
                CachedObject cachedObject = (CachedObject)this.objectKeyTable[i];
                if (cachedObject == null || (n = cachedObject.getAccessCount()) <= this.accessTable[i]) continue;
                this.accessTable[i] = n;
            }
        }
    }

    private void updateObjectAccessCounts() {
        if (this.updateAccess) {
            for (int i = 0; i < this.objectKeyTable.length; ++i) {
                CachedObject cachedObject = (CachedObject)this.objectKeyTable[i];
                if (cachedObject == null) continue;
                int n = this.accessTable[i];
                cachedObject.updateAccessCount(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(boolean bl) {
        this.updateAccessCounts();
        int n = 0;
        int n2 = this.size() / 2;
        int n3 = bl ? this.accessCount + 1 : this.getAccessCountCeiling(n2, n2 / 8);
        int n4 = bl ? this.accessCount + 1 : (this.accessMin + n3) / 2;
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)this.objectIterator.next();
            int n5 = this.objectIterator.getAccessCount();
            boolean bl2 = n5 < n3 && !cachedObject.isKeepInMemory();
            boolean bl3 = cachedObject.isNew() && cachedObject.getStorageSize() >= 4096;
            boolean bl4 = cachedObject.hasChanged() && (bl2 || bl3);
            this.objectIterator.setAccessCount(n3);
            CachedObject cachedObject2 = cachedObject;
            synchronized (cachedObject2) {
                if (bl4) {
                    this.rowTable[n++] = cachedObject;
                }
                if (bl2) {
                    cachedObject.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
            if (n != this.rowTable.length) continue;
            this.saveRows(n);
            n = 0;
        }
        this.saveRows(n);
        this.setAccessCountFloor(n3);
        ++this.accessCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnchanged() {
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            CachedObject cachedObject2 = cachedObject = (CachedObject)this.objectIterator.next();
            synchronized (cachedObject2) {
                if (!cachedObject.isKeepInMemory() && !cachedObject.hasChanged()) {
                    cachedObject.setInMemory(false);
                    this.objectIterator.remove();
                    this.cacheBytesLength -= (long)cachedObject.getStorageSize();
                }
            }
        }
    }

    private synchronized void saveRows(int n) {
        if (n == 0) {
            return;
        }
        this.rowComparator.setType(1);
        ArraySort.sort(this.rowTable, 0, n, this.rowComparator);
        this.dataFileCache.saveRows(this.rowTable, 0, n);
        this.saveRowCount += n;
    }

    void saveAll() {
        int n = 0;
        this.objectIterator.reset();
        while (this.objectIterator.hasNext()) {
            CachedObject cachedObject;
            if (n == this.rowTable.length) {
                this.saveRows(n);
                n = 0;
            }
            if (!(cachedObject = (CachedObject)this.objectIterator.next()).hasChanged()) continue;
            this.rowTable[n] = cachedObject;
            ++n;
        }
        this.saveRows(n);
    }

    void logSaveRowsEvent(int n, long l) {
        long l2 = this.saveAllTimer.elapsedTime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cache save rows [count,time] totals ");
        stringBuffer.append(this.saveRowCount);
        stringBuffer.append(',').append(l2).append(' ');
        stringBuffer.append("operation ").append(n).append(',');
        stringBuffer.append(l2 - l).append(' ');
        stringBuffer.append("txts ");
        stringBuffer.append(this.dataFileCache.database.txManager.getGlobalChangeTimestamp());
        this.dataFileCache.logDetailEvent(stringBuffer.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    public Iterator getIterator() {
        this.objectIterator.reset();
        return this.objectIterator;
    }

    static final class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType = 1;

        CachedObjectComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        public int compare(Object object, Object object2) {
            long l;
            switch (this.compareType) {
                case 1: {
                    l = ((CachedObject)object).getPos() - ((CachedObject)object2).getPos();
                    break;
                }
                case 2: {
                    l = ((CachedObject)object).getStorageSize() - ((CachedObject)object2).getStorageSize();
                    break;
                }
                default: {
                    return 0;
                }
            }
            return l == 0L ? 0 : (l > 0L ? 1 : -1);
        }

        @Override
        public int hashCode(Object object) {
            return object.hashCode();
        }

        @Override
        public long longKey(Object object) {
            return ((CachedObject)object).getPos();
        }
    }
}

