/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.util.Sort;

public class LocaleMapper {
    private static OraMapTable ISO_ORACLE_NAME_MAPPING = null;
    private static OraMapTable SUPERSET_MAPPING = null;
    private static final char M_C_DASH_CHAR = '-';
    private static final char M_C_UNDERBAR_CHAR = '_';
    public static final int ORACLE = 1;
    public static final int IANA = 2;
    public static final int JAVA = 3;
    public static final int EMAIL_WINDOWS = 4;
    public static final int EMAIL_UNIX = 5;
    public static final int WINDOWS = 6;
    public static final int UNIX = 7;
    private static final Set m_excShortToOraLang = new HashSet(2);
    private static final Locale EN_LOCALE;
    private static final String DEFAULT_EN_ORA_LANGUAGE = "ENGLISH";
    private static final String DEFAULT_ES_ORA_LANGUAGE = "LATIN AMERICAN SPANISH";
    private static final String ISO2022_JP;
    private static final String ISO2022_JP_OUTLOOK;
    private static final String ISO2022_JP_OUTLOOK_HWKANA;
    private static String m_OraISO2022JPEncoding;

    private LocaleMapper() {
    }

    public static String[] getAvailableIANACharacterSets() {
        return CachedArrayIANA2ORACLE.ianaCharacterSets.getArray();
    }

    public static String[] getAvailableOraCharacterSets() {
        return CachedArray.oraCharacterSets.getArray();
    }

    public static boolean isSupersetOf(int n, int n2) {
        if (SUPERSET_MAPPING == null) {
            SUPERSET_MAPPING = OraMapTable.getInstance(2);
        }
        if (SUPERSET_MAPPING == null) {
            return false;
        }
        HashMap hashMap = SUPERSET_MAPPING.getHashMapAttribute("SUPERSET");
        HashMap hashMap2 = (HashMap)hashMap.get(new Integer(n));
        return hashMap2.get(new Integer(n2)) != null;
    }

    public static String getIANACharacterSet(int n, String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = null;
        String string2 = string.toUpperCase(Locale.US);
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        switch (n) {
            case 1: {
                hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
                return (String)hashMap.get(string.toUpperCase(Locale.US));
            }
            case 3: {
                String string3 = null;
                if (string2.startsWith("X-ORACLE-") && string2.length() > 9) {
                    string3 = string2.substring(9).toUpperCase(Locale.US);
                    if (OraBoot.getInstance().getCharSetId(string3) == null) {
                        string3 = null;
                    }
                } else {
                    hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
                    string3 = (String)hashMap.get(string.toUpperCase(Locale.US));
                }
                if (string3 != null) {
                    HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
                    return (String)hashMap2.get(string3);
                }
                return null;
            }
            case 2: {
                return string;
            }
        }
        return null;
    }

    public static void setJavaCharacterSet(int n, String string, String string2) throws UnsupportedEncodingException {
        if (n != 2 || string == null || string2 == null) {
            return;
        }
        if (string.toUpperCase(Locale.US).equals("ISO-2022-JP")) {
            String string3 = string2.toUpperCase(Locale.US);
            if ("X-ORACLE-ISO2022-JP".equals(string3)) {
                m_OraISO2022JPEncoding = ISO2022_JP;
            } else if ("X-ORACLE-ISO2022-JP-OUTLOOK".equals(string3)) {
                m_OraISO2022JPEncoding = ISO2022_JP_OUTLOOK;
            } else if ("X-ORACLE-ISO2022-JP-OUTLOOK-HWKANA".equals(string3)) {
                m_OraISO2022JPEncoding = ISO2022_JP_OUTLOOK_HWKANA;
            } else {
                throw new UnsupportedEncodingException();
            }
        }
    }

    public static String getJavaCharacterSet(int n, String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = null;
        String string2 = string.toUpperCase(Locale.US);
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        switch (n) {
            case 1: {
                hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
                return (String)hashMap.get(string2);
            }
            case 2: {
                String string3;
                if (string.toUpperCase(Locale.US).equals("ISO-2022-JP")) {
                    return "X-ORACLE-" + m_OraISO2022JPEncoding;
                }
                if (string2.startsWith("X-ORACLE-") && string2.length() > 9) {
                    string3 = string2.substring(9).toUpperCase(Locale.US);
                    if (OraBoot.getInstance().getCharSetId(string3) != null) {
                        return string;
                    }
                } else {
                    hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
                    string3 = (String)hashMap.get(string.toUpperCase(Locale.US));
                }
                if (string3 != null) {
                    HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
                    return (String)hashMap2.get(string3);
                }
                return null;
            }
            case 3: {
                try {
                    "a".getBytes(string);
                    return string;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getOraCharacterSet(int n, String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = null;
        String string2 = string.toUpperCase(Locale.US);
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        switch (n) {
            case 2: {
                String string3 = null;
                if (string.toUpperCase(Locale.US).equals("ISO-2022-JP")) {
                    return m_OraISO2022JPEncoding;
                }
                if (string2.startsWith("X-ORACLE-") && string2.length() > 9) {
                    string3 = string2.substring(9).toUpperCase(Locale.US);
                    if (OraBoot.getInstance().getCharSetId(string3) != null) {
                        return string3;
                    }
                } else {
                    hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
                    string3 = (String)hashMap.get(string2);
                    return string3;
                }
                return null;
            }
            case 3: {
                if (string.toUpperCase(Locale.US).equals("ISO-2022-JP")) {
                    return m_OraISO2022JPEncoding;
                }
                if (string2.startsWith("X-ORACLE-") && string2.length() > 9) {
                    String string4 = string2.substring(9).toUpperCase(Locale.US);
                    if (OraBoot.getInstance().getCharSetId(string4) != null) {
                        return string4;
                    }
                } else {
                    hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
                    return (String)hashMap.get(string.toUpperCase(Locale.US));
                }
            }
            case 1: {
                String[] stringArray = OraBoot.getInstance().availableCharacterSets();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    return string;
                }
                break;
            }
        }
        return null;
    }

    public static Locale getJavaLocale(String string) {
        int n = string.indexOf(95);
        if (n < 0) {
            return LocaleMapper.getJavaLocale(string, "");
        }
        return LocaleMapper.getJavaLocale(string.substring(0, n), string.substring(n + 1));
    }

    public static Locale getJavaLocale(String string, String string2) {
        String string3;
        Serializable serializable;
        Object object;
        if (string == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        String string4 = string;
        String string5 = EN_LOCALE.getLanguage();
        if (!string4.equals("")) {
            object = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG");
            string5 = (String)object.get(string4.toUpperCase(Locale.US));
            if (string5 == null) {
                return null;
            }
        } else {
            string4 = "AMERICAN";
        }
        object = null;
        if (string2 == null || (object = string2.toUpperCase(Locale.US)) == null || ((String)object).equals("")) {
            serializable = OraBoot.getInstance();
            object = ((OraBoot)serializable).getTerritoryName(((OraBoot)serializable).getTerrIdFromLang(string4));
        }
        if ((string3 = (String)(serializable = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR")).get(object)) == null) {
            return null;
        }
        return new Locale(string5, string3);
    }

    public static String getOraLanguageFromShortName(String string) {
        return OraBoot.getInstance().getOraLangFromShort(string);
    }

    public static String getOraShortNameFromLanguage(String string) {
        return OraBoot.getInstance().getOraShortFromLang(string);
    }

    public static String getOraLanguage(Locale locale) {
        String string = LocaleMapper.getOraLocale(locale);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(95);
        return n < 0 ? string : string.substring(0, n);
    }

    public static String getOraTerritory(Locale locale) {
        String string = LocaleMapper.getOraLocale(locale);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(95);
        return n < 0 ? null : string.substring(n + 1);
    }

    public static String getOraLocale(Locale locale) {
        HashMap hashMap;
        String string;
        Cloneable cloneable;
        if (locale == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        String string2 = locale.getLanguage().equals("") ? EN_LOCALE.getLanguage() : locale.getLanguage();
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        String string3 = (String)hashMap2.get(string2);
        if (string3 == null) {
            return null;
        }
        String string4 = locale.getCountry();
        if (string4.equals("") && (string4 = (String)(cloneable = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_LANGUAGE_DEFAULT_TERRITORY")).get(string2)) == null) {
            return null;
        }
        cloneable = new Locale(string2, string4);
        HashMap hashMap3 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_LOCALE_2_ORACLE_LOCALE");
        String string5 = (String)hashMap3.get(((Locale)cloneable).toString());
        if (string5 != null) {
            return string5;
        }
        if ("es".equals(string2)) {
            string3 = DEFAULT_ES_ORA_LANGUAGE;
        }
        return (string = (String)(hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR")).get(string4)) != null ? string3 + "_" + string : null;
    }

    public static String[] getIANACharSetFromLocale(int n, Locale locale) {
        return LocaleMapper.getIANACharSetFromOraLang(n, LocaleMapper.getOraLanguage(locale));
    }

    public static String[] getIANACharSetFromOraLang(int n, String string) {
        String[] stringArray = LocaleMapper.getOraCharSetFromOraLang(n, string);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            arrayList.add(LocaleMapper.getIANACharacterSet(1, stringArray[i]));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getOraCharSetFromOraLang(int n, String string) {
        OraMapTable oraMapTable = OraMapTable.getInstance(3);
        String[] stringArray = null;
        switch (n) {
            case 4: {
                HashMap hashMap = oraMapTable.getHashMapAttribute("EMAIL_LANG_2_CHARSET_WIN");
                stringArray = (String[])hashMap.get(string);
                if (stringArray != null) break;
                return new String[]{"UTF8"};
            }
            case 5: {
                HashMap hashMap = oraMapTable.getHashMapAttribute("EMAIL_LANG_2_CHARSET");
                stringArray = (String[])hashMap.get(string);
                if (stringArray != null) break;
                return new String[]{"UTF8"};
            }
            case 6: {
                if (string == null) {
                    return null;
                }
                stringArray = OraBoot.getInstance().getLocalCharsetsWin(string).toArray(new String[0]);
                break;
            }
            case 7: {
                if (string == null) {
                    return null;
                }
                stringArray = OraBoot.getInstance().getLocalCharsetsUnix(string).toArray(new String[0]);
                break;
            }
            default: {
                return new String[0];
            }
        }
        return stringArray;
    }

    public static String getOraLinguisticSortFromLocale(Locale locale) {
        String string = LocaleMapper.getOraLanguage(locale);
        if (string == null) {
            return null;
        }
        return OraBoot.getInstance().getLingFromLang(string);
    }

    public static String getOraLangFromJavaLang(String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return (hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG")) != null ? hashMap.get(string.toLowerCase(Locale.US)) : null;
    }

    public static String getJavaLangFromOraLang(String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return (hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG")) != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    public static String getOraTerrFromJavaTerr(String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return (hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR")) != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    public static String getJavaTerrFromOraTerr(String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return (hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR")) != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    public static Locale getLocaleFromString(String string) {
        int n = string.indexOf(45);
        int n2 = string.indexOf(95, n + 1);
        if (n < 0 && n2 > 0) {
            n = n2;
            n2 = string.indexOf(95, n + 1);
        }
        if (n < 0) {
            return new Locale(string, "");
        }
        if (n2 < 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new Locale(string2, string3);
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + 1, n2);
        return new Locale(string4, string5, string.substring(n2 + 1));
    }

    static {
        m_excShortToOraLang.add("NUMERIC DATE LANGUAGE");
        m_excShortToOraLang.add("BENGALI");
        EN_LOCALE = new Locale("en", "US");
        ISO2022_JP = new String("ISO2022-JP");
        ISO2022_JP_OUTLOOK = new String("ISO2022-JP-OUTLOOK");
        ISO2022_JP_OUTLOOK_HWKANA = new String("ISO2022-JP-OUTLOOK-HWKANA");
        m_OraISO2022JPEncoding = ISO2022_JP;
    }

    private static class CachedArrayIANA2ORACLE {
        public static final CachedArrayIANA2ORACLE ianaCharacterSets = new CachedArrayIANA2ORACLE(OraMapTable.getInstance(1).getHashMapAttribute("IANA_2_ORACLE").keySet(), OraMapTable.getInstance(1).getElementAttributes("IANA_2_ORACLE"));
        private final String[] m_array;

        private CachedArrayIANA2ORACLE(Set set, Map map) {
            ArrayList<String> arrayList = new ArrayList<String>(set.size());
            int n = 0;
            for (String string : set) {
                Map map2 = (Map)map.get(string);
                String string2 = (String)map2.get("p1");
                if (!"invalid".equals(string2)) {
                    arrayList.add(string);
                }
                ++n;
            }
            Collections.sort(arrayList);
            this.m_array = arrayList.toArray(new String[0]);
        }

        public String[] getArray() {
            return this.m_array;
        }
    }

    private static class CachedArray {
        public static final CachedArray oraCharacterSets = new CachedArray(OraMapTable.getInstance(1).getHashMapAttribute("ORACLE_2_IANA").keySet());
        private final String[] m_array;

        private CachedArray(Set set) {
            this.m_array = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_array[n] = (String)iterator.next();
                ++n;
            }
            Sort.quickSort(this.m_array);
        }

        public String[] getArray() {
            return this.m_array;
        }
    }
}

