/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.SINT32;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeSINT32
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5465988397261455848L;
    boolean isBigEndian = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    protected OracleTypeSINT32(boolean bl) {
        this.isBigEndian = bl;
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    @Override
    public Datum toDatumInternal(Object object, OracleConnection oracleConnection) throws SQLException {
        int n2 = 0;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            n2 = ((Number)object).intValue();
        } else if (object instanceof NUMBER) {
            NUMBER nUMBER = (NUMBER)object;
            n2 = nUMBER.intValue();
        } else {
            NUMBER nUMBER = new NUMBER(object);
            n2 = nUMBER.intValue();
        }
        return SINT32.valueOf(n2, this.isBigEndian);
    }

    @Override
    public Datum[] toDatumArrayInternal(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Datum[] datumArray = SINT32.createArray(n2);
        long l3 = l2 + (long)n2;
        int n3 = 0;
        while (l2 < l3) {
            datumArray[n3] = this.toDatumInternal(objectArray[(int)l2], oracleConnection);
            ++n3;
            ++l2;
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 2;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n3 = SINT32.bytesToInt(byArray, this.isBigEndian);
        Object object = null;
        switch (n2) {
            case 1: {
                object = new NUMBER(n3);
                break;
            }
            case 2: {
                object = new BigDecimal(n3);
                break;
            }
            case 3: {
                object = NUMBER.toBytes(n3);
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(null, 23);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

