/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CCharAccessor
extends CharAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    boolean underlyingLong = false;
    private T4CMarshaller marshaller = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CCharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CCharAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n8;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe) {
            this.setNull(this.lastRowProcessed, true);
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer);
    }

    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        if (this.definedColumnType == 0) {
            nUMBER = super.getNUMBER(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                return T4CVarcharAccessor.StringToNUMBER(string.trim());
            }
        }
        return nUMBER;
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.definedColumnType == 0) {
            dATE = super.getDATE(n2);
        } else {
            Date date = this.getDate(n2);
            if (date != null) {
                dATE = new DATE(date);
            }
        }
        return dATE;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.definedColumnType == 0) {
            tIMESTAMP = super.getTIMESTAMP(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMP = new TIMESTAMP(timestamp);
            }
        }
        return tIMESTAMP;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPTZ = super.getTIMESTAMPTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPTZ;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPLTZ = super.getTIMESTAMPLTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPLTZ;
    }

    @Override
    RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        if (this.definedColumnType == 0) {
            rAW = super.getRAW(n2);
        } else if (!this.rowNull[n2]) {
            rAW = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(n2)) : new RAW(super.getBytes(n2));
        }
        return rAW;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(n2);
        }
        Datum datum = null;
        if (this.rowNull == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.rowNull[n2]) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(n2);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(n2);
                }
                case 91: {
                    return this.getDATE(n2);
                }
                case 92: {
                    return this.getDATE(n2);
                }
                case 93: {
                    return this.getTIMESTAMP(n2);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(n2);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return datum;
    }

    @Override
    byte getByte(int n2) throws SQLException {
        byte by = 0;
        if (this.definedColumnType == 0) {
            by = super.getByte(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                by = nUMBER.byteValue();
            }
        }
        return by;
    }

    @Override
    int getInt(int n2) throws SQLException {
        int n3 = 0;
        if (this.definedColumnType == 0) {
            n3 = super.getInt(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                n3 = nUMBER.intValue();
            }
        }
        return n3;
    }

    @Override
    short getShort(int n2) throws SQLException {
        short s2 = 0;
        if (this.definedColumnType == 0) {
            s2 = super.getShort(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                s2 = nUMBER.shortValue();
            }
        }
        return s2;
    }

    @Override
    long getLong(int n2) throws SQLException {
        long l2 = 0L;
        if (this.definedColumnType == 0) {
            l2 = super.getLong(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                l2 = nUMBER.longValue();
            }
        }
        return l2;
    }

    @Override
    float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        if (this.definedColumnType == 0) {
            f2 = super.getFloat(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                f2 = nUMBER.floatValue();
            }
        }
        return f2;
    }

    @Override
    double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        if (this.definedColumnType == 0) {
            d2 = super.getDouble(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                d2 = nUMBER.doubleValue();
            }
        }
        return d2;
    }

    @Override
    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.definedColumnType == 0) {
            date = super.getDate(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    date = new Date(T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nArray).getTimeInMillis());
                }
                catch (NumberFormatException numberFormatException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return date;
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.definedColumnType == 0) {
            timestamp = super.getTimestamp(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                    timestamp = new Timestamp(calendar.getTimeInMillis());
                    timestamp.setNanos(nArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return timestamp;
    }

    @Override
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.definedColumnType == 0) {
            time = super.getTime(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                    time = new Time(calendar.getTimeInMillis());
                }
                catch (NumberFormatException numberFormatException) {
                    SQLException sQLException = DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return time;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.CHAR;
        }
        return this.marshaller;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        if (this.isUnexpected()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.isNull(n2)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n2);
            }
            case 4: {
                return this.getInt(n2);
            }
            case -6: {
                return this.getByte(n2);
            }
            case 5: {
                return this.getShort(n2);
            }
            case -7: 
            case 16: {
                return this.getBoolean(n2);
            }
            case -5: {
                return this.getLong(n2);
            }
            case 7: {
                return Float.valueOf(this.getFloat(n2));
            }
            case 6: 
            case 8: {
                return this.getDouble(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesFromHexChars(n2);
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    AccessorPrototype newPrototype(int n2) {
        assert (n2 >= 0) : "numRows: " + n2;
        AccessorPrototype accessorPrototype = new AccessorPrototype(n2, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement oracleStatement) throws SQLException {
                T4CCharAccessor t4CCharAccessor = new T4CCharAccessor(oracleStatement, T4CCharAccessor.this.describeMaxLength, T4CCharAccessor.this.nullable, -1, T4CCharAccessor.this.precision, T4CCharAccessor.this.scale, -1, -1, T4CCharAccessor.this.formOfUse, T4CCharAccessor.this.oacmxl, T4CCharAccessor.this.definedColumnType, T4CCharAccessor.this.definedColumnSize, null);
                this.initializeRowData(t4CCharAccessor);
                return t4CCharAccessor;
            }
        };
        return accessorPrototype;
    }
}

