<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:equals val1="{@file1}" val2="{@file1}">
	アップロードされたファイルを読み込みます。
	<!-- アップロードされたファイルは、UPLOAD_FILES をキーに、Listオブジェクトに格納されています。 -->
	<c:forEach items="${UPLOAD_FILES}" var="filename" varStatus="status" >
		<c:out value="${filename}" />
		<og:directTableInsert
			dbid		= "{@DBID}"
			commitBatch	= "{@commitBatch}"
			command		= "{@command}" 
			fileURL		= "{@USER.ID}/{@TEMP_DIR}"
			filename	= "${filename}"
			table		= "{@table}"
			columns		= "{@columns}"
			omitNames	= "{@omitNames}"
			skipRowCount= "{@skipRowCount}"
			maxRowCount	= "0"
			sheetNos	= "{@sheetNos}"
			nullBreakClm	= "{@nullBreakClm}"
			useNumber		= "{@useNumber}"
			useRenderer		= "{@useRenderer}"
			adjustColumns	= "{@adjustColumns}"
			checkColumns	= "{@checkColumns}"
			debug		= "{@debug}"
		>
			{@INSQL}
		</og:directTableInsert>
	</c:forEach>
	<og:file action="delete" fileURL="{@USER.ID}/{@TEMP_DIR}" />
</og:equals>

<og:equals val1="{@insertDIR}" val2="{@insertDIR}">
	ディレクトリ指定で、ファイルを読み取って、処理します。
	<!-- ファイルリストをListオブジェクトにコピーして、パラメータにセットします。 -->
	<og:file action="list" fileURL="{@insertDIR}" />

	<!-- ファイルリストは、"list" キーに、Listオブジェクトに格納されています。 -->
	<c:forEach items="${list}" var="filename" varStatus="status" >
		<c:out value="${filename}" /><br/>
		<og:directTableInsert
			dbid		= "{@DBID}"
			commitBatch	= "{@commitBatch}"
			command		= "{@command}" 
			fileURL		= "{@insertDIR}"
			filename	= "${filename}"
			table		= "{@table}"
			columns		= "{@columns}"
			omitNames	= "{@omitNames}"
			skipRowCount= "{@skipRowCount}"
			maxRowCount	= "0"
			sheetNos	= "{@sheetNos}"
			nullBreakClm	= "{@nullBreakClm}"
			useNumber		= "{@useNumber}"
			useRenderer		= "{@useRenderer}"
			adjustColumns	= "{@adjustColumns}"
			checkColumns	= "{@checkColumns}"
			debug		= "{@debug}"
		>
			{@INSQL}
		</og:directTableInsert>
	</c:forEach>
</og:equals>
</jsp:root>
