/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix3D;
import processing.opengl.PGraphicsOpenGL;

public abstract class NyARPsgBaseClass {
    public final float FRUSTUM_DEFAULT_NEAR_CLIP = 100.0f;
    public final float FRUSTUM_DEFAULT_FAR_CLIP = 100000.0f;
    public static final String VERSION = "NyAR4psg/1.3.1;NyARToolkit/4.1.1";
    protected PApplet _ref_papplet;
    protected final PMatrix3D _ps_background_mv = new PMatrix3D();
    protected NyAR4PsgConfig _config;
    private float _clip_far;
    private float _clip_near;
    private static final PMatrix3D _lh_mat = new PMatrix3D(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    protected NyARPsgBaseClass() {
    }

    protected void initInstance(PApplet parent, NyAR4PsgConfig i_config) throws NyARException {
        this._ref_papplet = parent;
        this._config = i_config;
        this.setARClipping(100.0f, 100000.0f);
    }

    public abstract PMatrix3D getProjectionMatrix();

    public abstract PMatrix3D getProjectionMatrix(PMatrix3D var1);

    public void drawBackground(PImage i_img) {
        PApplet pa = this._ref_papplet;
        PGraphicsOpenGL pgl = (PGraphicsOpenGL)pa.g;
        pgl.pushProjection();
        this.setBackgroundOrtho(i_img.width, i_img.height);
        pa.pushMatrix();
        pa.setMatrix(this._ps_background_mv);
        pa.image(i_img, (float)(-i_img.width / 2), (float)(-i_img.height / 2));
        pa.popMatrix();
        pgl.popProjection();
    }

    public void setARClipping(float i_near, float i_far) {
        this._clip_far = i_far;
        this._clip_near = i_near;
        this._ps_background_mv.reset();
        this._ps_background_mv.translate(0.0f, 0.0f, -i_far);
    }

    public void setBackgroundOrtho(int i_width, int i_height) {
        this._ref_papplet.ortho(0.0f, (float)i_width, 0.0f, (float)i_height, this._clip_near, this._clip_far + 1.0f);
    }

    public void setARPerspective() {
        this.setPerspective(this.getProjectionMatrix());
    }

    public void setPerspective(PMatrix3D i_projection) {
        float far = i_projection.m23 / (i_projection.m22 + 1.0f);
        float near = i_projection.m23 / (i_projection.m22 - 1.0f);
        this._ref_papplet.frustum((i_projection.m02 - 1.0f) * near / i_projection.m00, (i_projection.m02 + 1.0f) * near / i_projection.m00, (i_projection.m12 - 1.0f) * near / i_projection.m11, (i_projection.m12 + 1.0f) * near / i_projection.m11, near, far);
    }

    protected static void PMatrix2GLProjection(PMatrix3D i_in, float[] o_out) {
        o_out[0] = i_in.m00;
        o_out[1] = i_in.m10;
        o_out[2] = i_in.m20;
        o_out[3] = i_in.m30;
        o_out[4] = i_in.m01;
        o_out[5] = i_in.m11;
        o_out[6] = i_in.m21;
        o_out[7] = i_in.m31;
        o_out[8] = i_in.m02;
        o_out[9] = i_in.m12;
        o_out[10] = i_in.m22;
        o_out[11] = i_in.m32;
        o_out[12] = i_in.m03;
        o_out[13] = i_in.m13;
        o_out[14] = i_in.m23;
        o_out[15] = i_in.m33;
    }

    protected static void PMatrix2GLProjection(PMatrix3D i_in, double[] o_out) {
        o_out[0] = i_in.m00;
        o_out[1] = i_in.m10;
        o_out[2] = i_in.m20;
        o_out[3] = i_in.m30;
        o_out[4] = i_in.m01;
        o_out[5] = i_in.m11;
        o_out[6] = i_in.m21;
        o_out[7] = i_in.m31;
        o_out[8] = i_in.m02;
        o_out[9] = i_in.m12;
        o_out[10] = i_in.m22;
        o_out[11] = i_in.m32;
        o_out[12] = i_in.m03;
        o_out[13] = i_in.m13;
        o_out[14] = i_in.m23;
        o_out[15] = i_in.m33;
    }

    protected static void nyarMat2PsMat(NyARDoubleMatrix44 i_src, PMatrix3D i_dst) {
        i_dst.m00 = (float)i_src.m00;
        i_dst.m01 = (float)i_src.m01;
        i_dst.m02 = (float)i_src.m02;
        i_dst.m03 = (float)i_src.m03;
        i_dst.m10 = (float)i_src.m10;
        i_dst.m11 = (float)i_src.m11;
        i_dst.m12 = (float)i_src.m12;
        i_dst.m13 = (float)i_src.m13;
        i_dst.m20 = (float)i_src.m20;
        i_dst.m21 = (float)i_src.m21;
        i_dst.m22 = (float)i_src.m22;
        i_dst.m23 = (float)i_src.m23;
        i_dst.m30 = (float)i_src.m30;
        i_dst.m31 = (float)i_src.m31;
        i_dst.m32 = (float)i_src.m32;
        i_dst.m33 = (float)i_src.m33;
    }

    protected static void matResult2PMatrix3D(NyARDoubleMatrix44 i_src, int i_mode, PMatrix3D o_pmatrix) {
        o_pmatrix.m00 = (float)i_src.m00;
        o_pmatrix.m01 = (float)i_src.m01;
        o_pmatrix.m02 = (float)i_src.m02;
        o_pmatrix.m03 = (float)i_src.m03;
        o_pmatrix.m10 = (float)i_src.m10;
        o_pmatrix.m11 = (float)i_src.m11;
        o_pmatrix.m12 = (float)i_src.m12;
        o_pmatrix.m13 = (float)i_src.m13;
        o_pmatrix.m20 = (float)(-i_src.m20);
        o_pmatrix.m21 = (float)(-i_src.m21);
        o_pmatrix.m22 = (float)(-i_src.m22);
        o_pmatrix.m23 = (float)(-i_src.m23);
        o_pmatrix.m30 = 0.0f;
        o_pmatrix.m31 = 0.0f;
        o_pmatrix.m32 = 0.0f;
        o_pmatrix.m33 = 1.0f;
        if (i_mode == 1) {
            o_pmatrix.apply(_lh_mat);
        }
    }

    protected static void matResult2GLArray(NyARDoubleMatrix44 i_src, double[] o_gl_array) {
        o_gl_array[0] = i_src.m00;
        o_gl_array[4] = i_src.m01;
        o_gl_array[8] = i_src.m02;
        o_gl_array[12] = i_src.m03;
        o_gl_array[1] = -i_src.m10;
        o_gl_array[5] = -i_src.m11;
        o_gl_array[9] = -i_src.m12;
        o_gl_array[13] = -i_src.m13;
        o_gl_array[2] = -i_src.m20;
        o_gl_array[6] = -i_src.m21;
        o_gl_array[10] = -i_src.m22;
        o_gl_array[14] = -i_src.m23;
        o_gl_array[3] = 0.0;
        o_gl_array[7] = 0.0;
        o_gl_array[11] = 0.0;
        o_gl_array[15] = 1.0;
    }
}

