﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using NT2chView.NtFile;

namespace NT2chView.NtNet
{
    public sealed partial class NTHttpAccess
    {
        
        public static string UserCloudCheckUser(string url, string userName, string passwd)
        {
            String result = null;

            NTHttpPostClient client = null;
            HttpWebResponse httpResp = null;
            Stream stream = null;
            StreamReader sr = null;

            try
            {
                client = new NTHttpPostClient(url,url,url);

                Encoding enc = Encoding.GetEncoding("UTF-8");

                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(userName).
                    Append("&passwd=").Append(passwd);

                byte[] data = System.Text.Encoding.ASCII.GetBytes(postData.ToString());
                client.setPostData(data);

                httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                stream = httpResp.GetResponseStream();

                sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            finally
            {
                if (sr != null)
                    sr.Close();
                if (stream != null)
                    stream.Close();
                if (httpResp != null)
                    httpResp.Close();
            }
            return result;
        }
        
        public static string UserCloudQueryReadCountList(String uid, String passwd,
            string boardName)
        {
            String result = null;

            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_query_readcnt_list2_db.php"; ;
            //if (NTUserPreference.AESEnabled)
            //    url = NTCloud.AES_QUERY_READCNT_LIST_URL;
           // else
             //   url = NTCloud.QUERY_READCNT_LIST_URL;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                String s;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(boardName);
                else
                    s = NTTextUtiles.encodeBase64URL(boardName);

                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(passwd).
                    Append("&board_name=").Append(s);
                if (NTUserPreference.AESEnabled)
                    postData.Append("&aes_enable=1");

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, Encoding.GetEncoding("UTF-8"));

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string UserCloudUpdateReadCount(
            string boardName, string datName, string kind, string value)
        {
            String result = null;

            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_update_readcnt_db.php"; ;
            //if (NTUserPreference.AESEnabled)
            //    url = NTCloud.AES_QUERY_READCNT_LIST_URL;
            // else
            //   url = NTCloud.QUERY_READCNT_LIST_URL;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);

                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd();


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                String s1, s2;
                if (NTUserPreference.AESEnabled)
                {
                    s1 = NTTextUtiles.aesEncodeBase64URL(boardName);
                    s2 = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    s1 = NTTextUtiles.encodeBase64URL(boardName);
                    s2 = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashed).
                    Append("&board_name=").Append(s1).
                    Append("&dat_name=").Append(s2).
                    Append("&res_number=").Append(value).
                    Append("&record_type=").Append(kind);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, Encoding.GetEncoding("UTF-8"));

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;

        }

        public static string UserCloudUpdateAttrValue(
            string boardName, string datName, string kind, string value)
        {
            String result = null;

            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_add_attributes_db.php";
            
            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);

                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd();


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                String s1, s2;
                if (NTUserPreference.AESEnabled)
                {
                    s1 = NTTextUtiles.aesEncodeBase64URL(boardName);
                    s2 = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    s1 = NTTextUtiles.encodeBase64URL(boardName);
                    s2 = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashed).
                    Append("&board_name=").Append(s1).
                    Append("&dat_name=").Append(s2).
                    Append("&res_number=").Append(value).
                    Append("&type1=").Append(kind);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, Encoding.GetEncoding("UTF-8"));

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;

        }

        public static string UserCloudDeleteAttrValue(
            string boardName, string datName, string kind, string value)
        {
            String result = null;

            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_delete_attribute_db.php";

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);

                string uid = NTUserPreference.NTCloudID;
                string hashed = NTUserPreference.NTUserCloudGetHashedPasswd();


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                String s1, s2;
                if (NTUserPreference.AESEnabled)
                {
                    s1 = NTTextUtiles.aesEncodeBase64URL(boardName);
                    s2 = NTTextUtiles.aesEncodeBase64URL(datName);
                }
                else
                {
                    s1 = NTTextUtiles.encodeBase64URL(boardName);
                    s2 = NTTextUtiles.encodeBase64URL(datName);
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashed).
                    Append("&board_name=").Append(s1).
                    Append("&dat_name=").Append(s2).
                    Append("&res_number=").Append(value).
                    Append("&record_type=").Append(kind);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, Encoding.GetEncoding("UTF-8"));

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;

        }

        public static string UserCloudQueryAttrValue(string boardName, string datName)
        {
            String result = null;

            string uid = NTUserPreference.NTCloudID;
            string passwd = NTUserPreference.NTUserCloudGetHashedPasswd();

            string url = NTUserPreference.NTUserCloudScriptUrl
                + "nc_query_thread_attribute_list_db.php";
            
            NTHttpPostClient client = null;

            try
            {
                string extraParam;
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                if (NTUserPreference.AESEnabled)
                {
                    boardName = NTTextUtiles.aesEncodeBase64URL(boardName);
                    datName = NTTextUtiles.aesEncodeBase64URL(datName);
                    extraParam = "&type1=5&type2=6";
                }
                else
                {
                    boardName = NTTextUtiles.encodeBase64URL(boardName);
                    datName = NTTextUtiles.encodeBase64URL(datName);
                    extraParam = "&type1=2&type2=3";
                }
                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(passwd).
                    Append("&board_name=").Append(boardName).
                    Append("&dat_name=").Append(datName).
                    Append(extraParam);

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, Encoding.GetEncoding("UTF-8"));

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        public static string UserCloudQueryReadHistory(String uid, String passwd)
        {
            if (NTUserPreference.AESEnabled)
                return UserCloudQueryHistory(uid, passwd, 4);
            else
                return UserCloudQueryHistory(uid, passwd, 1);
        }
        public static string UserCloudQueryWriteHistory(String uid, String passwd)
        {
            if (NTUserPreference.AESEnabled)
                return UserCloudQueryHistory(uid, passwd, 5);
            else
                return UserCloudQueryHistory(uid, passwd, 2);
        }
        public static string UserCloudQueryBookmarkHistory(String uid, String passwd)
        {
            if (NTUserPreference.AESEnabled)
                return UserCloudQueryHistory(uid, passwd, 6);
            else
                return UserCloudQueryHistory(uid, passwd, 3);
        }
        private static string UserCloudQueryHistory(String uid, String hashedPasswd, int type)
        {
            String result = null;
            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_query_record_by_type_db.php";
            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, NTCloud.SERVER_ROOT, NTCloud.SERVER_ROOT);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashedPasswd).
                    Append("&record_type=").Append(type.ToString());

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }



        public static bool UserCloudGetNgWord()
        {
            string url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_NGWORD_TXT;
            string filePath;
            string attrPath;
            if (NTUserPreference.AESEnabled)
            {
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGWORD_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGWORD_ATTR_FILE_NAME;
            }
            else
            {
                filePath = NTFileAccess.getRootPath() + NTFileAccess.NGWORD_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGWORD_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }
        public static bool UserCloudGetNgId()
        {
            string url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_NGID_TXT;
            string filePath;
            string attrPath;
            if (NTUserPreference.AESEnabled)
            {
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGID_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGID_ATTR_FILE_NAME;
            }
            else
            {
                filePath = NTFileAccess.getRootPath() + NTFileAccess.NGID_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGID_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }
        public static bool UserCloudGetNgName()
        {
            string filePath;
            string attrPath;
            string url = NTUserPreference.NTUserCloudFileUrl + NTCloud.USER_CLOUD_NGNAME_TXT;
            if (NTUserPreference.AESEnabled)
            {
                filePath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGNAME_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.AES_NGNAME_ATTR_FILE_NAME;
            }
            else
            {
                 filePath = NTFileAccess.getRootPath() + NTFileAccess.NGNAME_FILE_NAME;
                attrPath = NTFileAccess.getRootPath() + NTFileAccess.NGNAME_ATTR_FILE_NAME;
            }
            return ntGetNgItem(url, filePath, attrPath);
        }

        public static String UserCloudUpdateFavoriteBoards(String uid, String passwd,
            List<String> boardList)
        {
            return UserCloudUploadLinesFile("fb03.txt", uid, passwd, boardList);
        }

        public static String UserCloudUpdateFavoriteThreads(String uid, String passwd,
           List<String> threadList, List<String> tagList)
        {
            string result1 = UserCloudUploadLinesFile("ft03.txt", uid, passwd, threadList);
            string result2 = UserCloudUploadLinesFile("ftab03.txt", uid, passwd, tagList);
            //String result = null;
            if (result1 != null)
            {
                if (result2 != null)
                    return result1 + result2;
                else
                    return result1;
            }
            return result2;

        }

        public static String UserCloudUploadThreadHistoryList(string uid, string passwd,
            List<string> historyList)
        {
            return UserCloudUploadLinesFile("histab03.txt", uid, passwd, historyList);
        }

        public static String UserCloudDeleteExternalBoards(string description)
        {
            return UserCloudDeleteLineFromFile("exboard03.txt", description);
        }

        public static String UserCloudUploadExternalBoards(string description)
        {
            return UserCloudInsertLineIntoFile("exboard03.txt", description);
        }

        public static String UserCloudUploadNgWord(string uid, string passwd,
            List<string> ngList, bool append)
        {
            if (append)
            {
                return UserCloudInsertLinesIntoFile("ngwd03.txt", uid, passwd, ngList);
            }
            else
            {
                return UserCloudUploadLinesFile("ngwd03.txt", uid, passwd, ngList);
            }
        }

        public static String UserCloudUploadNgId(string uid, string passwd,
            List<string> ngList, bool append)
        {
            if (append)
            {
                return UserCloudInsertLinesIntoFile("ngid03.txt", uid, passwd, ngList);
            }
            else
            {
                return UserCloudUploadLinesFile("ngid03.txt", uid, passwd, ngList);
            }
        }

        public static String UserCloudUploadNgName(string uid, string passwd,
            List<string> ngList, bool append)
        {
            if (append)
            {
                return UserCloudInsertLinesIntoFile("ngnm03.txt", uid, passwd, ngList);
            }
            else
            {
                return UserCloudUploadLinesFile("ngnm03.txt", uid, passwd, ngList);
            }
        }


        private static String UserCloudUploadLinesFile(string fileName, String uid, String passwd,
            List<String> list)
        {
            String result = null;
            if (null == list)
            {
                return null;
            }

            String url = NTUserPreference.NTUserCloudScriptUrl + "nc_write_file.php"; ;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(passwd).
                    Append("&file_name=").Append(fileName).Append("&data=");

                int len = list.Count;
                for (int i = 0; i < len; i++)
                {
                    String s;
                    if (NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(list[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(list[i]);

                    postData.Append(s).Append('\n');
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        private static String UserCloudInsertLineIntoFile(string fileName, string description)
        {
            string uid = NTUserPreference.NTCloudID;
            string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
            //NTCrypt.getSHA256Hashed(
              //  NTUserPreference.NTCloudPSS+NTUserPreference.NTUserCloudSeed);

            string result = null;
            if (null == description || uid == null )//|| passwd == null)
            {
                return null;
            }

            string url = NTUserPreference.NTUserCloudScriptUrl + "nc_insert_lines_file.php"; ;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                string s;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(description);
                else
                    s = NTTextUtiles.encodeBase64URL(description);


                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashed).
                    Append("&file_name=").Append(fileName).Append("&num=1&n1=").Append(s);


                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        private static string UserCloudInsertLinesIntoFile(string fileName,
                string uid, string hashed, List<string> list)
        {
            //string uid = NTUserPreference.NTCloudID;
            //string hashed = NTCrypt.getSHA256Hashed(
            //    NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);

            string result = null;
            if (null == list || 0 == list.Count || uid == null || hashed == null)
            {
                return null;
            }

            string url = NTUserPreference.NTUserCloudScriptUrl + "nc_insert_lines_file.php"; ;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);

                int num = list.Count;

                StringBuilder postData =
                    new StringBuilder(256).Append("user=").Append(uid).
                    Append("&hashed_passwd=").Append(hashed).
                    Append("&file_name=").Append(fileName).Append("&num=").Append(num);

                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);
                for (int i = 0; i < num; i++)
                {
                    string s;
                    if (NTUserPreference.AESEnabled)
                        s = NTTextUtiles.aesEncodeBase64URL(list[i]);
                    else
                        s = NTTextUtiles.encodeBase64URL(list[i]);
                    postData.Append("&n").Append(i+1).Append("=").Append(s);
                }

                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

        private static String UserCloudDeleteLineFromFile(string fileName, string description)
        {
            string uid = NTUserPreference.NTCloudID;
            string hashed = NTUserPreference.NTUserCloudGetHashedPasswd(); 
            //NTCrypt.getSHA256Hashed(
              //  NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);

            string result = null;
            if (null == description || uid == null || hashed == null)
            {
                return null;
            }

            string url = NTUserPreference.NTUserCloudScriptUrl + "nc_delete_lines_file.php"; ;

            NTHttpPostClient client = null;

            try
            {
                client = new NTHttpPostClient(url, url, url);


                Encoding enc = Encoding.GetEncoding(NTAppState.HOST_2CH_ENCODING);

                string s;
                if (NTUserPreference.AESEnabled)
                    s = NTTextUtiles.aesEncodeBase64URL(description);
                else
                    s = NTTextUtiles.encodeBase64URL(description);

                StringBuilder postData =
                   new StringBuilder(256).Append("user=").Append(uid).
                   Append("&hashed_passwd=").Append(hashed).
                   Append("&file_name=").Append(fileName).Append("&num=1&n1=").Append(s);


                byte[] data = enc.GetBytes(postData.ToString());
                client.setPostData(data);

                HttpWebResponse httpResp = client.execute();

                NTDebug.l(httpResp.StatusCode.ToString());


                Stream stream = httpResp.GetResponseStream();

                StreamReader sr = new StreamReader(stream, enc);

                result = sr.ReadToEnd();

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }

            return result;
        }

    }
}
