﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView.NtHtml
{
    public enum X_CONFIRM_RESULT {
        FALSE,
        ERROR,
        CHECK,
        COOKIE,
        SUCCESS,
        NONE
    }

    sealed class NTHtmlWriteResParser
    {

        public static X_CONFIRM_RESULT validateResult(NTHtmlParser htmlParser) {
		   
		    List<String> commentList = htmlParser.mCommentList;
		    X_CONFIRM_RESULT id = X_CONFIRM_RESULT.NONE;
		    foreach(String s in commentList){
			    int n = s.IndexOf("2ch_X:");
			    if(n < 0){
				    continue;
			    }
			    if(0 == s.IndexOf("true", n+6)){
				    id = X_CONFIRM_RESULT.SUCCESS;
				    break;
			    }else if(0 == s.IndexOf("false", n+6)){
				    id = X_CONFIRM_RESULT.FALSE;
				    break;
			    }else if(0 == s.IndexOf("error", n+6)){
				    id = X_CONFIRM_RESULT.ERROR;
				    break;
			    }else if(0 == s.IndexOf("check", n+6)){
				    id = X_CONFIRM_RESULT.CHECK;
				    break;
			    }else if(0 == s.IndexOf("cookie", n+6)){
				    id = X_CONFIRM_RESULT.COOKIE;
				    break;
			    }	
		    }
		
		    if( X_CONFIRM_RESULT.NONE != id)
                return id;


            if(X_CONFIRM_RESULT.NONE == id){
			    String title = htmlParser.getTitle();
			    if(null != title){
				    if(0 <= title.IndexOf("書きこみました")){
					    id = X_CONFIRM_RESULT.SUCCESS;
				    }else if(0 <= title.IndexOf("ＥＲＲＯＲ")){
					    id = X_CONFIRM_RESULT.ERROR;
                    }
                    else if (0 <= title.IndexOf("ERROR"))
                    {
                        id = X_CONFIRM_RESULT.ERROR;
                    }
                    else if (0 <= title.IndexOf("お茶でも"))
                    {
					    id = X_CONFIRM_RESULT.CHECK;
				    }else if(0 <= title.IndexOf("書き込み確認")){
					    id = X_CONFIRM_RESULT.COOKIE;	
				    }
			    }
		    }
            return id;
	    }

    }
}
