﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NT2chView.NtFile
{
    sealed class NTPersistentFileAccess
    {
        const string ROOTDIR_NAME = @"\PersistentData";
        const string OPENED_BOARD_LIST_FILE_NAME = @"\OpenedBoardList.txt";
        const string OPENED_THREAD_LIST_FILE_NAME = @"\OpenedThreadList.txt";
        const string WRITE_HISTORY_FILE_NAME = @"\WriteHistory.txt";
        const string USER_PREFERENCE_FILE_NAME = @"\UserPreference.txt";
        const string AA_DATA_FILE_NAME = @"\AA.txt";
        const string MENU_CMD_FILE_NAME = @"\MenuCommand.txt";
        static string[] DEFAULT_CMD_STRINGS = {
                                                 "# MenuCommand.txt",
                                                 "# 書式：　メニュー表示文字列 , プログラム名, パラメーター",
                                                 "# ",
                                                 "# メニュー表示文字列：　この文字列がポップアップメニューの項目に表示されます",
                                                 "# プログラム名：　メニューが選択された時に起動されるプログラムを指定します。",
                                                 "# 　　　　　　　　ここで指定するプログラムは、アプリケーションと同じか、",
                                                 "# 　　　　　　　　システムのパスの通っているフォルダーにある必要があります。",
                                                 "# パラメーター：上記のプログラム起動時に指定されるパラメーターを指定します。",
                                                 "# 　　　　　　　{0}を指定すると、画面で選択されている文字列に置き換えられます。",
                                                 "# 　　　　　　　注）文字列はURLエンコードされます。",
                                                 "# ",
                                                 "# デフォルト設定に戻したい時は、単純にこのファイルを削除して再起動して下さい。",
                                                 "# ",
                                                 "Google 検索, IExplore.exe, http://www.google.co.jp/search?source=ig&hl=ja&rlz=&q={0}",
                                                 " Bing  検索, IExplore.exe, http://www.bing.com/search?q={0}",
                                                 " Wikipedia, IExplore.exe, http://ja.wikipedia.org/wiki/{0}",
                                                 "Google Image 検索, IExplore.exe, http://www.google.co.jp/search?source=ig&hl=ja&rlz=&q={0}&tbm=isch"
                                            };

        static string mRootPath;
        public static void init(string rootPath)
        {
            mRootPath = rootPath + ROOTDIR_NAME;
            DirectoryInfo dir = new DirectoryInfo(mRootPath);
            if (!dir.Exists)
                dir.Create();

        }


       

        public static bool storeUserPreferences(List<KeyValuePair<string, string>> list)
        {
            string path = mRootPath + USER_PREFERENCE_FILE_NAME;
            StringBuilder sb = new StringBuilder(64);

            try
            {
                using (FileStream fs = new FileStream(path, FileMode.Create, FileAccess.Write))
                {
                    using (StreamWriter sw = new StreamWriter(fs))
                    {

                        foreach (KeyValuePair<string, string> pair in list)
                        {
                            sb.Remove(0, sb.Length);
                            sb.Append(pair.Key).Append("=").Append(pair.Value);
                            sw.WriteLine(sb.ToString());
                        }
                        sw.Flush();
                        fs.Flush();
                    }
                }

            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
                return false;
            }
            return true;
        }

        public static List<KeyValuePair<string, string>> retrieveUserPreferences()
        {
            List<KeyValuePair<string, string>> list = new List<KeyValuePair<string, string>>();


            string path = mRootPath + USER_PREFERENCE_FILE_NAME;
            StringBuilder sb = new StringBuilder(64);

            try
            {
                using (FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read))
                {
                    using (StreamReader sr = new StreamReader(fs))
                    {
                        string line;
                        while (null != (line = sr.ReadLine()))
                        {
                            int n = line.IndexOf("=");
                            if (n >= 0)
                            {

                                KeyValuePair<string, string> pair 
                                    = new KeyValuePair<string, string>(line.Substring(0,n), line.Substring(n+1));
                                list.Add(pair);

                            }
                            
                        }
                    }
                }
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return list;
        }

        public static bool storeWriteHistory(string line)
        {
            bool ret = false;
            try
            {
                string[] prevLInes = retrieveWriteHistroy();
                if (prevLInes != null)
                {
                    foreach (string s in prevLInes)
                    {
                        if (s.Equals(line))
                            return true;
                    }
                }
                List<string> list = new List<string>();
                list.Add(line);

                if (prevLInes != null)
                {
                    int len = (prevLInes.Length < 20) ? prevLInes.Length : 19;
                    for (int i = 0; i < len; i++)
                    {
                        list.Add(prevLInes[i]);
                    }
                }

                string path = mRootPath + WRITE_HISTORY_FILE_NAME;
                File.WriteAllLines(path, list.ToArray());
                ret = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }
        public static string[] retrieveWriteHistroy()
        {
            string[] ret = null;
            string path = mRootPath + WRITE_HISTORY_FILE_NAME;
            try
            {
                ret = File.ReadAllLines(path);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }

        public static bool storeAAData(string [] lines)
        {
            string path = mRootPath + AA_DATA_FILE_NAME;
            return NTFileAccess.sotreLinesFile(path, lines);
        }


        public static string[] retrieveAAData()
        {
            return NTFileAccess.retrieveLinesFile(mRootPath + AA_DATA_FILE_NAME);

        }

        public static string[] retrieveResMenuCmd()
        {
            string path = mRootPath + MENU_CMD_FILE_NAME;

            FileInfo fInfo = new FileInfo(path);
            if (!fInfo.Exists)
            {
                NTFileAccess.sotreLinesFile(path, DEFAULT_CMD_STRINGS);
                return DEFAULT_CMD_STRINGS;
            }
            else
            {
                return NTFileAccess.retrieveLinesFile(path);
            }

        }


        public static bool storeOpenedBoards(string[] boards)
        {
            bool ret = false;
            try
            {
                string path = mRootPath + OPENED_BOARD_LIST_FILE_NAME;
                File.WriteAllLines(path, boards);
                ret = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }
        public static string [] retrieveOpenedBoards()
        {
            string[] ret = null;
            string path = mRootPath + OPENED_BOARD_LIST_FILE_NAME;
            try
            {
                ret = File.ReadAllLines(path);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }
        public static bool storeOpenedThreads(string[] threads)
        {
            bool ret = false;
            try
            {
                string path = mRootPath + OPENED_THREAD_LIST_FILE_NAME;
                File.WriteAllLines(path, threads);
                ret = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }
        public static string[] retrieveOpenedThreads()
        {
            string[] ret = null;
            string path = mRootPath + OPENED_THREAD_LIST_FILE_NAME;
            try
            {
                ret = File.ReadAllLines(path);
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return ret;
        }

    }
}
