﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chView.NtFile;
using NT2chCtrl;
using NT2chView.NtNet;
using NT2chObject;
using NT2chView.NtUI;

namespace NT2chView
{
    static class NTUserPreference
    {
        const string KEY_DEBUG_OPTION = "debug_option";
        const string KEY_P2ID = "p2id";
        const string KEY_P2PASS = "p2pass";
        const string KEY_P2ENABLE = "p2enable";
        const string KEY_MARUID = "maru_id";
        const string KEY_MARUPASS = "maru_pass";
        const string KEY_MARUENABLE = "maru_enable";
        const string KEY_NTCLOUDID = "ntcloud_id";
        const string KEY_NTCLOUDPASS = "ntcloud_pass";
        const string KEY_NTCLOUDENABLE = "ntcloud_enable";
        const string KEY_NTCLOUDURL = "ntcloud_url";
        const string KEY_NTUSERCLOUDENABLE = "nt_usercloud_enable";
        const string KEY_NTUSERCLOUD_SEED = "nt_usercloud_seed";
        const string KEY_NTUSERCLOUDURL = "nt_usercloud_url";
        const string KEY_NTUSERCLOUDSCRIPTURL = "nt_usercloud_script_url";
        const string KEY_NTUSERCLOUDFILEURL = "nt_usercloud_file_url";
        const string KEY_WRITE_SAGE = "sage";
        const string KEY_ZOOM_VALUE = "zoom";
        const string KEY_WINDOW_MAXIMIZED = "window_maximized";
        const string KEY_RESVIEW_TOOLBAR_POSITION = "resview_toolbar_position";
        const string KEY_THREADTITLEVIEW_TOOLBAR_POSITION = "threadtitleview_toolbar_position";
        const string KEY_WINDOW_HEIGHT = "window_height";
        const string KEY_WINDOW_WIDTH = "window_width";
        const string KEY_WINDOW_TOP = "window_top";
        const string KEY_WINDOW_LEFT = "window_left";
        const string KEY_WINDOW_COLUMN1 = "window_column1";
        const string KEY_WINDOW_ROW1 = "window_row1";
        const string KEY_WINDOW_LEFT_PANEL_ROW1 = "window_left_panel_row1";
        const string KEY_NT_SHOW_ONLY_CLOUD_READ_COUNT = "nt_only_cloud_read_count";
        const string KEY_USE_RES_FONT = "use_explicit_res_font";
        const string KEY_RES_FONT_TYPEFACE = "res_font_name";
        const string KEY_USE_AA_FONT = "use_explicit_aa_font";
        const string KEY_AA_FONT_TYPEFACE = "aa_font_name";
        const string KEY_AESPASS = "aes_pass";
        const string KEY_AESENABLE = "aes_enable";
        const string KEY_POPUPENABLE_MOUSEHOVER = "mousehover_enable";
        const string KEY_OPEN_YOUTUBE_ON_APP = "open_youtube_on_app";
        const string KEY_RESVIEW_SHOW_THUMBNAIL = "resview_show_thumbnail";
        const string KEY_RESVIEW_THUMBNAIL_WIDTH = "resview_thumbnail_width";
        const string KEY_RESVIEW_THUMBNAIL_HEIGHT = "resview_thumbnail_height";
        const string KEY_RESVIEW_THUMBNAIL_CONNECTION_COUNT = "resview_thumbnail_connection_count";
        const string KEY_RESVIEW_TEXTSEL_MODE = "resview_textsel_mode";
        const string KEY_THREADTITLE_LISTVIEW_FONTSIZE = "threadtitle_listview_fontsize";
        //const string KEY_IMAGE_VIEW_WIDTH = "imageview_width";
        //const string KEY_IMAGE_VIEW_HEIGHT = "imageview_height";
        const string KEY_FAVORITE_UPDATE_DURATION = "favorite_update_duration";
        public const int DEFAULT_FAVORITE_UPDATE_DURATION = 10;


        public static bool DebugOption
        {
            get
            {
                object o;
                if (mDictExportPreference.TryGetValue(PREF_PARAM.DEGUB_MODE, out o))
                {
                    bool? b = o as bool?;
                    if (b == null)
                        return false;
                    return (bool)b;
                }
                else
                {
                    return false;
                }
            }
            set
            {
                mDictExportPreference.Remove(PREF_PARAM.DEGUB_MODE);
                mDictExportPreference.Add(
                    PREF_PARAM.DEGUB_MODE, value);

            }
        }

        public static int FavoriteUpdateDuration
        {
            get;
            set;
        }

        static bool mResViewTextSelMode;
        public static bool ResViewTextSelMode {
            get
            {
#if DOTNET45
                return mResViewTextSelMode;
#else
                return true;
#endif
            }
            set
            {
                mResViewTextSelMode = value;
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_TEXTSEL_MODE);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_TEXTSEL_MODE, mResViewTextSelMode);

            }
        }

        private static int mResViewThumbnailConnectionCount;
        private static int mResViewThumbnailHeight;
        private static int mResViewThumbnailWidth;
        private static bool mResViewShowThumbnail;

        //public static int ImageViewWidth { get; set; }
        //public static int ImageViewHeight { get; set; }
        public static int ResViewThumbnailConnectionCount
        {
            get
            {
                return mResViewThumbnailConnectionCount;
            }
            set
            {
                if (value < 1)
                    mResViewThumbnailConnectionCount = 1;
                else if (value > 20)
                    mResViewThumbnailConnectionCount = 20;
                else
                    mResViewThumbnailConnectionCount = value;
                NTExportUtil.Worker.resetConnectionCount(
                    mResViewThumbnailConnectionCount);
            }
        }
        public static int ResViewThumbnailWidth
        {
            get
            {
                return mResViewThumbnailWidth;
            }
            set
            {
                mResViewThumbnailWidth = value;
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_THUMBNAIL_WIDTH);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_THUMBNAIL_WIDTH, ResViewThumbnailWidth);
            }
        }
        public static int ResViewThumbnailHeight
        { 
            get
            {
                return mResViewThumbnailHeight;
            }
            set
            {
                mResViewThumbnailHeight = value;
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_THUMBNAIL_HEIGHT);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_THUMBNAIL_HEIGHT, ResViewThumbnailHeight);
            }
        }
        public static bool ResViewShowThumbnail
        {
            get
            {
                return mResViewShowThumbnail;
            }
            set
            {
                mResViewShowThumbnail = value;
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL, mResViewShowThumbnail.ToString());
             }
        }


        static bool mP2Enabled;
        static bool mMaruEnabled;
        static bool mNTCloudEnabled;
        static bool mNTUserCloudEnabled;
        static bool mSage;
        static double mZoom;
        static bool mShowCloudReadCnt;
        static bool mUseExplicitResFont;
        static bool mUseExplicitAAFont;

        static bool mAvoidSaveToPreferenceFile = false;

        static string[] mAADataText;

        static Dictionary<PREF_PARAM, object> mDictExportPreference
            = new Dictionary<PREF_PARAM, object>();
        public static Dictionary<PREF_PARAM, object> getExportPreference()
        {
            return mDictExportPreference;
        }

        public static string[] AAData
        {
            get { return mAADataText; }
            set 
            { 
                mAADataText = value;

                if (mDictExportPreference.ContainsKey(PREF_PARAM.RES_VIEW_AA_STRING_LIST))
                    mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_AA_STRING_LIST);
                
                mDictExportPreference.Add(
                        PREF_PARAM.RES_VIEW_AA_STRING_LIST, mAADataText);
                
            }
        }


        const string VALUE_STRING_TRUE = "True";
        const string VALUE_STRING_FALSE = "False";

        static string getBoolValueString(bool value)
        {
            if (value)
                return VALUE_STRING_TRUE;
            else
                return VALUE_STRING_FALSE;
        }

        public static bool EnableTouch { get; set;} 
        public static double WindowTop { get; set; }
        public static double WindowLeft { get; set; }
        public static double WindowWidth { get; set; }
        public static double WindowHeight { get; set; }
        public static bool WindowMaximized { get; set; }
        public static int ResViewToolbarPosition { get; set; }
        public static int ThreadTitleViewToolbarPosition { get; set; }
        public static double WindowColumn1 { get; set; }
        public static double WindowRow1 { get; set; }
        public static double WindowLeftPanelRow1 { get; set; }
        public static string P2ID { get; set; }
        public static string P2PSS { get; set; }
        public static bool P2IsEnabled
       {
            get 
            {
                return mP2Enabled; 
            }
            set
            {
                if (mP2Enabled != value)
                {
                    mP2Enabled = value;
                    savePreferences();
                }
            }
        }

        public static string MaruID { get; set; }
        public static string MaruPSS { get; set; }
        public static bool MaruIsEnabled
        {
            get
            {
                return mMaruEnabled;
            }
            set
            {
                if (mMaruEnabled != value)
                {
                    mMaruEnabled = value;
                    savePreferences();
                }
            }
        }

        static string mAESPass = string.Empty;
        public static string AESPass
        {
            get
            {
                return mAESPass;
            }
            set
            {
                mAESPass = value;
                NTCrypt.setPassword(value);
            }
        }
        static bool mUseAES;
        public static bool AESEnabled
        {
            get
            {
                return mUseAES && mAESPass != null && mAESPass.Length > 0;
            }
            set
            {
                mUseAES = value;
            }
        }

        public static string ResFontTypeface { get; set; }
        public static bool UseResFontTypeface
        {
            get { return mUseExplicitResFont; }
            set { mUseExplicitResFont = value; }
        }

        public static string AAFontTypeface { get; set; }
        public static bool UseAAFontTypeface
        {
            get { return mUseExplicitAAFont; }
            set { mUseExplicitAAFont = value; }
        }
        
        public static string NTCloudID { get; set; }
        public static string NTCloudPSS { get; set; }
        public static string NTCloudUrl { get; set; }
        public static bool NTCloudIsEnabled
        {
            get
            {
                return mNTCloudEnabled;
            }
            set
            {
                if (mNTCloudEnabled != value)
                {
                    mNTCloudEnabled = value;
                    savePreferences();
                }
            }
        }

        public static string NTUserCloudSeed { get; set; }
        public static string NTUserCloudScriptUrl { get; set; }
        public static string NTUserCloudFileUrl { get; set; }
        public static string NTUserCloudUrl { get; set; }
        public static bool NTUserCloudIsEnabled
        {
            get
            {
                return mNTUserCloudEnabled;
            }
            set
            {
                if (mNTUserCloudEnabled != value)
                {
                    mNTUserCloudEnabled = value;
                    savePreferences();
                }
            }
        }
        private static string mUserCloudHashedPasswd = null;
        public static string NTUserCloudGetHashedPasswd()
        {
            if (null == mUserCloudHashedPasswd)
            {
                mUserCloudHashedPasswd = NTCrypt.getSHA256Hashed(
                    NTUserPreference.NTCloudPSS + NTUserPreference.NTUserCloudSeed);
            }
            return mUserCloudHashedPasswd;
        }

        public static bool NTShowOnlyCloudReadCount
        {
            set
            {
                mShowCloudReadCnt = value;
            }

            get
            {
                if (NTCloudIsEnabled)
                    return mShowCloudReadCnt;
                else
                    return false;
            }
        }

        public static bool SageIsEnabled
        {
            get 
            {
                return mSage; 
            }
            set
            {
                if (mSage != value)
                {
                    mSage = value;
                    savePreferences();
                }
            }
        }

        public static bool EnablePopupMouseHover
        {
            set;
            get;
        }

        public static bool OpenYoutubeOnApp
        {
            set;
            get;
        }

        public static double ThreadtitleListViewFontSize { get; set; }

        public static void init()
        {
            mP2Enabled = false;
            mMaruEnabled = false;
            mNTCloudEnabled = false;
            mNTUserCloudEnabled = false;
            mUseExplicitResFont = false;
            mUseExplicitAAFont = false;

            mSage = true;
            mZoom = 95;
            WindowTop = 50;
            WindowLeft = 50;
            WindowHeight = 640;
            WindowWidth = 920;
            WindowColumn1 = 310.0;
            WindowRow1 = 310.0;
            WindowLeftPanelRow1 = 250.0;
            WindowMaximized = false;

            EnableTouch = false;

#if DOTNET45
            ResViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_RIGHT;
            ThreadTitleViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_RIGHT;
#else
            ResViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_LEFT;
            ThreadTitleViewToolbarPosition = NTDragDrop.TOOLBAR_LOCATION_LEFT;
#endif


            mShowCloudReadCnt = true;

            P2ID = string.Empty;
            P2PSS = string.Empty;
            MaruID = string.Empty;
            MaruPSS = string.Empty;
            AESPass = string.Empty;
            NTCloudID = string.Empty;
            NTCloudPSS = string.Empty;
            NTUserCloudUrl = string.Empty;
            NTUserCloudSeed = string.Empty;
            NTUserCloudScriptUrl = string.Empty;
            NTUserCloudFileUrl = string.Empty;
            ResFontTypeface = string.Empty;
            AAFontTypeface = string.Empty;

            EnablePopupMouseHover = false;
            OpenYoutubeOnApp = true;

            ResViewThumbnailConnectionCount = 5;
            mResViewThumbnailHeight = 80;
            mResViewThumbnailWidth = 80;
            mResViewShowThumbnail = false;

            //ImageViewHeight = 300;
            //ImageViewWidth = 300;

            ThreadtitleListViewFontSize = 14;

            FavoriteUpdateDuration = 10;

#if DOTNET45
            ResViewTextSelMode = false;
#else
            ResViewTextSelMode = true;
#endif


            loadPreferences();


            if (!NTUserCloudIsEnabled)
            {
                if (NTCloudID.Length == 0 ||
                NTCloudPSS.Length == 0 ||
                NTCloudUrl.Length == 0)
                {
                    NTCloudIsEnabled = false;
                }
            }
            else
            {
                if (NTUserCloudUrl.Length == 0 ||
                NTUserCloudSeed.Length == 0 ||
                NTUserCloudScriptUrl.Length == 0 ||
                NTUserCloudFileUrl.Length == 0)
                {
                    NTCloudIsEnabled = false;
                }
            }
        }


        static void loadPreferences()
        {
            try
            {
                mAvoidSaveToPreferenceFile = true;

                List<KeyValuePair<string, string>> list
                    = NTPersistentFileAccess.retrieveUserPreferences();
                foreach (KeyValuePair<string, string> pair in list)
                {
                    switch (pair.Key)
                    {
                        case KEY_FAVORITE_UPDATE_DURATION:
                            try
                            {
                               int duration = int.Parse(pair.Value);
                               if (duration < 0 || duration > 60)
                                   FavoriteUpdateDuration = 
                                       DEFAULT_FAVORITE_UPDATE_DURATION;
                               else
                                   FavoriteUpdateDuration = duration;
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_P2ID:
                            P2ID = pair.Value;
                            break;
                        case KEY_P2PASS:
                            P2PSS = pair.Value;
                            break;
                        case KEY_P2ENABLE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                P2IsEnabled = true;
                            else
                                P2IsEnabled = false;
                            break;
                        case KEY_MARUID:
                            MaruID = pair.Value;
                            break;
                        case KEY_MARUPASS:
                            MaruPSS = pair.Value;
                            break;
                        case KEY_MARUENABLE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                MaruIsEnabled = true;
                            else
                                MaruIsEnabled = false;
                            break;
                        case KEY_AESPASS:
                            AESPass = pair.Value;
                            break;
                        case KEY_AESENABLE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                AESEnabled = true;
                            else
                                AESEnabled = false;
                            break;
                        case KEY_NTCLOUDID:
                            NTCloudID = pair.Value;
                            break;
                        case KEY_NTCLOUDPASS:
                            NTCloudPSS = pair.Value;
                            break;
                        case KEY_NTCLOUDURL:
                            NTCloudUrl = pair.Value;
                            break;
                        case KEY_NTUSERCLOUDURL:
                            NTUserCloudUrl = pair.Value;
                            break;

                        case KEY_NTUSERCLOUD_SEED:
                            NTUserCloudSeed = pair.Value;
                            break;
                        case KEY_NTUSERCLOUDSCRIPTURL:
                            NTUserCloudScriptUrl = pair.Value;
                            break;
                        case KEY_NTUSERCLOUDFILEURL:
                            NTUserCloudFileUrl = pair.Value;
                            break;

                        case KEY_NTCLOUDENABLE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                NTCloudIsEnabled = true;
                            else
                                NTCloudIsEnabled = false;
                            break;
                        case KEY_NTUSERCLOUDENABLE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                NTUserCloudIsEnabled = true;
                            else
                                NTUserCloudIsEnabled = false;
                            break;
                        case KEY_NT_SHOW_ONLY_CLOUD_READ_COUNT:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                mShowCloudReadCnt = true;
                            else
                                mShowCloudReadCnt = false;
                            break;

                        case KEY_WRITE_SAGE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                SageIsEnabled = true;
                            else
                                SageIsEnabled = false;
                            break;
                        case KEY_ZOOM_VALUE:
                            try
                            {
                                mZoom = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_TOP:
                            try
                            {
                                WindowTop = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_LEFT:
                            try
                            {
                                WindowLeft = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_MAXIMIZED:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                WindowMaximized = true;
                            else
                                WindowMaximized = false;
                            break;
                        case KEY_RESVIEW_TOOLBAR_POSITION:
                            try
                            {
                                ResViewToolbarPosition = int.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_THREADTITLEVIEW_TOOLBAR_POSITION:
                            try
                            {
                                ThreadTitleViewToolbarPosition = int.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_HEIGHT:
                            try
                            {
                                WindowHeight = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_WIDTH:
                            try
                            {
                                WindowWidth = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_COLUMN1:
                            try
                            {
                                WindowColumn1 = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_ROW1:
                            try
                            {
                                WindowRow1 = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_WINDOW_LEFT_PANEL_ROW1:
                            try
                            {
                                WindowLeftPanelRow1 = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_THREADTITLE_LISTVIEW_FONTSIZE:
                            try
                            {
                                ThreadtitleListViewFontSize = double.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_USE_RES_FONT:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                mUseExplicitResFont = true;
                            else
                                mUseExplicitResFont = false;
                            break;
                        case KEY_RES_FONT_TYPEFACE:
                            ResFontTypeface = pair.Value;
                            break;
                        case KEY_USE_AA_FONT:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                mUseExplicitAAFont = true;
                            else
                                mUseExplicitAAFont = false;
                            break;
                        case KEY_POPUPENABLE_MOUSEHOVER:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                EnablePopupMouseHover = true;
                            else
                                EnablePopupMouseHover = false;
                            break;
                        case KEY_OPEN_YOUTUBE_ON_APP:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                OpenYoutubeOnApp = true;
                            else
                                OpenYoutubeOnApp = false;
                            break;
                        case KEY_AA_FONT_TYPEFACE:
                            AAFontTypeface = pair.Value;
                            break;
                        case KEY_RESVIEW_SHOW_THUMBNAIL:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                ResViewShowThumbnail = true;
                            else
                                ResViewShowThumbnail = false;
                            break;
                        case KEY_RESVIEW_THUMBNAIL_CONNECTION_COUNT:
                            try
                            {
                                ResViewThumbnailConnectionCount = int.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_RESVIEW_THUMBNAIL_HEIGHT:
                            try
                            {
                                ResViewThumbnailHeight = int.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_RESVIEW_THUMBNAIL_WIDTH:
                            try
                            {
                                ResViewThumbnailWidth = int.Parse(pair.Value);
                            }
                            catch (Exception e)
                            {
                                NTDebug.l(e.Message);
                            }
                            break;
                        case KEY_RESVIEW_TEXTSEL_MODE:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                mResViewTextSelMode = true;
                            else
                                mResViewTextSelMode = false;
                            break;
                        case KEY_DEBUG_OPTION:
                            if (VALUE_STRING_TRUE.Equals(pair.Value))
                                DebugOption = true;
                            else
                                DebugOption = false;
                            break;

                    }
                }

                mAADataText = NTPersistentFileAccess.retrieveAAData();
                if (mAADataText == null)
                {
                    mAADataText = new string[1];
                    mAADataText[0] = "　 ";
                }

                resetExportPreference();

            }
            finally
            {
                mAvoidSaveToPreferenceFile = false;
            }

        }

        static void resetExportPreference()
        {
            if (mAADataText != null)
            {
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_AA_STRING_LIST);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_AA_STRING_LIST, mAADataText);
            }
            if (mUseExplicitAAFont && AAFontTypeface != null)
            {
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_AA_FONT_TYPEFACE);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_AA_FONT_TYPEFACE, AAFontTypeface);
            }
            if (mUseExplicitResFont && ResFontTypeface != null)
            {
                mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_FONT_TYPEFACE);
                mDictExportPreference.Add(
                    PREF_PARAM.RES_VIEW_FONT_TYPEFACE, ResFontTypeface);
            }
            
            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_ZOOM_VALUE);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_ZOOM_VALUE, mZoom.ToString());
            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_POPUP_MOUSEHOVER);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_POPUP_MOUSEHOVER, EnablePopupMouseHover.ToString());

            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL, ResViewShowThumbnail.ToString());
            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_THUMBNAIL_WIDTH);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_THUMBNAIL_WIDTH, ResViewThumbnailWidth);
            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_THUMBNAIL_HEIGHT);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_THUMBNAIL_HEIGHT, ResViewThumbnailHeight);

            mDictExportPreference.Remove(PREF_PARAM.THREADTITLE_LIST_FONT_SIZE);
            mDictExportPreference.Add(
                PREF_PARAM.THREADTITLE_LIST_FONT_SIZE, ThreadtitleListViewFontSize);

            mDictExportPreference.Remove(PREF_PARAM.RES_VIEW_TEXTSEL_MODE);
            mDictExportPreference.Add(
                PREF_PARAM.RES_VIEW_TEXTSEL_MODE, mResViewTextSelMode);

        }

        

        public static void savePreferences()
        {
            if (mAvoidSaveToPreferenceFile)
                return;

            List<KeyValuePair<string, string>> list
                = new List<KeyValuePair<string, string>>();

            KeyValuePair<string, string> pair 
                = new KeyValuePair<string, string>(KEY_P2ID, P2ID);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_P2PASS, P2PSS);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_P2ENABLE, getBoolValueString(P2IsEnabled));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_MARUID, MaruID);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_MARUPASS, MaruPSS);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_MARUENABLE, getBoolValueString(MaruIsEnabled));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_AESPASS, AESPass);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_AESENABLE, getBoolValueString(AESEnabled));
            list.Add(pair);


            pair = new KeyValuePair<string, string>(KEY_WRITE_SAGE, getBoolValueString(SageIsEnabled));
            list.Add(pair);

            object o;
            if (mDictExportPreference.TryGetValue(PREF_PARAM.RES_VIEW_ZOOM_VALUE, out o))
            {
                double zoom;
                String s = o as String;
                if (s != null)
                    if(double.TryParse(s, out zoom))
                        mZoom = zoom;
            }
            pair = new KeyValuePair<string, string>(KEY_ZOOM_VALUE, mZoom.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_THREADTITLEVIEW_TOOLBAR_POSITION, ThreadTitleViewToolbarPosition.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_RESVIEW_TOOLBAR_POSITION, ResViewToolbarPosition.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_WINDOW_MAXIMIZED, getBoolValueString(WindowMaximized));
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_WINDOW_HEIGHT, WindowHeight.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_WINDOW_WIDTH, WindowWidth.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_WINDOW_TOP, WindowTop.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_WINDOW_LEFT, WindowLeft.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_WINDOW_COLUMN1, WindowColumn1.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_WINDOW_ROW1, WindowRow1.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_WINDOW_LEFT_PANEL_ROW1, WindowLeftPanelRow1.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTCLOUDID, NTCloudID);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTCLOUDPASS, NTCloudPSS);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTCLOUDURL, NTCloudUrl);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTCLOUDENABLE, getBoolValueString(NTCloudIsEnabled));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTUSERCLOUDURL, NTUserCloudUrl);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NTUSERCLOUD_SEED, NTUserCloudSeed);
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_NTUSERCLOUDSCRIPTURL, NTUserCloudScriptUrl);
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_NTUSERCLOUDFILEURL, NTUserCloudFileUrl);
            list.Add(pair);


            pair = new KeyValuePair<string, string>(KEY_NTUSERCLOUDENABLE, getBoolValueString(NTUserCloudIsEnabled));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_NT_SHOW_ONLY_CLOUD_READ_COUNT, getBoolValueString(mShowCloudReadCnt));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_USE_RES_FONT, getBoolValueString(mUseExplicitResFont));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_RES_FONT_TYPEFACE, ResFontTypeface);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_USE_AA_FONT, getBoolValueString(mUseExplicitAAFont));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_AA_FONT_TYPEFACE, AAFontTypeface);
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_POPUPENABLE_MOUSEHOVER, getBoolValueString(EnablePopupMouseHover));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_OPEN_YOUTUBE_ON_APP, getBoolValueString(OpenYoutubeOnApp));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_RESVIEW_SHOW_THUMBNAIL, getBoolValueString(mResViewShowThumbnail));
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_RESVIEW_THUMBNAIL_HEIGHT, mResViewThumbnailHeight.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(KEY_RESVIEW_THUMBNAIL_WIDTH, mResViewThumbnailWidth.ToString());
            list.Add(pair);
            pair = new KeyValuePair<string, string>(
                    KEY_RESVIEW_THUMBNAIL_CONNECTION_COUNT, 
                    mResViewThumbnailConnectionCount.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(
                KEY_THREADTITLE_LISTVIEW_FONTSIZE, ThreadtitleListViewFontSize.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(
                 KEY_FAVORITE_UPDATE_DURATION, FavoriteUpdateDuration.ToString());
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_RESVIEW_TEXTSEL_MODE, getBoolValueString(ResViewTextSelMode));
            list.Add(pair);

            pair = new KeyValuePair<string, string>(KEY_DEBUG_OPTION, getBoolValueString(DebugOption));
            list.Add(pair);

            NTPersistentFileAccess.storeUserPreferences(list);

            NTPersistentFileAccess.storeAAData(mAADataText);

            resetExportPreference();

            NTFontUtil.clear();

            mUserCloudHashedPasswd = null;

        }
    }
}
