﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    sealed class NTNgItems
    {
        static NTNgItems mThis = null;
        private List<string> mNgWords = new List<string>();
        private List<string> mNgIds = new List<string>();
        private List<string> mNgNames = new List<string>();

        public static NTNgItems getContext()
        {
            if (mThis == null)
                mThis = new NTNgItems();

            return mThis;
        }

        public bool addNgName(string src)
        {
            src = src.Trim();
            lock (mNgNames)
            {
                foreach (string s in mNgNames)
                {
                    if (s.Equals(src))
                        return false;
                }
                mNgNames.Add(src);
                return true;
            }
        }

        public bool addNgId(string src)
        {
            src = src.Trim();
            lock (mNgIds)
            {
                foreach (string s in mNgIds)
                {
                    if (s.Equals(src))
                        return false;
                }
                mNgIds.Add(src);
                return true;
            }
        }
        public bool addNgWord(string src)
        {
            src = src.Trim();
            lock (mNgWords)
            {
                foreach (string s in mNgWords)
                {
                    if (s.Equals(src))
                        return false;
                }
                mNgWords.Add(src);
                return true;
            }
        }

        public List<String> getNgWords()
        {
            lock (mNgWords)
            {
                List<string> list = new List<string>();
                list.AddRange(mNgWords);
                return list;
            }
        }
        public List<String> getNgIds()
        {
            lock (mNgIds)
            {
                List<string> list = new List<string>();
                list.AddRange(mNgIds);
                return list;
            }
        }

        public List<String> getNgNames()
        {
            lock (mNgNames)
            {
                List<string> list = new List<string>();
                list.AddRange(mNgNames);
                return list;
            }
        }

        public void WriteNgWord(string [] list)
        {
            lock (mNgWords)
            {
                mNgWords.Clear();
                mNgWords.AddRange(list);
             }
        }

        public void WriteNgId(string [] list)
        {
            lock (mNgIds)
            {
                mNgIds.Clear();
                foreach (string s in list)
                    mNgIds.Add(s);
            }
        }

        public void WriteNgName(string [] list)
        {
            lock (mNgNames)
            {
                mNgNames.Clear();
                foreach (string s in list)
                    mNgNames.Add(s);
            }
        }

    }
}
