﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    static class NTDataRoot
    {

        public static List<NTCategory> mCategoryList;
        public const string EXTERNAL_BOARD_CATEGORY_NAME = "外部板";

        public static NTCategory getExternalBoards()
        {
            if (null == mCategoryList)
                return null;

            foreach (NTCategory category in mCategoryList)
            {
                if(category.mName.Equals(EXTERNAL_BOARD_CATEGORY_NAME))
                    return category;
            }
            NTCategory c =  new NTCategory(EXTERNAL_BOARD_CATEGORY_NAME);
            mCategoryList.Add(c);
            return c;
        }

        //public static string mWroteMsg = null;
        
        public static NTBoard getBoardByName(string name)
        {
            for (int i = mCategoryList.Count - 1;
                i >= 0; i--)
            {
                NTBoard board = mCategoryList[i].getBoardByName(name);
                if (board != null)
                    return board;
            }
            return null;
        }

        public static NTBoard getBoardByAddress(string address)
        {
            for (int i = mCategoryList.Count - 1;
                i >= 0; i--)
            {
                NTBoard board = mCategoryList[i].getBoardByAddress(address);
                if (board != null)
                    return board;
            }
            return null;
        }

        public static NTBoard getMatchBoard(string searchAddress)
        {
            for (int i = mCategoryList.Count - 1;
                i >= 0; i--)
            {
                NTBoard board = mCategoryList[i].getMatchBoard(searchAddress);
                if (board != null)
                    return board;
            }
            return null;

        }



    }
}
