﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chView
{
    public sealed class NTCategory
    {
        public string mName = null;
        public List<NTBoard> mBoardList = new List<NTBoard>();

        public NTBoard getMatchBoard(string searchAddress)
        {
            foreach (NTBoard board in mBoardList)
            {
                int n1 = board.mAddress.LastIndexOf(searchAddress);
                int n2 = board.mAddress.LastIndexOf("2ch.net");
                if (n2 > 0 && n2 < n1)
                    return board;

            }
            return null;

        }



        public NTCategory(string name)
        {
            mName = name;
        }

        public NTBoard getBoardByName(string name)
        {
            foreach (NTBoard board in mBoardList)
            {
                if (name.Equals(board.mName))
                    return board;
            }
            return null;
        }

        public NTBoard getBoardByAddress(string address)
        {
            foreach (NTBoard board in mBoardList)
            {
                if (0 <= board.mAddress.IndexOf(address))
                    return board;
            }
            return null;
        }



        public static List<NTCategory> parseBoardMenu(string html)
        {
            List<NTCategory> clist = new List<NTCategory>();
            NTCategory category = null;

            string[] lines = html.Split('\n');

            foreach (string s in lines)
            {
                int n1;
                if (0 <= (n1 = s.IndexOf("<B>")))
                {

                    n1 += 3;

                    int n2 = s.IndexOf("</B>", n1);
                    if (n2 < 0)
                        continue;
                    string cName = s.Substring(n1, n2 - n1);

                    category = new NTCategory(cName);

                    //NTDebug.l("Category: " + cName);

                    clist.Add(category);
                }
                else if (0 <= (n1 = s.IndexOf("<A")))
                {
                    int n2, n3, n4;
                    if (0 <= (n2 = s.IndexOf("HREF=", n1)))
                    {
                        if (0 <= (n3 = s.IndexOf('>', n2)))
                        {

                            if (0 <= (n4 = s.IndexOf("</A>", n3)))
                            {
                                string boardName = s.Substring(n3 + 1, n4 - (n3 + 1)).Trim();
                                string boardAddress = s.Substring(n2 + 5, n3 - (n2 + 5)).Trim();
                                if (0 <= (n1 = boardAddress.IndexOf(' ')))
                                {
                                    boardAddress = boardAddress.Substring(0, n1);
                                }
                                //NTDebug.l("\tBoard: " + boardName);
                                //NTDebug.l("\t\t" + boardAddress);
                                if (null != category)
                                {
                                    category.mBoardList.Add(new NTBoard(boardName, boardAddress));
                                }
                            }

                        }
                    }
                }
            }
            return clist;
        }

        public static void parseExternalBoardMenu(string[] descriptions)
        {
            NTCategory category = NTDataRoot.getExternalBoards();
            List<NTBoard> bList = category.mBoardList;

            bList.Clear();

            foreach (string s in descriptions)
            {
                int n1;
                if (0 <= (n1 = s.IndexOf("<>")))
                {
                    string address = s.Substring(0, n1);
                    string name = s.Substring(n1 + 2);
                    category.mBoardList.Add(new NTBoard(name, address));

                }
            }
        }
    }
}
