﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Controls;
using System.Windows.Media.Imaging;

namespace NT2chCtrl.html.wpf
{
    class ImageCash
    {
        private static string mBasePath;
        private static Dictionary<string, BitmapImage> mImageCash = new Dictionary<string, BitmapImage>();
        public static void init(string basePath)
        {
            mBasePath = basePath;
        }

        public static BitmapImage getBitmapImage(string path)
        {
            string imagePath = parseImagePath(path);
            if (imagePath == null)
                return null;
            BitmapImage bImg;

            if (mImageCash.TryGetValue(imagePath, out bImg))
                return bImg;

            if (!File.Exists(imagePath))
                return null;
            try
            {
                bImg = new BitmapImage();

                bImg.BeginInit();

                bImg.CacheOption = BitmapCacheOption.OnDemand;
                bImg.CreateOptions = BitmapCreateOptions.DelayCreation;
                bImg.UriSource = new Uri(imagePath, UriKind.Absolute);

                bImg.EndInit();
            }
            catch (Exception)
            {
                return null;
            }
            mImageCash.Add(imagePath, bImg);
            return bImg;
        }
        private static string parseImagePath(string path)
        {
            int idx = path.IndexOf(":\\");
            if (idx >= 0)
            {
                if (idx == 1)
                {
                    char c = path[0];
                    if((c >= 'a' && c <= 'z')||(c >= 'A' && c <= 'Z'))
                        return path;
                }
                return null;
            }
            idx = path.IndexOf("://");
            if (idx >= 0)
                return null;
            path = path.Trim();
            if (path.Length == 0)
                return null;
            if (path[0] == '\\')
                return mBasePath + path;
            else
                return mBasePath + "\\" + path;
        }
    }
}
