﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    partial class JsParser
    {
        //List<JsFunction> mBodyLvlFunc = new List<JsFunction>();
        List<JsRootFunction> mFuncList = new List<JsRootFunction>();
        //HtmlElement mRootElement;
        public bool PreCompile(DebugContext ctx , HtmlElement jsElem)
        {
            string[] contents = jsElem.getStringContent();
            if (contents == null || contents.Length != 1)
                return false;

            JsRootFunction rootFunc = new JsRootFunction(ctx.mCurrentLine, 0);
            if (rootFunc.Parse(ctx, contents[0]))
            {
                mFuncList.Add(rootFunc);
                return true;
            }
            else
            {
                return false;
            }
        }

        public bool run(DebugContext dCtx, HtmlElement rootElement, out JsFunctionContext fCtx)
        {
            fCtx = null;
            if (mFuncList.Count == 0)
                return true;

            foreach (JsRootFunction func in mFuncList)
            {
                fCtx = new JsFunctionContext(dCtx);
                if (func.getInstaructionCount() > 0 && 
                    null == func.Execute(fCtx, rootElement))
                {
                    return false;
                }
            }
            return true;
        }
    }
}
