﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Input;
using NT2chObject;

namespace NT2chCtrl
{
    partial class ResListAdapter : UIElementListPanel.IUIElementListAdapter
    {
        public void urlLink_Click(object sender, RoutedEventArgs e)
        {
            Hyperlink hl = sender as Hyperlink;
            if (hl == null)
                return;

            Uri uri = hl.NavigateUri;
            if (uri == null)
                return;

            string url = uri.AbsoluteUri;

            mCommand.ExecURL(url);
        }


        public void resLink_MouseEnter(object sender, RoutedEventArgs e)
        {
            ResViewPopup.ClearAll(ResViewPopup.CLEAR_POPUP.ALL);
            resLinkSubItem_MouseEnter(sender, e);
        }

        void resLinkSubItem_MouseEnter(object sender, RoutedEventArgs e)
        {
            Hyperlink hl = sender as Hyperlink;
            if (hl == null)
                return;

            List<object> param = hl.Tag as List<object>;

            if (param == null || param.Count != 2)
                return;

            IThread thread = param[0] as IThread;
            int[] arrNum = param[1] as int[];
            resLinkDispalySubItem(thread, arrNum);

        }

        public void resLinkSubItem_MouseEnter2(object sender, RoutedEventArgs e)
        {
            Hyperlink hl = sender as Hyperlink;
            if (hl == null)
                return;

            List<object> param = hl.Tag as List<object>;

            if (param == null || param.Count != 2)
                return;

            IThread thread = param[0] as IThread;
            string sArr = param[1] as string;
            //int[] arrNum = param[1] as int[];
            int[] arr = NTResViewPanel.getUtil().ParseResLinkReferenceNumber(sArr);
            resLinkDispalySubItem(thread, arr);

        }

        public void resLinkDispalySubItem(IThread ithread, int[] arrNum)
        {
            if (ithread == null || arrNum == null)
                return;

            List<IRes> rList = ithread.getResList();
            List<IRes> rListCopy = new List<IRes>(arrNum.Length);

            int seq = 0;
            foreach (IRes res in rList)
            {
                for (int i = seq; i < arrNum.Length; i++)
                {
                    if (res.getSequenceNo() == arrNum[i])
                    {
                        rListCopy.Add(res);
                        seq = i + 1;
                        break;
                    }
                }
            }

            FlowDocument doc = createDocument(ithread, rListCopy, false);

            if (doc != null)
            {
                double zoom = 0;
                if (!getZoomValue(out zoom))
                    zoom = 90;
                else
                    zoom = (zoom > 90) ? 90 : zoom;
                double scrHeight = System.Windows.SystemParameters.PrimaryScreenHeight;
                ResViewPopup popup = new ResViewPopup(
                    this, doc, scrHeight / 2, scrHeight * 2 / 3, zoom,
                    mMainPanel.getTextSelMode());
            }

        }
        private bool extractParam(object sender, out IThread ithread, out IRes ires)
        {
            ithread = null;
            ires = null;

            Hyperlink item = sender as Hyperlink;
            if (item == null)
                return false;

            List<object> list = item.Tag as List<object>;
            if (list == null || list.Count != 2)
                return false;

            ithread = list[0] as IThread;
            ires = list[1] as IRes;

            return (ithread != null && ires != null);
        }

        void hlink_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            IThread thread;
            IRes res;
            if (!extractParam(sender, out thread, out res))
                return;

            ResViewPopup.ClearAll(ResViewPopup.CLEAR_POPUP.ALL);
            JumpTo(res.getSequenceNo());
        }


        void ResSeqNo_MouseLeftButtonDown(object sender, MouseEventArgs e)
        {
            IThread thread;
            IRes res;
            if (!extractParam(sender, out thread, out res))
                return;

            //JumpTo(thread, res.getSequenceNo());
        }

        void ResSeqNo_MouseEnter(object sender, MouseEventArgs e)
        {
            IThread thread;
            IRes res;
            if (!extractParam(sender, out thread, out res))
                return;

            ResViewPopup.ClearAll(ResViewPopup.CLEAR_POPUP.ALL);

            ResViewPopup popup = new ResViewPopup(this, thread, res);

        }
        void ResSeqNoSubItem_MouseEnter(object sender, MouseEventArgs e)
        {
            IThread thread;
            IRes res;
            if (!extractParam(sender, out thread, out res))
                return;

            ResViewPopup popup = new ResViewPopup(this, thread, res);

        }


        void document_MouseMove(object sender, RoutedEventArgs e)
        {
            ResViewPopup.ClearAll(ResViewPopup.CLEAR_POPUP.LEAVE_ONE);
        }
    }
}
