﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace NT2chCtrl
{
    /// <summary>
    /// NTScriptDebugger.xaml の相互作用ロジック
    /// </summary>
    public partial class NTScriptDebugger : Window
    {
        public int ErrorLine { set; get; }
        public int ErrorSrcIndex { set; get; }
        public string ErrorMessage { set; get; }
        public string HtmlSource { get; set; }
        public html.js.JsFunctionContext FuncContext { get; set; }
        public NTScriptDebugger()
        {
            InitializeComponent();
        }

        static bool mDontShowWindow = false;
        static List<NTScriptDebugger> mWindows = new List<NTScriptDebugger>();
        public static void ShowWindow(NTScriptDebugger wnd)
        {
            if (mDontShowWindow)
                return;
            if (mWindows.Count == 0)
            {
                wnd.Show();
            }
            mWindows.Add(wnd);
        }


        public void initParam()
        {
            //mLblHeader.Content = ErrorMessage;
            //mOutputBox.AppendText(HtmlSource);
            mFocusSpan = null;
            string source = HtmlSource;
            int length = source.Length;
            int currLine = 1;
            int textStart = 0;
            int i = 0;
            int column = -1;
            for (; i < length; i++)
            {
                char c = source[i];
                if (c == '\n')
                {
                    string line = source.Substring(textStart, i - textStart);
                    if (currLine == ErrorLine)
                    {
                        addLine(currLine, line, true);
                        if (ErrorSrcIndex < i && textStart <= ErrorSrcIndex)
                        {
                            column = ErrorSrcIndex - textStart;
                        }
                    }
                    else
                    {
                        addLine(currLine, line, false);
                    }
                    currLine++;
                    textStart = i + 1;
                    continue;
                }
            }
            if (mFocusSpan != null)
            {
                Timer timer = new Timer(TimerCallback, null,1000, Timeout.Infinite);

                //mFocusSpan.Focus();
            }
            string error = "(行 " + ErrorLine + " - 列 " + (column > -1 ? column.ToString() : string.Empty);
            error += ")"+ ErrorMessage;


            mLblHeader.Content = error;

            if (FuncContext != null)
            {
                mBtnShowWatchWindow.IsEnabled = true;
            }
        }

        Span mFocusSpan = null;
        private void addLine(int lineNo, string line, bool empasis)
        {
            Span span = new Span();
            Run run = new Run(lineNo.ToString() + ": ");
            span.Inlines.Add(run);
            run = new Run(line);
            span.Inlines.Add(run);
            if (empasis)
            {
                span.Background = new SolidColorBrush(Colors.DeepPink);
                span.Foreground = new SolidColorBrush(Colors.Silver);
                mFocusSpan = span;
            }
            mParaBody.LineStackingStrategy = LineStackingStrategy.MaxHeight;
            mParaBody.Inlines.Add(span);
            mParaBody.Inlines.Add(new LineBreak());
        }

        private void TimerCallback(object param)
        {
            this.Dispatcher.BeginInvoke(DispatcherPriority.Normal,
                (ThreadStart)delegate()
            {
                mFocusSpan.Focus();
            });
        }

        private void NTScriptDebugger_Closed(object sender, EventArgs e)
        {
            if (mDontShowWindow)
            {
                mWindows.Clear();
                return;
            }
            if (mWindows.Count > 0)
            {
                mWindows.RemoveAt(0);
                if (mWindows.Count > 0)
                    mWindows[0].Show();
            }
        }

        private void mChkDontShowWindow_Checked(object sender, RoutedEventArgs e)
        {
            mDontShowWindow = true;
        }

        private void mChkDontShowWindow_Unchecked(object sender, RoutedEventArgs e)
        {

        }

        private void mBtnClose_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }
        private void mBtnShowWatchWindow_Click(object sender, RoutedEventArgs e)
        {
            List < DebugMemory> list;
            if (FuncContext.getMemoryList(out list))
            {
                NTMemoryInspectionWindow win = new NTMemoryInspectionWindow();
                win.initParam(list);
                win.ShowWindow();
            }
        }        
    }
}
