﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chView.NtHtml;


namespace NT2chView.NtNet
{
    sealed class NTHttpUtils
    {
        public const string HTTP_PROTOCOL = @"http://";
        public const string HTTPS_PROTOCOL = @"https://";
        public const string HTTP_WRITE_CGI_PATH = @"/test/bbs.cgi";
        public const string HTTP_READ_CGI_PATH = @"/test/read.cgi/";
        public const string HTTP_SLASH = @"/";
        public const string DAT_SUFFIX = ".dat";
        public const string CGI_SUFFIX = ".cgi";
        public const string DEFAULT_SUBMIT = "書き込む";
        public const string MACHI_URL = "machi.to/";
        public const string HOST_2CH = ".2ch.net";
        public const string MARU_HOST = "2chv.tora3.net";
        public const string MARU_LOGIN_PATH = "/futen.cgi";
        public const string LOCAL_DAT_TITEL_PREFIX = "[DAT落]";


        public static int GetTime(DateTime baseTime)
        {
            TimeSpan t = baseTime.ToUniversalTime().Subtract(new DateTime(1970, 1, 1));
            return ((int)(t.TotalSeconds)) - (60*10);
        }


        public static bool TryParseYouTubeId(string source, out string id)
        {
            int len = source.Length;
            int n = source.IndexOf(".youtube.com/");
            if (n > 0)
            {
                int n2 = source.IndexOf("v=", n + 13);
                if (n2+2+11 <= len)
                {
                    id = source.Substring(n2+2, 11);
                    return true;
                }
            }
            n = source.IndexOf("youtu.be/");
            if (n > 0)
            {
                if (len >= (n + 9 + 11))
                {
                    id = source.Substring(n+9, 11);
                    return true;
                }
            }
            id = string.Empty;
            return false;
        }
        public static bool parseBBSAddress(string source, out string boardAddress, out string datName)
        {
            boardAddress = string.Empty;
            datName = string.Empty;

            int idx = source.IndexOf(HTTP_READ_CGI_PATH);
            if (idx < 0)
                return false;


            boardAddress = source.Substring(0, idx + 1);
            idx += HTTP_READ_CGI_PATH.Length;
            if (idx >= source.Length)
                return false;
            while (idx < source.Length)
            {

                int idx2 = source.IndexOf('/', idx);
                if (idx2 < 0)
                    return false;
                if (isDatKey(source, idx, idx2))
                {
                    datName = source.Substring(idx, idx2 - idx);
                }
                else
                {
                    if (datName.Length > 0)
                        return false;
                    boardAddress += source.Substring(idx, idx2 + 1 - idx);
                }
                idx = idx2 + 1;
            }
            if (datName.Length == 0)
                return false;

            if (chkMachiBBSAddress(boardAddress))
                datName = datName + CGI_SUFFIX;
            else
                datName = datName + DAT_SUFFIX;

            return true;
        }

        public static bool isValid2chAddress(string address)
        {
            if (0 > address.IndexOf(HOST_2CH, 
                StringComparison.CurrentCultureIgnoreCase))
                return false;
            else
                return true;
        }

        public static bool chkMachiBBSAddress(string source)
        {
            if (0 > source.IndexOf(MACHI_URL))
                return false;
            else
                return true;
        }

        public static string convertMachiAddress(string address)
        {
            int idx = address.IndexOf(MACHI_URL);
            if (idx < 0)
                return null;

            string result = address.Substring(0, idx + MACHI_URL.Length);
            result += "bbs/offlaw.cgi/";
            result += address.Substring(idx + MACHI_URL.Length);
            return result;

        }

        public static bool splitMachiAddress(string source, out string host, out string bbs)
        {
            host = string.Empty;
            bbs = string.Empty;
            int idx = source.IndexOf(MACHI_URL);
            if (idx < 0)
                return false;
            int idx2 = source.IndexOf('/', idx + MACHI_URL.Length);
            if (idx2 < 0)
                return false;

            host = source.Substring(0, idx + MACHI_URL.Length - 1);
            bbs = source.Substring(idx + MACHI_URL.Length, idx2 - (idx + MACHI_URL.Length));
            return true;
        }

        public static bool parseHostAddress(string source, out string hostName, out string boardName)
        {
            hostName = string.Empty;
            boardName = string.Empty;

            int n1 = source.IndexOf(HTTP_PROTOCOL);
            if (n1 < 0)
                return false;

            n1 += HTTP_PROTOCOL.Length;

            int n2 = source.IndexOf(HTTP_SLASH, n1);
            if (n2 < 0)
                return false;

            int n3 = source.IndexOf(HTTP_SLASH, n2 + 1);
            //int n3 = source.LastIndexOf(HTTP_SLASH);//, n2 + 1);
            if (n3 < 0)// || n3 < (n2+1))
                return false;

            //int n4 = source.IndexOf(HTTP_SLASH, n3 + 1);
            //int n3 = source.LastIndexOf(HTTP_SLASH);//, n2 + 1);
            //if (n4 < 0)
            //{
                hostName = source.Substring(n1, n2 - n1);
                boardName = source.Substring(n2 + 1, n3 - (n2 + 1));
            //}
            //else
            //{
            //    hostName = source.Substring(n1, n3 - n1);
            //    boardName = source.Substring(n3 + 1, n4 - (n3 + 1));
            //}

            return true;
        }

        private static bool isDatKey(string source, int start, int end)
        {
            if (start < 0 || end >= source.Length)
                return false;
            for (int i = start; i < end; i++)
            {
                char c = source[i];
                switch (getToken(c))
                {
                    case NTHtmlUtils.TOKEN.NUMBER:
                        break;
                    default:
                        return false;
                }
            }
            return true;
        }

        public static NTHtmlUtils.TOKEN getToken(char c)
        {
            if (('a' <= c && c <= 'z') || ('A' <= c && c <= 'Z'))
            {
                return NTHtmlUtils.TOKEN.ALPHABET;
            }
            else if ('0' <= c && c <= '9')
            {
                return NTHtmlUtils.TOKEN.NUMBER;
                /*}else if(c == '"'){
                    return NTHtmlUtils.TOKEN.DQUART;
                }else if(c == '\''){
                    return NTHtmlUtils.TOKEN.SQUART;
                }else if(c == '<'){
                    return NTHtmlUtils.TOKEN.LT;
                }else if(c == '>'){
                    return NTHtmlUtils.TOKEN.GT;*/
            }
            else if (c == ' ' || c == '\t' || c == '\n')
            {
                return NTHtmlUtils.TOKEN.WHITESPACE;
            }
            else if (c < 0x21 || 0x7e < c)
            {
                return NTHtmlUtils.TOKEN.CONTROL_CODE;
            }
            else if (c > 0x7f)
            {
                return NTHtmlUtils.TOKEN.NON_ASCII;
            }
            else
            {
                return NTHtmlUtils.TOKEN.OTHER;
            }
        }

        public static int parseWebHost(string source, int start){
    		int charCnt = 0;
    	    NTHtmlUtils.TOKEN previous =  NTHtmlUtils.TOKEN.NOTHING;
    	    char previousC = '\0';
    	    bool hasComma = false; // must has a comma at least one;
    	    bool initFirstChar = false;
    	    bool hasAlphabet = false;
    	    int i;
    	    //DebugUtil.log(source.substring(start));
    	    //LABEL:
            bool loop = true;
    	    for( i = start; i < source.Length; i++){
        	    //DebugUtil.log(source.substring(i));
    		    char c = source[i];
    		    NTHtmlUtils.TOKEN token = getToken(c);
    		    switch(token){
    		    case NTHtmlUtils.TOKEN.ALPHABET:
    			    hasAlphabet = true;
                    initFirstChar = true;
                    charCnt++;
                    break;
                case NTHtmlUtils.TOKEN.NUMBER:
        		    initFirstChar = true;
    			    charCnt++;
    			    break;
    		    case NTHtmlUtils.TOKEN.CONTROL_CODE:
                    loop = false;
    			    break;// LABEL;
    		    case NTHtmlUtils.TOKEN.OTHER:
    		    default:
    			    if(initFirstChar){
	        		    // only hyphen allowed in domain name.
	    			    if('-' == c){
	    				    charCnt++;
	    				    break;
	    			    }
	    			    // not allowed successive comma
	    			    if('.' == c && previousC != '.' && previousC != '-'){
	    				    charCnt++;
	    				    hasComma = true;
	    				    break;
	    			    }
    			    }
                    loop = false;
    			    break;// LABEL;
    		    }
                if(!loop)
                    break;
			    previous = token;
			    previousC = c;
    	    }

    	    if('-' == previousC || '.' == previousC){
    		    charCnt--;
    		    i--;
    		    previousC = source[i];
    	    }
    	
    	    // top domain names haven't degits. 
    	    if(NTHtmlUtils.TOKEN.NUMBER == previous && hasAlphabet == true){
    		    bool loop2 = true;//LABEL2:
    		    for(i--; i > 0; i--){
        		    char c = source[i];
        		    NTHtmlUtils.TOKEN token = getToken(c);
        		    switch(token){
        		    case NTHtmlUtils.TOKEN.NUMBER:
        			    charCnt--;
        			    break;
        		    case NTHtmlUtils.TOKEN.ALPHABET:
        		    default:
                        loop2 = false;
            		    break;// LABEL2; 
        		    }
                    if(!loop2)
                        break;
        		    previous = token;
    		    }
    	    }
    	    return ((NTHtmlUtils.TOKEN.ALPHABET == previous || NTHtmlUtils.TOKEN.NUMBER == previous) && hasComma) ? charCnt : -1;
        }


        public static string ridSuffixFromDatName(string datName)
        {
            int n1 = datName.IndexOf(DAT_SUFFIX);
            if (n1 >= 0)
                datName = datName.Substring(0, n1);
            return datName;
        }
        public static string ridSuffixFromCgiName(string cgiName)
        {
            int n1 = cgiName.IndexOf(CGI_SUFFIX);
            if (n1 >= 0)
                cgiName = cgiName.Substring(0, n1);
            return cgiName;
        }


    }
}
