﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Cache;

namespace NT2chView.NtNet
{
    public sealed partial class NTHttpAccess
    {
        const string HTTP_HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
        const string HTTP_HEADER_LAST_MODIFIED = "Last-Modified";
        public const string HTTP_HEADER_USER_AGENT = "Monazilla/1.00 (monaweb/1.00) Neetchanwin";
        //public const string HTTP_HEADER_USER_AGENT = "Monazilla/1.00";
        const string HTTP_HEADER_COOKIE = "Cookie";
        const string HTTP_HEADER_SET_COOKIE = "Set-Cookie";
        const string HTTP_HEADER_CONTENT_TYPE = "application/x-www-form-urlencoded";
        const string HTTP_REQUEST_GET = "GET";
        const string HTTP_REQUEST_POST = "POST";
        const string URL_2CH_BOARDMENU = "http://menu.2ch.net/bbsmenu.html";
        const string URL_ALLBOARD_SEARCH = "http://s.s2ch.net/search/-/";

        class NTHttpGetClient
        {
            public HttpWebRequest mHttpReq;
            private string mModifiedSince = string.Empty;
            public string ModifiedSince
            {
                get { return mModifiedSince; }
                set
                {
                    DateTime dt;
                    if (DateTime.TryParse(value, out dt))
                    {
                        mHttpReq.IfModifiedSince = dt;
                    }
                }
            }

            public bool AcceptGZip
            {
                set
                {
                    if (value == true)
                    {
                        mHttpReq.AutomaticDecompression = DecompressionMethods.GZip | DecompressionMethods.Deflate;
                    }
                    else
                    {
                        mHttpReq.AutomaticDecompression = DecompressionMethods.None;
                    }
                }
            }

            public int Range
            {
                set { mHttpReq.AddRange(value); }
            }

            public NTHttpGetClient(string url)
            {
                mHttpReq = (HttpWebRequest)WebRequest.Create(url);
                mHttpReq.Method = HTTP_REQUEST_GET;
                mHttpReq.UserAgent = HTTP_HEADER_USER_AGENT;
                mHttpReq.ReadWriteTimeout = 5 * 1000;
                mHttpReq.Timeout = 5 * 1000;
                mHttpReq.CachePolicy = new RequestCachePolicy(RequestCacheLevel.NoCacheNoStore);
                mHttpReq.KeepAlive = false;
                mHttpReq.ContentType = HTTP_HEADER_CONTENT_TYPE;
            }

            public HttpWebResponse execute()
            {
                return (HttpWebResponse)mHttpReq.GetResponse();
            }
        }

        

        class NTHttpPostClient
        {
            public  HttpWebRequest mHttpReq;
            private string mModifiedSince = string.Empty;
           
            public string ModifiedSince
            {
                get { return mModifiedSince; }
                set
                {
                    DateTime dt;
                    if (DateTime.TryParse(value, out dt))
                    {
                        mHttpReq.IfModifiedSince = dt;
                    }
                }
            }

            public void setPostData(byte [] data)
            {
                System.IO.Stream reqStream = mHttpReq.GetRequestStream();
                reqStream.Write(data, 0, data.Length);
                reqStream.Close();
            }

            public NTHttpPostClient(string url, string referer, string host)
                : this(url, referer, host, null, null)
            {
            }
           
            public NTHttpPostClient(string url, string referer, string host,
                List<KeyValuePair<string,string>> headers, string ua)
            {
                mHttpReq = (HttpWebRequest)WebRequest.Create(url);
                mHttpReq.Method = HTTP_REQUEST_POST;
                if(ua == null)
                    mHttpReq.UserAgent = HTTP_HEADER_USER_AGENT;
                else
                    mHttpReq.UserAgent = ua;
                mHttpReq.ReadWriteTimeout = 5 * 1000;
                mHttpReq.Timeout = 5 * 1000;
                mHttpReq.CachePolicy = new RequestCachePolicy(RequestCacheLevel.NoCacheNoStore);
                mHttpReq.KeepAlive = false;
                mHttpReq.ContentType = HTTP_HEADER_CONTENT_TYPE;
                mHttpReq.Accept = "*/*";
                mHttpReq.Referer = referer;
                
                //NTDebug.l("Auto redirect was set : " + mHttpReq.AllowAutoRedirect);
                mHttpReq.AllowAutoRedirect = false;
                
                WebHeaderCollection wHeaderCollection = new WebHeaderCollection();
                wHeaderCollection.Add("Host", host);
                wHeaderCollection.Add("Accept-Language", "ja");
                wHeaderCollection.Add("accept-charset", "Shift_JIS");
                if (headers != null)
                {
                    foreach (KeyValuePair<string, string> pair in headers)
                    {
                        wHeaderCollection.Add(pair.Key, pair.Value);
                    }
                }
                //wHeaderCollection.hea

                //cc.
                //mHttpReq.CookieContainer = cc;

               
           }

            

            public HttpWebResponse execute()
            {
                return (HttpWebResponse)mHttpReq.GetResponse();
            }

        }

    }
}
