﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Security.Cryptography;
using System.Text;

namespace NT2chView.NtNet
{
    class NTCrypt
    {
        //static string mPassword;
        //public static string getPassword()
        //{
        //    return mPassword;
        //}

        public static string getSHA256Hashed(string src)
        {
            byte[] byteValue = Encoding.UTF8.GetBytes(src);

            SHA256 shaM = new SHA256Managed();
            byte[] hashValue = shaM.ComputeHash(byteValue);

            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < hashValue.Length; i++)
            {
                sb.AppendFormat("{0:X2}", hashValue[i]);
            }
            return sb.ToString();
        }
        public static void setPassword(string pass)
        {
            //mPassword = pass;
            KeyAndIV.setPass(pass);
        }
        class KeyAndIV
        {
            byte[] mIV = null;
            byte[] mKEY = null;
            //const string IV = "1234567890123456"; //ascii 16btes (128bit)
            //const string KEY = "12345678901234567890123456789012";//ascii 32bytes (256bit)
            const string SALT = "abcdefghijklmn";
            static KeyAndIV mThis = null;
            //static string mPasswd = string.Empty;//"あいうえお";

            public static void setPass(string pass)
            {
                mThis = new KeyAndIV(pass);
            }

            public static byte[] getIV()
            {
                //if (mThis == null)
                //    mThis = new KeyAndIV();
                return mThis.mIV;
                /*if (mIV != null)
                    return mIV;

                Encoding enc = new UTF8Encoding();
                mIV = enc.GetBytes(IV);
                return mIV;*/
            }
            public static byte[] getKEY()
            {
               return mThis.mKEY;
                /*if (mKEY != null)
                    return mKEY;

                Encoding enc = new UTF8Encoding();
                mKEY = enc.GetBytes(KEY);
                return mKEY;*/
            }

            KeyAndIV(string passwd)
            {
                //byte[] bPass = new UTF8Encoding(false).GetBytes(passwd);
                byte[] bPass = System.Text.Encoding.UTF8.GetBytes(passwd);
                byte[] salt = System.Text.Encoding.UTF8.GetBytes(SALT);
                //Rfc2898DeriveBytesオブジェクトを作成する
                System.Security.Cryptography.Rfc2898DeriveBytes deriveBytes =
                    new System.Security.Cryptography.Rfc2898DeriveBytes(bPass, salt, 1000);
                //.NET Framework 1.1以下の時は、PasswordDeriveBytesを使用する
                //System.Security.Cryptography.PasswordDeriveBytes deriveBytes =
                //    new System.Security.Cryptography.PasswordDeriveBytes(password, salt);
                //反復処理回数を指定する デフォルトで1000回
                //deriveBytes.IterationCount = 1000;

                //共有キーと初期化ベクタを生成する
                mKEY = deriveBytes.GetBytes(256 / 8);
                mIV = deriveBytes.GetBytes(128 / 8);
            }

        }

        /// <summary>
        /// ファイルを暗号化する
        /// </summary>
        /// <param name="sourceFile">暗号化するファイルパス</param>
        /// <param name="destFile">暗号化されたデータを保存するファイルパス</param>
        /// <param name="key">暗号化に使用した共有キー</param>
        /// <param name="iv">暗号化に使用した初期化ベクタ</param>
        public static bool EncryptStream(Stream inStream, out MemoryStream outStream)
        {
            bool bRet = false;
            outStream = null;
            try
            {
                //RijndaelManagedオブジェクトを作成
                System.Security.Cryptography.RijndaelManaged rijndael =
                    new System.Security.Cryptography.RijndaelManaged();

                //設定を変更するときは、変更する
                rijndael.KeySize = 256;
                rijndael.BlockSize = 128;
                rijndael.FeedbackSize = 128;
                rijndael.Mode = System.Security.Cryptography.CipherMode.CBC;
                rijndael.Padding = System.Security.Cryptography.PaddingMode.PKCS7;

                //共有キーと初期化ベクタを作成
                //Key、IVプロパティがnullの時に呼びだすと、自動的に作成される
                //自分で作成するときは、GenerateKey、GenerateIVメソッドを使う
                //key = rijndael.Key;
                //iv = rijndael.IV;
                rijndael.Key = KeyAndIV.getKEY();
                rijndael.IV = KeyAndIV.getIV();

                //string destFile = @"G:\Users\Akira\workspace\WPF Pro\NT2chView\NT2chView\bin\Debug\Data\favorite_test.txt";
                //暗号化されたファイルを書き出すためのFileStream
                //System.IO.FileStream outFs = new System.IO.FileStream(
                //    destFile, System.IO.FileMode.Create, System.IO.FileAccess.Write);
                outStream = new MemoryStream();
                //outStream.Write(BitConverter.GetBytes(rijndael.IV.Length), 0, sizeof(int));
                //outStream.Write(rijndael.IV, 0, rijndael.IV.Length);

                //対称暗号化オブジェクトの作成
                System.Security.Cryptography.ICryptoTransform encryptor =
                    rijndael.CreateEncryptor();
                //暗号化されたデータを書き出すためのCryptoStreamの作成
                System.Security.Cryptography.CryptoStream cryptStrm =
                    new System.Security.Cryptography.CryptoStream(
                        outStream, encryptor,
                        System.Security.Cryptography.CryptoStreamMode.Write);

                //暗号化されたデータを書き出す
                //System.IO.FileStream inFs = new System.IO.FileStream(
                //    sourceFile, System.IO.FileMode.Open, System.IO.FileAccess.Read);
                byte[] bs = new byte[16];
                int readLen;
                while ((readLen = inStream.Read(bs, 0, bs.Length)) > 0)
                {
                    cryptStrm.Write(bs, 0, readLen);
                }

                //閉じる
                //inFs.Close();
                //cryptStrm.Flush();
                cryptStrm.Close();
                encryptor.Dispose();
                //outFs.Close();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            return bRet;
        }

        /// <summary>
        /// ファイルを復号化する
        /// </summary>
        /// <param name="sourceFile">復号化するファイルパス</param>
        /// <param name="destFile">復号化されたデータを保存するファイルパス</param>
        /// <param name="key">暗号化に使用した共有キー</param>
        /// <param name="iv">暗号化に使用した初期化ベクタ</param>
        public static bool DecryptStream(Stream inStream, out MemoryStream outStream)
        //            string sourceFile, string destFile, byte[] key, byte[] iv)
        {
            bool bRet = false;
            outStream = null;
            try
            {
                //RijndaelManagedオブジェクトの作成
                System.Security.Cryptography.RijndaelManaged rijndael =
                    new System.Security.Cryptography.RijndaelManaged();

                rijndael.KeySize = 256;
                rijndael.BlockSize = 128;
                rijndael.FeedbackSize = 128;
                rijndael.Mode = System.Security.Cryptography.CipherMode.CBC;
                rijndael.Padding = System.Security.Cryptography.PaddingMode.PKCS7;
                //共有キーと初期化ベクタを設定
                rijndael.Key = KeyAndIV.getKEY();// key;
                rijndael.IV = KeyAndIV.getIV();// iv;

                //暗号化されたファイルを読み込むためのFileStream
                //System.IO.FileStream inFs = new System.IO.FileStream(
                //    sourceFile, System.IO.FileMode.Open, System.IO.FileAccess.Read);
                //対称復号化オブジェクトの作成
                System.Security.Cryptography.ICryptoTransform decryptor =
                    rijndael.CreateDecryptor(rijndael.Key, rijndael.IV);
                //暗号化されたデータを読み込むためのCryptoStreamの作成
                System.Security.Cryptography.CryptoStream cryptStrm =
                    new System.Security.Cryptography.CryptoStream(
                        inStream, decryptor,
                        System.Security.Cryptography.CryptoStreamMode.Read);

                //復号化されたデータを書き出す
                //System.IO.FileStream outFs = new System.IO.FileStream(
                //    destFile, System.IO.FileMode.Create, System.IO.FileAccess.Write);
                outStream = new MemoryStream();

                byte[] bs = new byte[1024];
                int readLen;
                //復号化に失敗すると例外CryptographicExceptionが発生
                while ((readLen = cryptStrm.Read(bs, 0, bs.Length)) > 0)
                {
                    outStream.Write(bs, 0, readLen);
                }

                //閉じる
                //outFs.Close();
                cryptStrm.Close();
                decryptor.Dispose();
                bRet = true;
            }
            catch (Exception e)
            {
                NTDebug.l(e.Message);
            }
            //inFs.Close();
            return bRet;
        }
    }
}
