﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using NT2chView.NtFile;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

namespace NT2chView.NtNet
{
    public class NTCookie
    {
        class CookieValue
        {
            public CookieValue(string hostName)
            {
                mHostName = hostName;
            }
            public string mHostName;
            public List<KeyValuePair<string, string>> mKeyValueList = new List<KeyValuePair<string, string>>();
        }

        CookieValue findCookieValue(string hostName)
        {
            foreach (CookieValue cv in mCookieValue)
            {
                if(hostName.Equals(cv.mHostName))
                    return cv;
            }
            return null;
        }

        void addCookieValue(CookieValue cv)
        {
            mCookieValue.Add(cv);
        }


        List<CookieValue> mCookieValue = new List<CookieValue>();

        private Uri mHostUri;
        private string mHostName;
        private bool mDomain2ch;


        private CookieContainer mContainer;

        public CookieContainer Container
        {
            get { return mContainer; }
        }

        public string Host
        {
            set
            {
                mHostName = value;
                mHostUri = new Uri("http://" + value);
                retrieveCookie();
            }
        }

        public NTCookie(string host) : this(host, true)
        {
#if false
            mHostName = host;
            mHostUri = new Uri("http://"+host);
            mContainer = new CookieContainer();

            retrieveCookie();
#endif
        }

        public NTCookie(string host, bool domain2ch)
        {
            mDomain2ch = domain2ch;
            mHostName = host;
            mHostUri = new Uri("http://" + host);
            mContainer = new CookieContainer();

            retrieveCookie();
        }

        
        public void saveCookie()
        {
            //string cookie1 = mContainer.GetCookieHeader(mHostUri);
            //string cookie2 = mContainer.GetCookieHeader(new Uri("http://2ch.net"));
            CookieCollection ccol = mContainer.GetCookies(mHostUri);

            foreach (Cookie cookie in ccol)
            {
                CookieValue cv = null;
                string domain = cookie.Domain;
                if (domain == null)
                    continue;
                cv = findCookieValue(domain);
                if (cv == null)
                {
                    cv = new CookieValue(domain);
                    addCookieValue(cv);
                }
                string key = cookie.Name;
                string value = cookie.Value;
                KeyValuePair<string, string> pair 
                    = new KeyValuePair<string, string>(key, value);
                cv.mKeyValueList.Add(pair);
            }
            
            
            foreach (CookieValue cv in mCookieValue)
            {
                NTFileAccess.saveCookie(cv.mKeyValueList, cv.mHostName);
            }

        }

        void retrieveCookie()
        {
            
            List<KeyValuePair<string, string>> rootList = NTFileAccess.retrieveCookie(".2ch.net");
            List<KeyValuePair<string, string>> list = NTFileAccess.retrieveCookie(mHostName);
            
            if(mDomain2ch)
                list.AddRange(rootList);

            if (list.Count > 0)
            {
                string cookieHeader = constructCookieHeader(list);
                mContainer.SetCookies(mHostUri, cookieHeader);
            }

        }

 
        string constructCookieHeader(List<KeyValuePair<string, string>> list)
        {
            NTDebug.l(" *** Entering constructCookieHeader *** ");
            StringBuilder result = new StringBuilder();
            result.Append(" ");
            int i = 0;
            for(; i < list.Count; i++)
            {
                if (0 < i)
                {
                    //result.Append("; ");
                    result.Append(",");
                }
                KeyValuePair<string, string> pair = list[i];
                NTDebug.l("\t "+pair.Key+" : "+pair.Value);
                result.Append(pair.Key).Append("=").Append(pair.Value);
            }
            return (i == 0) ? null : result.ToString();

        }



    }
}
