﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;
using NT2chView.NtFile;

namespace NT2chView
{
    class NTWriteResHistoryPopup : Popup
    {
        NTWriteResWindow mWnd;
        public NTWriteResHistoryPopup(NTWriteResWindow wnd, string[] history)
            : base()
        {
            mWnd = wnd;
            this.StaysOpen = false;

            Grid grid = new Grid();
            ScrollViewer sv = new ScrollViewer();
            ListBox lBox = new ListBox();
            grid.Children.Add(sv);
            sv.Content = lBox;
            sv.MaxHeight = mWnd.Height;
            sv.MaxWidth = 480;
            sv.MinWidth = 150;

            this.Child = grid;

            ListBoxItem li;
            foreach (string s in history)
            {
                string s2 = NTTextFormat.removeTag(s);
                StackPanel sp = new StackPanel();
                //Border border = new Border();
                //border.BorderThickness = new System.Windows.Thickness(1);
                //border.BorderBrush = new SolidColorBrush(Colors.DarkGray);
                //border.VerticalAlignment = VerticalAlignment.Stretch;
                //border.HorizontalAlignment = HorizontalAlignment.Stretch;
                sp.Children.Add(new TextBlock(new Run(s2)));
                sp.MouseLeftButtonDown += sp_MouseLeftButtonDown;
                sp.Tag = s2;
                //border.Child = sp;           
                li = new ListBoxItem();
                li.Content = sp;
                lBox.Items.Add(li);
            }

        }

        void sp_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            StackPanel sp = sender as StackPanel;
            if (sp == null)
                return;

            string msg = sp.Tag as string;
            if (msg == null)
                return;

            mWnd.setMsg(msg);

            IsOpen = false;


        }
        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
           // Focus();
        }


    }
}
