﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using NT2chObject;

namespace NT2chView
{
    /// <summary>
    /// NTGraphicsPanel.xaml の相互作用ロジック
    /// </summary>
    public partial class NTGraphicsPanel : UserControl
    {
        const string ERROR_CAPTION = "入力エラー";
        const string ERROR_MESSAGE = "整数値を入力してください";

        public NTGraphicsPanel()
        {
            InitializeComponent();
        }

        public void Init()
        {
        }

        public void AddGraphic(string path)
        {
            if (path == null || !File.Exists(path))
                return;
   
            try
            {
                BitmapImage bi = new BitmapImage();

                bi.BeginInit();

                bi.CacheOption = BitmapCacheOption.OnDemand;
                bi.CreateOptions = BitmapCreateOptions.DelayCreation;
                //bi.DecodePixelHeight = height;
                //bi.DecodePixelWidth = width;
                bi.UriSource = new Uri(path, UriKind.Absolute);

                bi.EndInit();
     
                Image img = new Image();
                img.Stretch = System.Windows.Media.Stretch.UniformToFill;
                img.Tag = path;
                //img.Width = width;
                //img.Height = height;
                img.Source = bi;
                img.MouseEnter += img_MouseEnter;
                img.MouseLeave += img_MouseLeave;
                img.MouseMove += img_MouseMove;
                img.MouseLeftButtonDown += img_MouseLeftButtonDown;


                Grid grid = new Grid();

                grid.Children.Add(img);

                img = new Image();
                img.Width = 9;
                img.Height = 9;
                Uri oUri = new Uri(
                    "pack://application:,,,/NT2chStyle;component/images/close_tab.png",
                    UriKind.RelativeOrAbsolute);
                bi = new BitmapImage();
                bi.BeginInit();
                bi.UriSource = oUri;

                bi.EndInit();
                img.Source = bi;

                Button btn = new Button();
                btn.Content = img;
                btn.HorizontalAlignment = System.Windows.HorizontalAlignment.Right;
                btn.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                btn.Margin = new Thickness(4);
                btn.Click += btn_Click;
                
                grid.Children.Add(btn);

                btn.Visibility = System.Windows.Visibility.Hidden;


                grid.VerticalAlignment = System.Windows.VerticalAlignment.Center;

                mGrallyPanel.Children.Insert(0,grid);
                ScrollViewer sv = mGrallyPanel.Parent as ScrollViewer;
                sv.ScrollToTop();

            }
            catch (Exception e)
            {

            }
 
        }

        void img_MouseMove(object sender, MouseEventArgs e)
        {
            if (mSelectedImage == null)
                return;

            Image img = sender as Image;
            if (img == null || !mSelectedImage.Equals(img))
            {
                mSelectedImage = null;
                return;
            }
            string path = img.Tag as string;
            if (path == null)
            {
                mSelectedImage = null;
                return;
            }
            string[] arr = new string[1];
            arr[0] = path;

            double DELTA = 8;
            Point point = e.GetPosition(img);
            Vector v = Point.Subtract(point, mObserveMousePoint);
            if (v.Length > DELTA)
            {
                DataObject dObj = new DataObject(
                    DataFormats.FileDrop, arr);
                DragDrop.DoDragDrop(img, dObj, DragDropEffects.Copy);
                //e.Handled = true;
                mSelectedImage = null;
            }

        }

        Image mSelectedImage = null;
        Point mObserveMousePoint;
        void img_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            mSelectedImage = sender as Image;
            if (mSelectedImage == null)
                return;

            mObserveMousePoint = e.GetPosition(mSelectedImage);
            //Mouse.Capture(mSelectedImage, CaptureMode.Element);

        }

        void btn_Click(object sender, RoutedEventArgs e)
        {
            Button btn = sender as Button;
            if (btn == null)
                return;

            Grid grid = btn.Parent as Grid;
            if (grid == null)
                return;

            mGrallyPanel.Children.Remove(grid);



        }

        void img_MouseLeave(object sender, MouseEventArgs e)
        {
 
            Image img = sender as Image;
            if (img == null)
                return;

            Grid grid = img.Parent as Grid;
            if (grid == null)
                return;

            if (grid.Children.Count != 2)
                return;

            Button btn = grid.Children[1] as Button;
            if (btn == null)
                return;

            double btnHeight = btn.ActualHeight;
            double btnWidth = btn.ActualWidth;

            Point pos = e.GetPosition(grid);
            if ((pos.X > (grid.ActualWidth - (btnWidth + 4)) &&
                pos.X < (grid.ActualWidth - 4)) &&
                (pos.Y < (btnHeight + 4)) && pos.Y > 4)
                return;


            btn.Visibility = System.Windows.Visibility.Hidden;
        }

        void img_MouseEnter(object sender, MouseEventArgs e)
        {
            Image img = sender as Image;
            if (img == null)
                return;

            Grid grid = img.Parent as Grid;
            if (grid == null)
                return;

            if (grid.Children.Count != 2)
                return;

            Button btn = grid.Children[1] as Button;
            if (btn == null)
                return;
            btn.Visibility = System.Windows.Visibility.Visible;
        }

 
        /*private void mEdtImageWidth_LostFocus(object sender, RoutedEventArgs e)
        {
            TextBox tb = sender as TextBox;
            if (tb == null)
                return;
            int value;
            if (!int.TryParse(tb.Text, out value))
            {
                MessageBox.Show(ERROR_MESSAGE,ERROR_CAPTION);
                tb.Text = NTUserPreference.ImageViewWidth.ToString();
                return;
            }
            NTUserPreference.ImageViewWidth = value;

        }
        private void mEdtImageHeight_LostFocus(object sender, RoutedEventArgs e)
        {
            TextBox tb = sender as TextBox;
            if (tb == null)
                return;
            int value;
            if (!int.TryParse(tb.Text, out value))
            {
                MessageBox.Show(ERROR_MESSAGE, ERROR_CAPTION);
                tb.Text = NTUserPreference.ImageViewHeight.ToString();
                return;
            }
            NTUserPreference.ImageViewHeight = value;
        }*/
        private void mEdtThumbmailHeight_LostFocus(object sender, RoutedEventArgs e)
        {
            TextBox tb = sender as TextBox;
            if (tb == null)
                return;
            int value;
            if (!int.TryParse(tb.Text, out value))
            {
                MessageBox.Show(ERROR_MESSAGE, ERROR_CAPTION);
                tb.Text = NTUserPreference.ResViewThumbnailHeight.ToString();
                return;
            }
            NTUserPreference.ResViewThumbnailHeight = value;
        }
        
        private void mEdtThumnailWidth_LostFocus(object sender, RoutedEventArgs e)
        {
            TextBox tb = sender as TextBox;
            if (tb == null)
                return;
            int value;
            if (!int.TryParse(tb.Text, out value))
            {
                MessageBox.Show(ERROR_MESSAGE, ERROR_CAPTION);
                tb.Text = NTUserPreference.ResViewThumbnailWidth.ToString();
                return;
            }
            NTUserPreference.ResViewThumbnailWidth = value;
        }

        private void mChkShowThumbnail_Unchecked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.ResViewShowThumbnail = false;
        }

        private void mChkShowThumbnail_Checked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.ResViewShowThumbnail = true;
        }

        private void UserControl_Loaded(object sender, RoutedEventArgs e)
        {
            //mEdtImageHeight.Text = NTUserPreference.ImageViewHeight.ToString();
            //mEdtImageWidth.Text = NTUserPreference.ImageViewWidth.ToString();

            mEdtThumbnailHeight.Text = NTUserPreference.ResViewThumbnailHeight.ToString();
            mEdtThumbnailWidth.Text = NTUserPreference.ResViewThumbnailWidth.ToString();

            mChkShowThumbnail.IsChecked = NTUserPreference.ResViewShowThumbnail;
        }

        private void mBtnClearGarally_Click(object sender, RoutedEventArgs e)
        {
            mGrallyPanel.Children.Clear();
        }



        /*private bool ShowThumbnail
        {
            get
            {
                object o;
                if (!mDict.TryGetValue(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL, out o))
                    return false;
                bool? show = o as bool?;

                return (show.HasValue && (bool)show);
            }
            set
            {
                mDict.Remove(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL);
                mDict.Add(PREF_PARAM.RES_VIEW_SHOW_THUMBNAIL,
                    (value ? bool.TrueString : bool.FalseString));

            }
        }*/
 
    }
}
