﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chView
{
    public class NTBoardPopupMenu : Popup
    {
        public delegate void DelegateMsgOnNotifiAddBoardToFavorite(string boardName);
        public event DelegateMsgOnNotifiAddBoardToFavorite OnNotifiAddBoardToFavorite;

        string mBoardName;

        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
        }

        public NTBoardPopupMenu(string boardName)
            : base()
        {

            mBoardName = boardName;
 
            this.StaysOpen = false;
            //this.MouseLeave += NTResPopupMenu_MouseLeave;
            //this.LostFocus += NTResPopupMenu_LostFocus;
            
            

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);
           

            ListBoxItem item1 = new ListBoxItem();

            sp = new StackPanel();
            //sp.MouseLeftButtonDown += threadTitle_MouseLeftButtonDown;
            sp.Children.Add(new TextBlock(new Run(mBoardName)));
            //sp.Tag = tt;
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            //item1.Tag = tt;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("お気に入りに追加")));
            sp.MouseLeftButtonDown += itemDelete_MouseLeftButtonDown;
            sp.Tag = mBoardName;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            //item1.MouseLeftButtonDown += item1_MouseLeftButtonDown;
            //item1.MouseLeftButtonUp += item1_MouseLeftButtonUp;
            panel.Children.Add(item1);
 

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += itemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            //item1.MouseEnter += item1_MouseEnter;
            //item1.MouseLeave += item1_MouseLeave;
            //item1.MouseLeftButtonDown += item1_MouseLeftButtonDown;
            //item1.MouseLeftButtonUp += item1_MouseLeftButtonUp;
            panel.Children.Add(item1);
            //this.Child = panel;
            border.Child = panel; 
            this.Child = border;

        }

        void itemDelete_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            if (OnNotifiAddBoardToFavorite != null)
            {
                OnNotifiAddBoardToFavorite(mBoardName);
            }
        }

        void itemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //Hide();
            IsOpen = false;
            //mMainWnd.NgEdit_setResSection(mRes);
        }
    }
}
