﻿using System;
using System.Collections.Generic;
using System.Text;


namespace NT2chCtrl.html.js
{
    public enum JsToken
    {
        TYPE_ERROR ,
        TYPE_END_SRC,
        TYPE_KEYWORD,
        TYPE_DOM_KEYWORD,
        TYPE_DOM_STR_KEYWORD,
        TYPE_OP_KEYWORD,
        TYPE_NULL,
        TYPE_BOOLEAN,
        TYPE_NUMBER_LITERAL ,
        TYPE_PUNCTUATOR ,
        TYPE_STRING_LITERAL,
        TYPE_VARIABLENAME ,
        TYPE_ARRAY_SUBSCRIPT ,


        KEY_NOT_KEY ,
        KEY_NAN ,
        KEY_TRUE,
        KEY_FALSE ,
        KEY_NULL ,
        KEY_THIS,
        KEY_UNDEFINED,
        KEY_FUNCTION,
        KEY_VAR,

        KEY_DOM_DOCUMENT,
        KEY_DOM_getElementById,
        KEY_DOM_innerHTML,
        KEY_DOM_STR_substring,
        KEY_DOM_STR_substr,
        KEY_DOM_STR_length,
        KEY_DOM_STR_indexOf,
        KEY_DOM_STR_replace,

        KEY_OP_IF,
        KEY_OP_ELSE,
        KEY_OP_FOR,
        KEY_OP_WHILE,
        KEY_OP_LOOP_BREAK,
        KEY_OP_LOOP_CONTINUE,
        KEY_OP_CMP_LT,
        KEY_OP_CMP_GT,
        KEY_OP_CMP_LT_EQUAL,
        KEY_OP_CMP_GT_EQUAL,
        KEY_OP_CMP_EQUAL,
        KEY_OP_CMP_STRICT_EQUAL,
        KEY_OP_CMP_NOT_EQUAL,
        KEY_OP_CMP_STRICT_NOT_EQUAL,

        KEY_OP_DEBUGGER,


        PUNC_OP_NOT,
        PUNC_NO_PUNC,
        PUNC_EQUAL,
        PUNC_ADD,
        PUNC_SUB,
        PUNC_MUL,
        PUNC_DIV,
        PUNC_INC,
        PUNC_DEC,
        PUNC_SEMICOL0N,
        PUNC_COMMA,
        PUNC_PERIOD,
        PUNC_L_BRACKET,
        PUNC_R_BRACKET,
        PUNC_L_CURLY_BRACKET,
        PUNC_R_CURLY_BRACKET,


    }

    public struct JsTokenStruct
    {
        public JsToken type;
        public JsToken keyword;
        public double dValue;
        public string sValue;

        /*public void init()
        {
            this.type = JsToken.TYPE_ERROR;
            this.keyword = 0;
            this.dValue = 0;
            this.sValue = null;
        }*/

        public void setToken(JsToken type, JsToken key)
        {
            this.type = type;
            this.keyword = key;
            this.dValue = 0;
            this.sValue = null;
        }
        public void setToken(JsToken type, JsToken key, double value)
        {
            this.type = type;
            this.keyword = 0;
            this.dValue = value;
            this.sValue = null;
        }
        public void setToken(JsToken type, JsToken key, string value)
        {
            this.type = type;
            this.keyword = 0;
            this.dValue = 0;
            this.sValue = value;
        }
    }

    partial class JsParser
    {
        /*private int setToken(JsToken typeCode, JsToken keyCode)
        {
            
            return (int)typeCode + (int)keyCode;
        }
        //HIGH BYTE
        const int TYPE_MASK = 0xFF00;
        //public enum JsTYPE
        //{
        //LOW BYTE
        const int KEY_MASK = 0xFF;

        public JsToken getTypeToken(int value)
        {
            return (JsToken)(value & TYPE_MASK);
        }
        public JsToken getKeyToken(int value)
        {
            return (JsToken)(value & KEY_MASK);
        }*/

 
        public static int getJsToken(DebugContext ctx, string source, int startIdx, out JsTokenStruct outToken)
        {
            string sVal;
            double dVal;
            int nVal;
            outToken.type = JsToken.TYPE_ERROR;
            outToken.keyword = JsToken.KEY_NOT_KEY;
            outToken.dValue = 0;
            outToken.sValue = null;


            JsToken key;
            JsToken type;

            int comma = 0;
            
            if (source == null)
                return -1;// setToken(JsToken.TYPE_ERROR, 0);
            int length = source.Length;
            if(length < startIdx)
                return -1;// setToken(JsToken.TYPE_ERROR, 0);
            
            int state = 0;
            int textStart = 0;
            int textEnd = 0;
            for (int i = startIdx; i < length; i++)
            {
                char c = source[i];
                HtmlParser.CHAR_TOKEN token =
                    HtmlParser.getCharToken(c);
                switch (token)
                {
                    case HtmlParser.CHAR_TOKEN.NL:
                        ctx.incrementLine();
                        goto FALLTHROUGH_WHITESPACE;
                    case HtmlParser.CHAR_TOKEN.WHITESPACE:
                FALLTHROUGH_WHITESPACE:
                        if (state == 0)
                        {
                            break;
                        }
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                 outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);
                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            if (!double.TryParse(sVal, out dVal))
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0, dVal);
                            return i;
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if (state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                      break;
                    case HtmlParser.CHAR_TOKEN.DQUOTE:
                        if (state == 0)
                        {
                            textEnd = getDquote(source, i + 1, out sVal);
                            if (textEnd < 0)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_STRING_LITERAL,
                                JsToken.KEY_NOT_KEY, sVal);//source.Substring(i+1, textEnd - (i+1)));
                            return textEnd + 1;
                        }
                        goto FALLTHROUGH_WHITESPACE;
#if false
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                //key = findDomKeyword(sVal);
                                //if (JsToken.KEY_NOT_KEY != key)
                                //    outToken.setToken(JsToken.TYPE_DOM_KEYWORD, key);
                                //else
                                outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);

                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            if (!double.TryParse(sVal, out dVal))
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0, dVal);
                            return i;
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if (state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                        break;
#endif
                    case HtmlParser.CHAR_TOKEN.SQUOTE:
                        if (state == 0)
                        {
                            textEnd = getSquote(source, i + 1, out sVal);
                            if (textEnd < 0)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_STRING_LITERAL,
                                JsToken.KEY_NOT_KEY, sVal);//source.Substring(i + 1, textEnd - (i + 1)));
                            return textEnd + 1;
                        }
                        goto FALLTHROUGH_WHITESPACE;
#if false
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                //key = findDomKeyword(sVal);
                                //if (JsToken.KEY_NOT_KEY != key)
                                //    outToken.setToken(JsToken.TYPE_DOM_KEYWORD, key);
                                //else
                                outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);

                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            if (!double.TryParse(sVal, out dVal))
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0, dVal);
                            return i;
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if (state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                        break;
#endif
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                    case HtmlParser.CHAR_TOKEN.DOLLAR:
                    case HtmlParser.CHAR_TOKEN.UNDERBAR:
                        if (state == 0)
                        {
                            state = 1;
                            textStart = i;
                        }
                        else if (state == 1)
                        {
                            break;
                        }
                        else if (state == 2)
                        {
                            ctx.setCurrentIdx(i);
                            //return setToken(JsToken.TYPE_ERROR, 0);
                            return -1;
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if (state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.NUMBER:
                        if (state == 0)
                        {
                            comma = 0;
                            state = 2;
                            textStart = i;
                        }
                        else if (state == 1 || state == 2)
                        {
                            break;
                        }
                        else if (state == 3)
                        {
                            state = 2;
                        }
                        else if (state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.PERIOD:
                        if (state == 0)
                        {
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, JsToken.PUNC_PERIOD);
                            return i + 1;
                        }
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);

                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            if (comma == 0)
                            {
                                comma++;
                                textEnd = i;
                                state = 3;
                                break;
                            }
                            else
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        break;

                    case HtmlParser.CHAR_TOKEN.SEMICOLON:
                    case HtmlParser.CHAR_TOKEN.COMMA:
                    case HtmlParser.CHAR_TOKEN.L_BRACKET:
                    case HtmlParser.CHAR_TOKEN.R_BRACKET:
                    case HtmlParser.CHAR_TOKEN.L_CURLY_BRACKET:
                    case HtmlParser.CHAR_TOKEN.R_CURLY_BRACKET:
                        if (state == 0)
                        {
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, validatePunctuation(source.Substring(i, 1)));
                            return i + 1;
                        }
                        goto FALLTHROUGH_WHITESPACE;
#if false
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                //key = findDomKeyword(sVal);
                                //if (JsToken.KEY_NOT_KEY != key)
                                //    outToken.setToken(JsToken.TYPE_DOM_KEYWORD, key);
                                //else
                                outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);

                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            if (!double.TryParse(sVal, out dVal))
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0, dVal);
                            return i;
                        }
                        else if (state == 3)
                        {
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if(state == 4)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            key = validatePunctuation(sVal);
                            if (key == JsToken.PUNC_NO_PUNC)
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_PUNCTUATOR, key);
                            return i;
                        }
                        break;
#endif
                    case HtmlParser.CHAR_TOKEN.SLASH:
                        if (parseComment(ctx, source, i+1, out nVal))
                        {
                            if (state != 0)
                                goto FALLTHROUGH_WHITESPACE;
                            i = nVal;
                            break;
                        }
                        goto FALLTHROUGH1;
                    case HtmlParser.CHAR_TOKEN.EQUAL:
                    case HtmlParser.CHAR_TOKEN.HYPHIEN:
                    case HtmlParser.CHAR_TOKEN.PLUS:
                    case HtmlParser.CHAR_TOKEN.ASTOR:
                    case HtmlParser.CHAR_TOKEN.LT:
                    case HtmlParser.CHAR_TOKEN.GT:
                    case HtmlParser.CHAR_TOKEN.EXCLAMATION:
                FALLTHROUGH1:
                        if (state == 0)
                        {
                            state = 4;
                            textStart = i;
                        }
                        else if (state == 1)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            type = findKeyword(sVal, out key);
                            if (JsToken.TYPE_ERROR != type)
                                outToken.setToken(type, key);
                            else
                            {
                                //key = findDomKeyword(sVal);
                                //if (JsToken.KEY_NOT_KEY != key)
                                //    outToken.setToken(JsToken.TYPE_DOM_KEYWORD, key);
                               // else
                                outToken.setToken(JsToken.TYPE_VARIABLENAME, 0, sVal);

                            }
                            return i;
                        }
                        else if (state == 2)
                        {
                            sVal = source.Substring(textStart, i - textStart);
                            if (!double.TryParse(sVal, out dVal))
                            {
                                ctx.setCurrentIdx(i);
                                return -1;
                            }
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0, dVal);
                            return i;
                        }
                        else if (state == 3)
                        {
                            //endIdx = textEnd;
                            outToken.setToken(JsToken.TYPE_NUMBER_LITERAL, 0);
                            return textEnd;
                        }
                        else if(state == 4)
                        {
                            break;
                        }
                        break;
                }
            }
            outToken.setToken(JsToken.TYPE_END_SRC, 0);
            return length;
        }
        private static bool parseComment(DebugContext ctx, string source, int startIdx, out int endIdx)
        {
            int nVal;
            int length = source.Length;
            char c;
            endIdx = length;
            if (startIdx >= length)
                return false;
            char cNext = source[startIdx];
            if (cNext == '/')
            {
                nVal = source.IndexOf('\n', startIdx+1);
                if (nVal >= 0)
                {
                    ctx.incrementLine();
                    endIdx = nVal;
                }
            }
            else if (cNext == '*')
            {
                for (int i = startIdx+1; i < length; i++)
                {
                    c = source[i];
                    if (c == '\n')
                    {
                        ctx.incrementLine();
                    }
                    else if (c == '*')
                    {
                        if (i + 1 < length)
                        {
                            if (source[i + 1] == '/')
                            {
                                endIdx = i + 1;
                                break;
                            }
                        }
                    }
                }
            }
            else
            {
                return false;
            }
            return true;
        }

        private static JsToken findKeyword(string source, out JsToken keyToken)
        {
            switch (source)
            {
                case "NaN":
                    keyToken = JsToken.KEY_NAN;
                    return JsToken.TYPE_KEYWORD;
                case "true":
                    keyToken = JsToken.KEY_TRUE;
                    return JsToken.TYPE_KEYWORD;
                case "false":
                    keyToken = JsToken.KEY_FALSE;
                    return JsToken.TYPE_KEYWORD;
                case "null":
                    keyToken = JsToken.KEY_NULL;
                    return JsToken.TYPE_KEYWORD;
                case "this":
                    keyToken = JsToken.KEY_THIS;
                    return JsToken.TYPE_KEYWORD;
                case "undefined":
                    keyToken = JsToken.KEY_UNDEFINED;
                    return JsToken.TYPE_KEYWORD;
                case "function":
                    keyToken = JsToken.KEY_FUNCTION;
                    return JsToken.TYPE_KEYWORD;
                case "var":
                    keyToken = JsToken.KEY_VAR;
                    return JsToken.TYPE_KEYWORD;
                case "document":
                    keyToken = JsToken.KEY_DOM_DOCUMENT;
                    return JsToken.TYPE_DOM_KEYWORD;
                case "getElementById":
                    keyToken = JsToken.KEY_DOM_getElementById;
                    return JsToken.TYPE_DOM_KEYWORD;
                case "innerHTML":
                    keyToken = JsToken.KEY_DOM_innerHTML;
                    return JsToken.TYPE_DOM_KEYWORD;
                case "substring":
                    keyToken = JsToken.KEY_DOM_STR_substring;
                    return JsToken.TYPE_DOM_STR_KEYWORD;
                case "length":
                    keyToken = JsToken.KEY_DOM_STR_length;
                    return JsToken.TYPE_DOM_STR_KEYWORD;
                case "indexOf":
                    keyToken = JsToken.KEY_DOM_STR_indexOf;
                    return JsToken.TYPE_DOM_STR_KEYWORD;
                case "replace":
                    keyToken = JsToken.KEY_DOM_STR_replace;
                    return JsToken.TYPE_DOM_STR_KEYWORD;
                case "if":
                    keyToken = JsToken.KEY_OP_IF;
                    return JsToken.TYPE_OP_KEYWORD;
                case "else":
                    keyToken = JsToken.KEY_OP_ELSE;
                    return JsToken.TYPE_OP_KEYWORD;
                case "for":
                    keyToken = JsToken.KEY_OP_FOR;
                    return JsToken.TYPE_OP_KEYWORD;
                case "while":
                    keyToken = JsToken.KEY_OP_WHILE;
                    return JsToken.TYPE_OP_KEYWORD;
                case "break":
                    keyToken = JsToken.KEY_OP_LOOP_BREAK;
                    return JsToken.TYPE_OP_KEYWORD;
                case "continue":
                    keyToken = JsToken.KEY_OP_LOOP_CONTINUE;
                    return JsToken.TYPE_OP_KEYWORD;
                case "debugger":
                    keyToken = JsToken.KEY_OP_DEBUGGER;
                    return JsToken.TYPE_OP_KEYWORD;
                default:
                    keyToken = JsToken.KEY_NOT_KEY;
                    return JsToken.TYPE_ERROR;
            }
        }

/*        private static JsToken findDomKeyword(string source)
        {
            switch (source)
            {
                case "document":
                    return JsToken.KEY_DOM_DOCUMENT;
                case "getElementById":
                    return JsToken.KEY_DOM_getElementById;
                case "innerHTML":
                    return JsToken.KEY_DOM_innerHTML;
            }
            return JsToken.KEY_NOT_KEY;
        }
        */
        private static int getDquote(string source, int startIdx , out string retSrc)
        {
            bool dquoteEscape = false;
            bool squoteEscape = false;
            retSrc = source;
            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                switch (source[i])
                {
                    case '\"':
                        if (source[i - 1] != '\\')
                        {
                            retSrc = source.Substring(startIdx, i - startIdx);
                            if (dquoteEscape)
                            {
                                retSrc = retSrc.Replace("\\\"", "\"");
                            }
                            if (squoteEscape)
                            {
                                retSrc = retSrc.Replace("\\\'", "\'");
                            }
                            return i;
                        }
                        dquoteEscape = true;
                        break;
                    case '\'':
                        if (source[i - 1] == '\\')
                        {
                            squoteEscape = true;
                        }
                        break;
                }
            }
            return -1;
        }
        private static int getSquote(string source, int startIdx, out string retSrc)
        {
            bool dquoteEscape = false;
            bool squoteEscape = false;
            retSrc = source;
            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                switch (source[i])
                {
                    case '\'':
                        if (source[i - 1] != '\\')
                        {
                            retSrc = source.Substring(startIdx, i - startIdx);
                            if (dquoteEscape)
                            {
                                retSrc = retSrc.Replace("\\\"", "\"");
                            }
                            if (squoteEscape)
                            {
                                retSrc = retSrc.Replace("\\\'", "\'");
                            }
                            return i;
                        }
                        squoteEscape = true;
                        break;
                    case '\"':
                        if (source[i - 1] == '\\')
                        {
                            dquoteEscape = true;
                        }
                        break;
                }
            }
            return -1;
#if false
            int length = source.Length;
            for (int i = startIdx; i < length; i++)
            {
                char c1 = source[i-1];
                char c2 = source[i];
                if (c1 != '\\' && c2 == '\'')
                    return i;
            }
            return -1;
#endif
        }

        private static JsToken validatePunctuation(string source)
        {
            switch (source)
            {
                case "!":
                    return JsToken.PUNC_OP_NOT;
                case ",":
                    return JsToken.PUNC_COMMA;
                case ";":
                    return JsToken.PUNC_SEMICOL0N;
                case "(":
                    return JsToken.PUNC_L_BRACKET;
                case ")":
                    return JsToken.PUNC_R_BRACKET;
                case "{":
                    return JsToken.PUNC_L_CURLY_BRACKET;
                case "}":
                    return JsToken.PUNC_R_CURLY_BRACKET;
                case "+":
                    return JsToken.PUNC_ADD;
                case "-":
                    return JsToken.PUNC_SUB;
                case "*":
                    return JsToken.PUNC_MUL;
                case "/":
                    return JsToken.PUNC_DIV;
                case "++":
                    return JsToken.PUNC_INC;
                case "--":
                    return JsToken.PUNC_DEC;
                case "=":
                    return JsToken.PUNC_EQUAL;
                case "==":
                    return JsToken.KEY_OP_CMP_EQUAL;
                case "===":
                    return JsToken.KEY_OP_CMP_STRICT_EQUAL;
                case "!=":
                    return JsToken.KEY_OP_CMP_NOT_EQUAL;
                case "!==":
                    return JsToken.KEY_OP_CMP_STRICT_NOT_EQUAL;
                case "<":
                    return JsToken.KEY_OP_CMP_LT;
                case ">":
                    return JsToken.KEY_OP_CMP_GT;
                case "<=":
                    return JsToken.KEY_OP_CMP_LT_EQUAL;
                case ">=":
                    return JsToken.KEY_OP_CMP_GT_EQUAL;

                default:
                    return JsToken.PUNC_NO_PUNC;
            }
        }


    }
}
