﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    class JsIncrementFunction : JsFunction
    {
        JsIdentifier mOperand;
        public JsIncrementFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_INC;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsVariant var;
            int count = insList.Count;
            if (currIdx >= count || count < 2)
                return false;

            if (currIdx > 0)
            {
                var = insList[currIdx - 1];
                if (var is JsIdentifier)
                {
                    mOperand = (JsIdentifier)var;
                    insList.RemoveAt(currIdx - 1);
                    mArranged = true;
                    return true;
                }
            }
            if (currIdx + 1 < count)
            {
                var = insList[currIdx + 1];
                if (var is JsIdentifier)
                {
                    mOperand = (JsIdentifier)var;
                    insList.RemoveAt(currIdx + 1);
                    mArranged = true;
                    return true;
                }
            }
            return false;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsNumberValue nVal = ctx.getParamValue(rootElement, mOperand) as JsNumberValue;
            if (nVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_OPERAND_TYPE;
                return null;
            }
            ctx.setValue(mOperand, new JsNumberValue(nVal.getValue() + 1));

            return mOperand;
        }
    }
    class JsDecrementFunction : JsFunction
    {
        JsIdentifier mOperand;
        public JsDecrementFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_DEC;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsVariant var;
            int count = insList.Count;
            if (currIdx >= count || count < 2)
                return false;

            if (currIdx > 0)
            {
                var = insList[currIdx - 1];
                if (var is JsIdentifier)
                {
                    mOperand = (JsIdentifier)var;
                    insList.RemoveAt(currIdx - 1);
                    mArranged = true;
                    return true;
                }
            }
            if (currIdx + 1 < count)
            {
                var = insList[currIdx + 1];
                if (var is JsIdentifier)
                {
                    mOperand = (JsIdentifier)var;
                    insList.RemoveAt(currIdx + 1);
                    mArranged = true;
                    return true;
                }
            }
            return false;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsNumberValue nVal = ctx.getParamValue(rootElement, mOperand) as JsNumberValue;
            if (nVal == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_OPERAND_TYPE;
                return null;
            }
            ctx.setValue(mOperand, new JsNumberValue(nVal.getValue() - 1));

            return mOperand;
        }
    }
    class JsNotFunction : JsFunction
    {
        JsVariant mOperand;
        public JsNotFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_NOT;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsVariant var;
            int count = insList.Count;
            if (currIdx >= count || count < 2)
                return false;

            if (currIdx + 1 < count)
            {
                var = insList[currIdx + 1];
                mOperand = var;
                insList.RemoveAt(currIdx + 1);
                mArranged = true;
                return true;

            }
            return false;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);
            JsVariant var = ctx.getParamValue(rootElement, mOperand);
            if (var == null)
                return null;
            JsBooleanValue bVal = var.getBooleanValue();
            if (bVal == null)
                return null;
            return JsBooleanValue.getConstantValue(!bVal.getValue());
        }
    }
}
