﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    class JsPlusFunction : JsFunction
    {
        JsVariant mOperand;
        public JsPlusFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_PLUS;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 2 || currIdx + 1 >= count)
                return false;

            mOperand = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);
            JsNumberValue nVal = mOperand.getNumberValue();
            if (nVal == null)
                return null;
            return nVal;
        }
    }
    class JsMinusFunction : JsFunction
    {
        JsVariant mOperand;
        public JsMinusFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_MINUS;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 2 || currIdx + 1 >= count)
                return false;

            mOperand = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);
            JsNumberValue nVal = mOperand.getNumberValue();
            if (nVal == null)
                return null;
            double d = nVal.getValue();
            return new JsNumberValue(d * -1);
        }
    }
    class JsAddFunction : JsFunction
    {
        JsVariant mLHS;
        JsVariant mRHS;

        public JsAddFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_ADD;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || currIdx + 1 >= count)
                return false;

            mLHS = insList[currIdx - 1];
            mRHS = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsVariant lhs = ctx.getParamValue(rootElement, mLHS);
            JsVariant rhs = ctx.getParamValue(rootElement, mRHS);


            if (lhs is JsNumberValue && rhs is JsNumberValue)
            {
                double d1 = ((JsNumberValue)lhs).getValue();
                double d2 = ((JsNumberValue)rhs).getValue();
                return new JsNumberValue(d1+d2);
            }

            JsStringValue sVal1 = lhs.getStringValue();
            JsStringValue sVal2 = rhs.getStringValue();
            if (sVal1 == null || sVal2 == null)
                return null;

            return new JsStringValue(sVal1.getValue() + sVal2.getValue());
        }
    }
    class JsSubFunction : JsFunction
    {
        JsVariant mLHS;
        JsVariant mRHS;

        public JsSubFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_SUB;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || currIdx + 1 >= count)
                return false;

            mLHS = insList[currIdx - 1];
            mRHS = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsVariant lhs = ctx.getParamValue(rootElement, mLHS);
            JsVariant rhs = ctx.getParamValue(rootElement, mRHS);

            if (lhs == null || rhs == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }

            JsNumberValue nVal1 = lhs.getNumberValue();
            JsNumberValue nVal2 = rhs.getNumberValue();

            if (nVal1 == null || nVal2 == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal1.IsNaN() || nVal2.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }



            double d1 = nVal1.getValue();
            double d2 = nVal2.getValue();
            
            return new JsNumberValue(d1 - d2);
        }
    }
    class JsMultipleFunction : JsFunction
    {
        JsVariant mLHS;
        JsVariant mRHS;
        public JsMultipleFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_MUL;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || currIdx + 1 >= count)
                return false;

            mLHS = insList[currIdx - 1];
            mRHS = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsVariant lhs = ctx.getParamValue(rootElement, mLHS);
            JsVariant rhs = ctx.getParamValue(rootElement, mRHS);

            if (lhs == null || rhs == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }

            JsNumberValue nVal1 = lhs.getNumberValue();
            JsNumberValue nVal2 = rhs.getNumberValue();

            if (nVal1 == null || nVal2 == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal1.IsNaN() || nVal2.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }



            double d1 = nVal1.getValue();
            double d2 = nVal2.getValue();

            return new JsNumberValue(d1 * d2);
        }
    }
    class JsDivideFunction : JsFunction
    {
        JsVariant mLHS;
        JsVariant mRHS;
        public JsDivideFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_DIV;
        }
        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || currIdx + 1 >= count)
                return false;

            mLHS = insList[currIdx - 1];
            mRHS = insList[currIdx + 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }
        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            base.Execute(ctx, rootElement);

            JsVariant lhs = ctx.getParamValue(rootElement, mLHS);
            JsVariant rhs = ctx.getParamValue(rootElement, mRHS);

            if (lhs == null || rhs == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }

            JsNumberValue nVal1 = lhs.getNumberValue();
            JsNumberValue nVal2 = rhs.getNumberValue();

            if (nVal1 == null || nVal2 == null)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER_TYPE;
                return null;
            }
            if (nVal1.IsNaN() || nVal2.IsNaN())
            {
                ctx.getDbgCtx().mErrorMessage = JsError.INVALID_NUMBER;
                return null;
            }



            double d1 = nVal1.getValue();
            double d2 = nVal2.getValue();
            if (d2 == 0)
            {
                ctx.getDbgCtx().mErrorMessage = JsError.DIVIDED_BY_ZERO;
                return null;
            }

            return new JsNumberValue(d1 / d2);
        }
    }
}
