﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    class JsLoadFunction : JsFunction
    {
        JsVariant mRetVal;
        JsVariant mLoadVal;

        public JsLoadFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_LOAD;
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            int count = insList.Count;
            if (count < 3 || count <= (currIdx + 1))
                return false;

            mLoadVal = insList[currIdx + 1];
            mRetVal = insList[currIdx - 1];
            insList.RemoveAt(currIdx + 1);
            insList.RemoveAt(currIdx - 1);
            mArranged = true;
            return true;
        }


        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            //if (ctx == null)
            //    ctx = new JsFunctionContext();
            DebugContext dCtx = ctx.getDbgCtx();
            base.Execute(ctx, rootElement);
            /*if (dCtx != null)
            {
                dCtx.mCurrentLine = mSourceLine;
                dCtx.mCurentIndex = mSourceIdx;
            }*/

            JsVariant loadVal = mLoadVal;
            JsFunction func = mLoadVal as JsFunction;
            if (func != null)
            {
                loadVal = func.Execute(ctx, rootElement);
                if (loadVal == null)
                    return null;
            }
            JsIdentifier idVal2 = loadVal as JsIdentifier;
            if (idVal2 != null)
            {
                loadVal = ctx.getValue(idVal2);
            }
            if(loadVal is JsFunction)
                return null;

            JsVariant retVal = mRetVal;
            func = retVal as JsFunction;
            if (func != null)
            {
                if (func.IsAssignable())
                {
                    return func.Execute(ctx, rootElement, loadVal); 
                }
                retVal = func.Execute(ctx, rootElement);
            }
            JsIdentifier idVal1 = retVal as JsIdentifier;
            if (idVal1 == null)
                return null;

            ctx.setValue(idVal1, loadVal);
            return idVal1;
        }
    }

    class JsLBracket : JsFunction
    {
        public JsLBracket(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }
        public override int getPriority()
        {
            return FUNC_PRIORITY_L_BRACKET;
        }

        //public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        //{
            //if (ctx == null)
            //    ctx = new JsFunctionContext();
        //    return null;
        //}
    }
    class JsRBracket : JsFunction
    {
        public List<JsVariant> mArgs = null;

        public JsRBracket(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            JsLBracket lBracket = null;
            int count = insList.Count;

            int i = currIdx - 1;
            for (; i >= 0; i--)
            {
                lBracket = insList[i] as JsLBracket;
                if (lBracket != null)
                    break;
            }
            if (lBracket == null)
                return false;
            
            mArgs= insList.GetRange(i + 1, currIdx - i - 1);
            insList.RemoveRange(i, currIdx - i);

            if (!JsFunction.rearangeInstructions(mArgs))
                return false;

            mArranged = true;
            return true;
        }

        public override int getPriority()
        {
            return FUNC_PRIORITY_R_BRACKET;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            if (mArgs == null || mArgs.Count != 1)
                return null;

            return ctx.getParamValue(rootElement, mArgs[0]);
        }
    }

    class JsCommaFunction : JsFunction
    {
        public List<JsVariant> mArgs = new List<JsVariant>();

        public JsCommaFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public List<JsVariant> getArgs()
        {
            return mArgs;
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            mArgs.Clear();

            int count = insList.Count;

            List<JsVariant> arg = new List<JsVariant>();
            int startIdx = 0;
            int endIdx = count;
            for (int i = 0; i < count; i++)
            {
                JsFunction func = insList[i] as JsFunction;
                if (func == null)
                    continue;
                if (func.IsArranged())
                    continue;
                if (i < currIdx)
                {
                    if (func.getPriority() > FUNC_PRIORITY_COMMA)
                        startIdx = i + 1;
                }
                else if (i > currIdx)
                {
                    if (func.getPriority() > FUNC_PRIORITY_COMMA)
                    {
                        endIdx = i - 1;
                    }
                }
            }

            for (int i = startIdx; i < endIdx; i++)
            {
                JsVariant var = insList[i];
                if (var is JsCommaFunction)
                {
                    if (arg.Count == 0)
                        return false;
                    if (!JsFunction.rearangeInstructions(arg))
                        return false;
                    if (arg.Count != 1)
                        return false;
                    mArgs.Add(arg[0]);
                    arg = new List<JsVariant>();
                }
                else
                {
                    arg.Add(var);
                }
            }
            if (arg.Count > 0)
            {
                if (!JsFunction.rearangeInstructions(arg))
                    return false;
                if (arg.Count != 1)
                    return false;
                mArgs.Add(arg[0]);
            }
            if (mArgs.Count < 2)
                return false;
            insList.Clear();
            insList.Add(this);
            mArranged = true;
            return true;
        }

        public override int getPriority()
        {
            return FUNC_PRIORITY_COMMA;
        }

        public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        {
            if (mArgs == null)
                return JsUndefValue.getConstant();
            foreach(JsVariant var in mArgs){
                JsFunction func = var as JsFunction;
                if (func == null)
                    continue;
                if(null == func.Execute(ctx, rootElement))
                    return null;;
            }
            return JsUndefValue.getConstant();
        }
    }
    class JsSemiColonFunction : JsFunction
    {
        public List<JsVariant> mArgs = new List<JsVariant>();

        public JsSemiColonFunction(int lineNo, int srcIdx)
            : base(lineNo, srcIdx)
        {
        }

        public List<JsVariant> getArgs()
        {
            return mArgs;
        }

        public override bool rearegeSquence(List<JsVariant> insList, int currIdx)
        {
            mArgs.Clear();

            int count = insList.Count;

            List<JsVariant> arg = new List<JsVariant>();

            for (int i = 0; i < count; i++)
            {
                JsVariant var = insList[i];
                if (var is JsSemiColonFunction)
                {
                    if (arg.Count > 0)
                    {
                        if (!JsFunction.rearangeInstructions(arg))
                            return false;
                        if (arg.Count != 1)
                            return false;
                        mArgs.Add(arg[0]);
                        arg = new List<JsVariant>();
                    }
                    else
                    {
                        mArgs.Add(new JsEmptyFunction(mSourceLine, mSourceIdx));
                    }
                }
                else
                {
                    arg.Add(var);
                }
            }
            if (arg.Count > 0)
            {
                if (!JsFunction.rearangeInstructions(arg))
                    return false;
                if (arg.Count != 1)
                    return false;
                mArgs.Add(arg[0]);
            }
            if (mArgs.Count < 2)
                return false;
            insList.Clear();
            insList.Add(this);
            mArranged = true;
            return true;
        }

        public override int getPriority()
        {
            return FUNC_PRIORITY_SEMICOLON;
        }

        //public override JsVariant Execute(JsFunctionContext ctx, HtmlElement rootElement)
        //{
        //if (mArgs == null || mArgs.Count != 1)
        //    return null;

        //return ctx.getParamValue(rootElement, mArgs[0]);
        // }
    }
}

