﻿using System;
using System.Collections.Generic;
using System.Text;

namespace NT2chCtrl.html.js
{
    public class JsDOMValue : JsVariant
    {
        List<HtmlElement> mThisElem;// = new List<HtmlElement>();

        public JsDOMValue()
        {
            mThisElem = new List<HtmlElement>();
        }
        public JsDOMValue(HtmlElement elem)
        {
            mThisElem = new List<HtmlElement>(1);
            mThisElem.Add(elem);
        }
        public JsDOMValue(List<HtmlElement> elems)
        {
            mThisElem = elems;
        }

        public override JsBooleanValue getBooleanValue()
        {
            return JsBooleanValue.getConstantValue(
                (mThisElem != null && mThisElem.Count > 0));
        }

        public override JsStringValue getStringValue()
        {
            string s;
            if (getInnerHTML(out s))
            {
                return new JsStringValue(s);
            }
            else
            {
                return JsStringValue.getEmpty();
            }
        }

        public bool setInnerHTML(string source)
        {
            DebugContext ctx = new DebugContext();
            foreach (HtmlElement elem in mThisElem)
            {
                elem.clearChildren();
                if(0 > HtmlParser.parseElement(ctx, elem, source, 0))
                    return false;

            }
            return true;
        }

        public bool getInnerHTML(out string htmlStr)
        {
            htmlStr = null;
            DebugContext ctx = new DebugContext();
            foreach (HtmlElement elem in mThisElem)
            {
                if(htmlStr == null)
                    htmlStr = elem.getInnerHtml();
                else
                    htmlStr += elem.getInnerHtml();
            }
            return true;
        }

    }
}
