﻿using System;
using System.Collections.Generic;
using System.Text;
using NT2chObject;

namespace NT2chCtrl.html
{
    public partial class HtmlElement
    {
        private bool parse2chRes(string source, IAmbiguousSearch search)
        {
            //int idx1 = 0;
            int idx2 = 0;
            int idx3, idx4;
            int length = source.Length;
            int textStart = 0;
            //StringElement sElem = null;
            HtmlElement hElem = null;

            //StringBuilder sb = new StringBuilder(source.Length);

            for (int idx1 = 0; idx1 < length; idx1++)
            {
                idx2 = source.IndexOf('<', idx1);
                if (idx2 < 0)
                    break;
                if (idx2 < length - 1)
                {

                    switch (source[idx2 + 1])
                    {
                        case 'a':
                        case 'A':
                            idx3 = source.IndexOf(" href=", idx2 + 2, StringComparison.OrdinalIgnoreCase);
                            if (idx3 == idx2 + 2)
                            {
                                idx4 = source.IndexOf(">", idx3 + 6, StringComparison.OrdinalIgnoreCase);
                                if (idx4 > 0)
                                {
                                    //sElem = new StringElement(this, source.Substring(textStart, idx2 - textStart));
                                    parse2chRes2(this, source, textStart, idx2, search);
                                    textStart = idx4 + 1;
                                    idx1 = textStart - 1;
                                }
                            }
                            break;
                        case 'b':
                        case 'B':
                            idx3 = source.IndexOf("r", idx2 + 2, StringComparison.OrdinalIgnoreCase);
                            if (idx3 == idx2 + 2)
                            {
                                idx4 = source.IndexOf(">", idx3 + 1, StringComparison.OrdinalIgnoreCase);
                                if (idx4 > 0)
                                {
                                    //sElem = new StringElement(this, source.Substring(textStart, idx2 - textStart));
                                    parse2chRes2(this, source, textStart, idx2, search);
                                    hElem = new HtmlElement(this, "br");
                                    hElem.setClosed(true);
                                    textStart = idx4 + 1;
                                    idx1 = textStart - 1;
                                }
                            }
                            break;
                        case '/':
                            idx3 = source.IndexOf("a>", idx2 + 2, StringComparison.OrdinalIgnoreCase);
                            if (idx3 == idx2 + 2)
                            {
                                    //sElem = new StringElement(this, source.Substring(textStart, idx2 - textStart));
                                    parse2chRes2(this, source, textStart, idx2, search);
                                    textStart = idx3 + 2;
                                    idx1 = textStart - 1;
                             }
                            break;
                        default:
                            break;
                    }
                }
                else
                {
                    break;
                }

            } //while (textStart < length);

            if (textStart < length)
            {
                //sElem = new StringElement(this, source.Substring(textStart, length - textStart));
                parse2chRes2(this, source, textStart, length, search);
            }
            return true;
        }

        private static int findNonDisplayAscii(string source, int start, int end)
        {
            int length = source.Length;
            length = Math.Min(length, end);
            for (int i = start; i < length; i++)
            {
                char c = source[i];
                if(c <= ' ' || c >= 0x7f){
                    return i;
                }
            }
            return length;
        }

        private bool parseEmphasisText(HtmlElement pElem, string source, int start, int end, IAmbiguousSearch search)
        {
            HtmlElement hElem;
            HtmlAttribute hAttr;
            StringElement sElem;

            int textLength = end - start;

            string text = source.Substring(start, textLength);

            if (search == null)
            {
                sElem = new StringElement(pElem, text);
                return true;
            }
            int idx = 0;
            int findIdx, endIdx;
            do{
                if (!search.match(text, idx, out findIdx, out endIdx))
                    break;
                if (idx < findIdx)
                {
                    sElem = new StringElement(pElem,
                                    text.Substring(idx, findIdx - idx));
                }
                hElem = new HtmlElement(pElem, "span");
                hAttr = new HtmlAttribute("emphasis");
                hElem.addAttribute(hAttr);
                sElem = new StringElement(hElem,
                                text.Substring(findIdx, endIdx - findIdx));
                hElem.setClosed(true);
                idx = endIdx;
            }while(idx < textLength);

            if (idx < textLength)
            {
                sElem = new StringElement(pElem,
                                text.Substring(idx, textLength - idx));
            }
            return true;
        }

        private bool parse2chRes2(HtmlElement pElem, string source, int start, int end, IAmbiguousSearch search)
        {
            bool bRet = false;
            int textStart = start;
            int textEnd = 0;
            int state = 0;
            int idx1, idx2;
            StringElement sElem;
            HtmlElement hElem;
            HtmlAttribute hAttr;
            string sLink;
            string prefix;

            for (int i = start; i < end; i++)
            {
                switch (source[i])
                {
                    case '>':
                    case '＞':
                        if (state == 0)
                        {
                            textEnd = i;
                            state = 1;
                        }
                        else if (state == 1)
                        {
                            textEnd = i - 1;
                        }
                        break;
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                    case '8':
                    case '9':
                        if (state == 1 || state == 2 || state == 3)
                            state = 2;
                        break;
                    case '-':
                    case ',':
                        if (state == 2)
                            state = 3;
                        else
                            state = 0;
                        break;
                    case 'h':
                    case 'H':
                    case 't':
                    case 'T':
                        if (state == 2 || state == 3)
                        {

                            //sElem = new StringElement(this,
                            //    source.Substring(textStart, textEnd - textStart));
                            parseEmphasisText(this, source, textStart, textEnd, search);
                            hElem = new HtmlElement(this, "span");
                            hAttr = new HtmlAttribute("res-link");
                            hElem.addAttribute(hAttr);
                            hElem.setClosed(true);
                            if (state == 3)
                                textStart = i - 2;
                            else if (state == 2)
                                textStart = i - 1;
                            sElem = new StringElement(hElem, source.Substring(textEnd, textStart - textEnd));
                        }
                        idx1 = source.IndexOf("ttp://", i, StringComparison.OrdinalIgnoreCase);
                        if (idx1 == i || idx1 == (i + 1))
                        {
                            if (idx1 == i)
                                prefix = "h";
                            else
                                prefix = string.Empty;
                            idx2 = findNonDisplayAscii(source, idx1 + 6, end);
                            sLink = source.Substring(i, idx2 - i);
                            if (chkGraphicLink(sLink))
                            {
                                hElem = new HtmlElement(this, "img");
                                hAttr = new HtmlAttribute("src", sLink);
                                hElem.addAttribute(hAttr);
                                hElem.setClosed(true);
                            }
                            hElem = new HtmlElement(this, "a");
                            hAttr = new HtmlAttribute("href", prefix+sLink);
                            hElem.addAttribute(hAttr);
                            hElem.setClosed(true);
                            sElem = new StringElement(hElem, sLink);
                            textStart = idx2;
                            i = idx2 - 1;
                        }
                        else
                        {
                            idx1 = source.IndexOf("ttps://", i, StringComparison.OrdinalIgnoreCase);
                            if (idx1 == i || idx1 == (i + 1))
                            {
                                if (idx1 == i)
                                    prefix = "h";
                                else
                                    prefix = string.Empty;
                                idx2 = findNonDisplayAscii(source, idx1 + 7, end);
                                sLink = source.Substring(i, idx2 - i);
                                if (chkGraphicLink(sLink))
                                {
                                    hElem = new HtmlElement(this, "img");
                                    hAttr = new HtmlAttribute("src", sLink);
                                    hElem.addAttribute(hAttr);
                                    hElem.setClosed(true);
                                }
                                hElem = new HtmlElement(this, "a");
                                hAttr = new HtmlAttribute("href", prefix+sLink);
                                hElem.addAttribute(hAttr);
                                hElem.setClosed(true);
                                sElem = new StringElement(hElem, sLink);
                                textStart = idx2;
                                i = idx2 - 1;
                            }
                            else
                            {
                            }
                        }
                        state = 0;
                        break;
                    case 's':
                        if (state == 2 || state == 3)
                        {

                            //sElem = new StringElement(this,
                            //    source.Substring(textStart, textEnd - textStart));
                            parseEmphasisText(this, source, textStart, textEnd, search);
                            hElem = new HtmlElement(this, "span");
                            hAttr = new HtmlAttribute("res-link");
                            hElem.addAttribute(hAttr);
                            hElem.setClosed(true);
                            if (state == 3)
                                textStart = i - 2;
                            else if (state == 2)
                                textStart = i - 1;
                            sElem = new StringElement(hElem, source.Substring(textEnd, textStart - textEnd));
                            state = 0;
                        }
                        idx1 = source.IndexOf("sssp://", i, StringComparison.OrdinalIgnoreCase);
                        if (idx1 == i || idx1 == (i + 1))
                        {
                            idx2 = findNonDisplayAscii(source, idx1 + 7, end);
                            sLink = "http" + source.Substring(i+4, idx2 - i - 4);
                            if (chkGraphicLink(sLink))
                            {
                                hElem = new HtmlElement(this, "img");
                                hAttr = new HtmlAttribute("src", sLink);
                                hElem.addAttribute(hAttr);
                                hAttr = new HtmlAttribute("sssp");
                                hElem.addAttribute(hAttr);
                                hElem.setClosed(true);
                                textStart = idx2;
                                i = idx2 - 1;
                            }
                        }
                        break;
                    default:
                        if (state == 2 || state == 3)
                        {
                            //sElem = new StringElement(this,
                            //    source.Substring(textStart, textEnd - textStart));
                            parseEmphasisText(this, source, textStart, textEnd, search);
                            hElem = new HtmlElement(this, "span");
                            hAttr = new HtmlAttribute("res-link");
                            hElem.addAttribute(hAttr);
                            hElem.setClosed(true);
                            if (state == 3)
                                textStart = i - 2;
                            else if (state == 2)
                                textStart = i - 1;
                            sElem = new StringElement(hElem, source.Substring(textEnd, textStart - textEnd));
                            state = 0;
                        }
                        break;
                }
            }
            if (textStart < end)
            {
                if (state == 2 || state == 3)
                {
                    //sElem = new StringElement(this,
                    //    source.Substring(textStart, textEnd - textStart));
                    parseEmphasisText(this, source, textStart, textEnd, search);
                    hElem = new HtmlElement(this, "span");
                    hAttr = new HtmlAttribute("res-link");
                    hElem.addAttribute(hAttr);
                    hElem.setClosed(true);
                    if (state == 3)
                        textStart = end - 1;
                    else if (state == 2)
                        textStart = end;
                    sElem = new StringElement(hElem, source.Substring(textEnd, textStart - textEnd));
                    if (state == 3)
                    {
                        sElem = new StringElement(this, source.Substring(end -1, 1));
                    }
                }
                else
                {
                    //sElem = new StringElement(this, source.Substring(textStart, end - textStart));
                    parseEmphasisText(this, source, textStart, end, search);
                }
            }
            return bRet;
        }

        bool chkGraphicLink(string src)
        {
            //if (!chkShowThumbnail())
            //    return false;

            if (src == null || src.Length < 4)
                return false;
            int idx = src.LastIndexOf('.');
            if (idx < 0)
                return false;

            string suffix = src.Substring(idx + 1).ToLower();
            switch (suffix)
            {
                case "png":
                case "jpg":
                case "jpeg":
                case "bmp":
                case "gif":
                    return true;
                default:
                    return false;
            }
        }

        private bool parse2chRes_old(string source)
        {

            if (source == null || source.Length == 0)
                return false;

            int textStart = 0;
            int state = 0;
            string tagName, attrName=null, attrVal;
            StringElement sElem;
            HtmlAttribute hAttr;
            HtmlElement hElem = null;
            bool dquote = false;
            bool squote = false;


            int length = source.Length;
            for (int i = 0; i < length; i++)
            {
                switch (HtmlParser.getCharToken(source[i]))
                {
                    case  HtmlParser.CHAR_TOKEN.LT:
                        if (state == 0 && textStart < i)
                        {
                            sElem = new StringElement(
                                this, source.Substring(textStart, i - textStart));
                        }
                        state = 1;
                        textStart = length;
                        break;
                    case HtmlParser.CHAR_TOKEN.SLASH:
                        if (state == 0)
                            break;
                        else if (state == 6 && (dquote || squote))
                        {
                            break;
                        }
                        else if (state == 1)
                        {
                            state = 8;
                        }
                        else
                        {                            
                            state = 7;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.GT:
                        if (state == 0){
                            break;
                        }if (state == 1 || state == 8){
                            return false;
                        }
                        else if (state == 2)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                            hElem = new HtmlElement(this, tagName);
                        }
                        else if (state == 7)
                        {
                            hElem.setClosed(true);
                        }
                        else if (state == 9)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                            int count = mChildren.Count;
                            for (int j = count - 1; j >= 0; j--)
                            {
                                HtmlElement child = mChildren[j];
                                if (child.Closed())
                                    continue;

                                if (tagName.Equals(child.getTagName()))
                                {
                                    child.setClosed(true);
                                    if (j < (count-1))
                                    {
                                        child.mChildren.AddRange(
                                            mChildren.GetRange(j+1, count - 1 - j));
                                        mChildren.RemoveRange(j+1, count - 1 - j);
                                    }
                                    break;
                                }
                            }
                        }
                        hElem = null;
                        state = 0;
                        textStart = i + 1;
                        break;
                    case  HtmlParser.CHAR_TOKEN.WHITESPACE:
                    case  HtmlParser.CHAR_TOKEN.NL:
                        if (state == 1)
                            return false;
                        else if (state == 2)
                        {
                            tagName = source.Substring(textStart, i - textStart);
                            hElem = new HtmlElement(this, tagName);
                            state = 3;
                        }
                        else if (state == 4)
                        {
                            attrName = source.Substring(textStart, i - textStart);
                            state = 5;
                        }
                        else if (state == 5)
                        {
                            hAttr = new HtmlAttribute(attrName);
                            hElem.addAttribute(hAttr);
                            state = 3;
                            dquote = squote = false;
                        }
                        else if (state == 6)
                        {
                            attrVal = source.Substring(textStart, i - textStart);
                            hAttr = new HtmlAttribute(attrName, attrVal);
                            hElem.addAttribute(hAttr);
                            state = 3;
                            dquote = squote = false;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.EQUAL:
                        if (state != 0 && state != 4 && state != 5)
                            return false;
                        if (state == 0)
                            break;
                        if (state == 4)
                        {
                            attrName = source.Substring(textStart, i - textStart);
                        }
                        textStart = i + 1;
                        state = 6;
                        break;
                    case HtmlParser.CHAR_TOKEN.DQUOTE:
                        if (state == 0)
                            break;
                        if(state != 6)
                            return false;
                        if (squote)
                            break;
                        if (dquote)
                        {
                            attrVal = source.Substring(textStart, i - textStart);
                            hAttr = new HtmlAttribute(attrName, attrVal);
                            hElem.addAttribute(hAttr);
                            state = 3;
                            dquote = false;
                        }
                        else
                        {
                            dquote = true;
                            textStart = i + 1;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.SQUOTE:
                        if (state == 0)
                            break;
                        if(state != 6)
                            return false;
                        if (dquote)
                            break;
                        if (squote)
                        {
                            attrVal = source.Substring(textStart, i - textStart);
                            hAttr = new HtmlAttribute(attrName, attrVal);
                            hElem.addAttribute(hAttr);
                            state = 3;
                            squote = false;
                        }
                        else
                        {
                            squote = true;
                            textStart = i + 1;
                        }
                        break;
                    case HtmlParser.CHAR_TOKEN.ALPHA:
                        if(state == 0)
                            break;
                        else if (state == 1)
                        {
                            state = 2;
                            textStart = i;
                        }
                        else if (state == 3)
                        {
                            textStart = i;
                            state = 4;
                        }
                        else if (state == 8)
                        {
                            textStart = i;
                            state = 9;
                        }
                        else if(state == 7)
                        {
                            return false;
                        }
                        break;
                    default:
                        if(state == 7)
                        {
                            return false;
                        }
                        break;
                }
            }
            if (state == 0 && textStart < length)
            {
                sElem = new StringElement(
                    this, source.Substring(textStart, length - textStart));
            }
            return false;
        }
    }
}
