﻿using NT2chObject;
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace NT2chCtrl2
{
    class MenuItemPopup : Popup
    {
 
        IBoard mBoard;
        ICommand2 mCommand;

        public MenuItemPopup(IBoard iboard, ICommand2 command, ICloseTab closeTab)
            : base()
        {
            mBoard = iboard;
            mCommand = command;
            mCloseTab = closeTab;

            StackPanel sp = new StackPanel();
            sp.Orientation = Orientation.Horizontal;


            StackPanel panel = new StackPanel();
            Border border = new Border();
            border.BorderThickness = new System.Windows.Thickness(1);
            border.BorderBrush = new SolidColorBrush(Colors.DarkGray);


            ListBoxItem item1 = new ListBoxItem();

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run(mBoard.getName())));
            item1.Content = sp;
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new Separator());
            item1 = new ListBoxItem();
            item1.BorderBrush = new SolidColorBrush(Colors.LightGray);
            item1.BorderThickness = new System.Windows.Thickness(1);
            item1.Height = 1;
            item1.Content = sp;
            panel.Children.Add(item1);
            panel.Background = new SolidColorBrush(Colors.White);


            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("お気に入りに追加")));
            sp.MouseLeftButtonDown += itemAddFavorite_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("板のログを全て削除")));
            sp.MouseLeftButtonDown += itemDeleteLog_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("このタブ以外を閉じる")));
            sp.MouseLeftButtonDown += CloseAllTabExceptThis_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("左側のタブを閉じる")));
            sp.MouseLeftButtonDown += CloseTabOnTheLeft_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("右側のタブを閉じる")));
            sp.MouseLeftButtonDown += CloseTabOnTheRight_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("全てのタブを閉じる")));
            sp.MouseLeftButtonDown += CloseAllTab_MouseLeftButtonDown;
            sp.Tag = mBoard.getName();
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);

            sp = new StackPanel();
            sp.Children.Add(new TextBlock(new Run("閉じる")));
            sp.MouseLeftButtonDown += itemClose_MouseLeftButtonDown;
            item1 = new ListBoxItem();
            item1.Padding = new System.Windows.Thickness(10, 2, 10, 2);
            item1.Content = sp;
            panel.Children.Add(item1);
            border.Child = panel;
            this.Child = border;

        }


        public void show()
        {
            IsOpen = true;
            Placement = PlacementMode.Mouse;
            Focus();
            this.StaysOpen = false;
      
        }
        void itemAddFavorite_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            mCommand.AddBoardToFavorite(mBoard);

        }
        void itemDeleteLog_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;

            mCommand.DeleteLog(mBoard);

        }

        ICloseTab mCloseTab;
        public interface ICloseTab
        {
            void CloseAllExceptThis(IBoard iboard);
            void CloseOnTheLeft(IBoard iboard);
            void CloseOnTheRight(IBoard iboard);
            void CloseAll();
        }

        void CloseAllTabExceptThis_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
            mCloseTab.CloseAllExceptThis(mBoard);
        }
        void CloseTabOnTheLeft_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
            mCloseTab.CloseOnTheLeft(mBoard);

        }
        void CloseTabOnTheRight_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
            mCloseTab.CloseOnTheRight(mBoard);
        }
        void CloseAllTab_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
            mCloseTab.CloseAll();
        }


        void itemClose_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            IsOpen = false;
        }
    }
}
