﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Media;

namespace NT2chView
{
    static class NTFontUtil
    {
        static FontFamily mResFont;
        static FontFamily mAAFont;

        static NTFontUtil()
        {

        }

        public static void clear()
        {
            mResFont = null;
            mAAFont = null;
        }

        public static FontFamily getResFont()
        {
            if (!NTUserPreference.UseResFontTypeface)
                return null;

            if (mResFont == null)
            {
                string fontName = NTUserPreference.ResFontTypeface;
                if (fontName != null && fontName.Length > 0)
                    mResFont = new FontFamily(fontName);

            }
            return mResFont;
        }
        public static FontFamily getAAFont()
        {
            if (!NTUserPreference.UseAAFontTypeface)
                return null;

            if (mAAFont == null)
            {
                string fontName = NTUserPreference.AAFontTypeface;
                if (fontName != null && fontName.Length > 0)
                    mAAFont = new FontFamily(fontName);

            }
            return mAAFont;
        }
    
    }
}
