﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Diagnostics;
using NT2chView.NtNet;
using System.ComponentModel;
using NT2chView.NtFile;

namespace NT2chView
{
    /// <summary>
    /// NTSetupWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class NTSetupWindow : Window
    {
        private string mExternalBoardSubject = null;
        private string mExternalBoardUrl = null;

        public NTSetupWindow()
        {
            InitializeComponent();
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.DialogResult = false;
            Close();
        }

        private void btnOK_Click(object sender, RoutedEventArgs e)
        {
            string p2id = txtP2ID.Text;
            string p2pss = txtP2Pass.Text;
            string maru_id = txtMaruID.Text;
            string maru_pss = txtMaruPass.Text;
            string ntcloud_id = txtNTID.Text;
            string ntcloud_pss = txtNTPass.Text;
            string ntcloud_url = txtUserServerUrl.Text;

            NTUserPreference.P2ID = (null != p2id) ? p2id : string.Empty;
            NTUserPreference.P2PSS = (null != p2pss) ? p2pss : string.Empty;
            NTUserPreference.MaruID = (null != maru_id) ? maru_id : string.Empty;
            NTUserPreference.MaruPSS = (null != maru_pss) ? maru_pss : string.Empty;
            NTUserPreference.NTCloudID = (null != ntcloud_id) ? ntcloud_id : string.Empty;
            NTUserPreference.NTCloudPSS = (null != ntcloud_pss) ? ntcloud_pss : string.Empty;
            NTUserPreference.NTUserCloudUrl = (null != ntcloud_url) ? ntcloud_url : string.Empty;
            if (rdoShowCloudReadOnly.IsChecked.HasValue)
                NTUserPreference.NTShowOnlyCloudReadCount = (bool)rdoShowCloudReadOnly.IsChecked;

            if (chkUseResFont.IsChecked.HasValue)
                NTUserPreference.UseResFontTypeface = (bool)chkUseResFont.IsChecked;
            else
                NTUserPreference.UseResFontTypeface = false;

            if (chkUseAAFont.IsChecked.HasValue)
                NTUserPreference.UseAAFontTypeface = (bool)chkUseAAFont.IsChecked;
            else
                NTUserPreference.UseAAFontTypeface = false;
            string fontName = edtFontRes.Text as string;
            NTUserPreference.ResFontTypeface = (null != fontName) ? fontName : string.Empty;
            fontName = edtFontAA.Text as string;
            NTUserPreference.AAFontTypeface = (null != fontName) ? fontName : string.Empty;


            string aaText = edtAATextData.Text.Replace("\r\n", "\n");
            NTUserPreference.AAData = NTTextUtiles.splitLine(aaText);

            NTUserPreference.ThreadtitleListViewFontSize = mThreadFontSizeValue;

            NTUserPreference.FavoriteUpdateDuration = FavoriteUpdateDuration;


            if (mChkEnablePopupMouseHover.IsChecked.HasValue)
                NTUserPreference.EnablePopupMouseHover = (bool)mChkEnablePopupMouseHover.IsChecked;
            else
                NTUserPreference.EnablePopupMouseHover = false;

            if (mChkOpenYoutubeLinkOnApp.IsChecked.HasValue)
                NTUserPreference.OpenYoutubeOnApp = (bool)mChkOpenYoutubeLinkOnApp.IsChecked;
            else
                NTUserPreference.OpenYoutubeOnApp = false;

            NTUserPreference.ResViewThumbnailConnectionCount = NumValue;

            NTUserPreference.savePreferences();

            this.DialogResult = true;
            Close();

        }

        private void windowNTSetup_Loaded(object sender, RoutedEventArgs e)
        {
            string p2id = NTUserPreference.P2ID;
            string p2pass = NTUserPreference.P2PSS;
            string maru_id = NTUserPreference.MaruID;
            string maru_pass = NTUserPreference.MaruPSS;
            string ntcloud_id = NTUserPreference.NTCloudID;
            string ntcloud_pass = NTUserPreference.NTCloudPSS;
            string nt_user_server_url = NTUserPreference.NTUserCloudUrl;
            bool bCloudEnable = NTUserPreference.NTCloudIsEnabled;
            bool useResFont = NTUserPreference.UseResFontTypeface;
            bool useAAFont = NTUserPreference.UseAAFontTypeface;


            txtP2ID.Text = (null != p2id) ? p2id : string.Empty;
            txtP2Pass.Text = (null != p2pass) ? p2pass : string.Empty;
            txtMaruID.Text = (null != maru_id) ? maru_id : string.Empty;
            txtMaruPass.Text = (null != maru_pass) ? maru_pass : string.Empty;
            txtNTID.Text = (null != ntcloud_id) ? ntcloud_id : string.Empty;
            txtNTPass.Text = (null != ntcloud_pass) ? ntcloud_pass : string.Empty;
            txtUserServerUrl.Text = (null != nt_user_server_url) ? nt_user_server_url : string.Empty;


            mChkDebugOption.IsChecked = NTUserPreference.DebugOption;
            chkNTCloudEnable.IsChecked = NTUserPreference.NTCloudIsEnabled;
            chkUseMaru.IsChecked = NTUserPreference.MaruIsEnabled;

            chkUserCloudEnable.IsChecked = NTUserPreference.NTUserCloudIsEnabled;

            System.Diagnostics.FileVersionInfo ver =
                System.Diagnostics.FileVersionInfo.GetVersionInfo(
                System.Reflection.Assembly.GetExecutingAssembly().Location);

            lblVersionInfo.Content = ver;

            chkUseResFont.IsChecked = NTUserPreference.UseResFontTypeface;
            chkUseAAFont.IsChecked = NTUserPreference.UseAAFontTypeface;

            string resFontName = NTUserPreference.ResFontTypeface;
            edtFontRes.Text = resFontName;
            string aaFontName = NTUserPreference.AAFontTypeface;
            edtFontAA.Text = aaFontName;

            edtAATextData.Text = NTTextUtiles.concatLines(NTUserPreference.AAData);

            mThreadFontSizeValue = (int)NTUserPreference.ThreadtitleListViewFontSize;

            mChkEnablePopupMouseHover.IsChecked = NTUserPreference.EnablePopupMouseHover;

            mChkOpenYoutubeLinkOnApp.IsChecked = NTUserPreference.OpenYoutubeOnApp;

            NumValue = NTUserPreference.ResViewThumbnailConnectionCount;

            FavoriteUpdateDuration = NTUserPreference.FavoriteUpdateDuration;

        }

        private void chkDebugOption_Checked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.DebugOption = true;
        }

        private void chkDebugOption_Unchecked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.DebugOption = false;
        }
        private void chkNTCloudEnable_Checked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.NTCloudIsEnabled = true;
        }

        private void chkNTCloudEnable_Unchecked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.NTCloudIsEnabled = false;
        }
        private void chkUserCloudEnable_Checked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.NTUserCloudIsEnabled = true;
        }

        private void chkUserCloudEnable_Unchecked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.NTUserCloudIsEnabled = false;
        }

        /*private enum BGWORKSTATUS
        {
            OK,
            FAIL
        }*/
        //private BGWORKSTATUS mBgStatus = BGWORKSTATUS.FAIL;
 

        private void bgCloudChk_DoWork(object sender, System.ComponentModel.DoWorkEventArgs e)
        {

            
            string result = string.Empty;

            string[] para = e.Argument as string[];

            if(para == null || para.Length < 2)
                return;
            if (mSetUserCloud)
                result = NTHttpAccess.UserCloudCheckUser(para[2], para[0], para[1]);
            else if (para.Length == 2)
                result = NTHttpAccess.ntCheckUser(para[0], para[1]);
            e.Result = result;
        }

        private void bgCloudChk_ProgressChanged(object sender, System.ComponentModel.ProgressChangedEventArgs e)
        {

        }

        private void bgCloudChk_RunWorkerCompleted(object sender, System.ComponentModel.RunWorkerCompletedEventArgs e)
        {

            string result = e.Result as string;
            if (result == null)
                return;

            string [] lines = NTTextUtiles.splitLine(result);
            if (0 >= lines.Length)
                return;

            int status = 0;
            try
            {
                status = int.Parse(lines[0]);
            }
            catch
            {
                return;
            }
            switch (status)
            {
                case 100:
                    if (mSetUserCloud)
                    {
                        if (lines.Length >= 5)
                        {
                            txtNTStatus.Text = lines[0] + "\n" + lines[1];
                            NTUserPreference.NTCloudPSS = txtNTPass.Text;
                            NTUserPreference.NTCloudID = txtNTID.Text;
                            NTUserPreference.NTUserCloudScriptUrl = lines[2];
                            NTUserPreference.NTUserCloudFileUrl = lines[3];
                            NTUserPreference.NTUserCloudSeed = lines[4];
                            NTUserPreference.savePreferences();
                        }
                    }
                    else
                    {
                        if (lines.Length >= 3)
                        {
                            string srvUrl = lines[2];
                            txtNTStatus.Text = lines[0] + "\n" + lines[1];
                            NTUserPreference.NTCloudUrl = srvUrl;
                            NTUserPreference.NTCloudPSS = txtNTPass.Text;
                            NTUserPreference.NTCloudID = txtNTID.Text;
                            NTUserPreference.savePreferences();
                        }
                    }
                    NTFileAccess.deleteCloudLastModified();
                    break;
                default:
                    if(lines.Length >= 2)
                    {
                        txtNTStatus.Text = lines[0] +"\n" + lines[1];
                    }
                    break;
            }
        


        }

        private void btnNTCloudSetupAes_Click(object sender , RoutedEventArgs e)
        {
            NTSetupAESWindow window = new NTSetupAESWindow();
            window.AESEnable = NTUserPreference.AESEnabled;
            window.AESPass = NTUserPreference.AESPass;
            window.ShowDialog();
            if (window.Save)
            {
                NTUserPreference.AESEnabled = window.AESEnable;
                NTUserPreference.AESPass = window.AESPass;
                NTUserPreference.savePreferences();
            }
        }

        bool mSetUserCloud;
        private void btnNTCloudCheckUser_Click(object sender, RoutedEventArgs e)
        {
            string ntcloud_id = txtNTID.Text;
            string ntcloud_pss = txtNTPass.Text;
            string nt_user_server_url = txtUserServerUrl.Text;
            if (ntcloud_id.Length == 0)
            {
                MessageBox.Show("ユーザーＩＤが指定されていません。");
                return;
            }
            if (ntcloud_pss.Length == 0)
            {
                MessageBox.Show("パスワードが指定されていません。");
                return;
            }
            string[] para;
            bool? userCloud = chkUserCloudEnable.IsChecked;
            if (userCloud.HasValue && (bool)userCloud)
            {
                para = new string[3];
                para[0] = ntcloud_id;
                para[1] = ntcloud_pss;
                para[2] = nt_user_server_url;
                mSetUserCloud = true;
            }
            else
            {
                para = new string[2];
                para[0] = ntcloud_id;
                para[1] = ntcloud_pss;
                mSetUserCloud = false;
            }
            BackgroundWorker worker;
            worker = ((BackgroundWorker)this.FindResource("bgCloudChkWorker"));
            worker.RunWorkerAsync(para);

        }

        private void tabItemMaru_Loaded(object sender, RoutedEventArgs e)
        {
        }

        private void tabItem3_Loaded(object sender, RoutedEventArgs e)
        {
            if (NTUserPreference.NTShowOnlyCloudReadCount)
                rdoShowCloudReadOnly.IsChecked = true;
            else
                rdoShowAllReadLog.IsChecked = true;
        }

        string chkUrl(string source)
        {
            int len = source.Trim().Length;
            if(len == 0)
                return source;
            if ('/' != source[len - 1])
                return source + '/';
            else
                return source; 
        }

        private void btnExternalBoardConfirm_Click(object sender, RoutedEventArgs e)
        {
            string url = txtBoardUrl.Text;
            if (confirmExternalBoard(url))
            {
                MessageBox.Show("掲示板を確認しました。");
                btnExternalBoardRegister.IsEnabled = true;
            }
            else
            {
                MessageBox.Show("有効なURLではありません。");
                btnExternalBoardRegister.IsEnabled = false;

            }
 
        }

 
        private void btnExternalBoardRegister_Click(object sender, RoutedEventArgs e)
        {
            string boardName = txtBoardName.Text.Trim();
            if (boardName.Length == 0)
            {
                MessageBox.Show("板に名前を指定して下さい。");
                return;
            }
            int boardNameLen = boardName.Length*2;//regard ucs2
            boardNameLen = ((boardNameLen / 16) * 16) + (((boardNameLen % 16) > 0) ? 16 : 0);//for aes encrypt
            boardNameLen = ((boardNameLen * 133) / 100) + 3;//for base64
            boardNameLen += 10;//for url encode

            if (boardNameLen > 60)
            {
                MessageBox.Show(
                    string.Format("名前が長すぎます。limit 60, length {0}", boardNameLen));
                return;
            }
            if (mExternalBoardSubject == null ||
                mExternalBoardUrl == null)
            {
                string url = chkUrl(txtBoardUrl.Text);
                if (!confirmExternalBoard(url))
                {
                    MessageBox.Show("有効なURLではありません。");
                    btnExternalBoardRegister.IsEnabled = false;
                    return;
                }

            }
            txtBoardName.Text = string.Empty;
            txtBoardUrl.Text = string.Empty;
            string description = mExternalBoardUrl + "<>" + boardName;
            NTFileAccess.appendExternalBoard(description);
            NTCategory category = NTDataRoot.getExternalBoards();
            List<string> list = new List<string>();
            NTBoard newBoard = new NTBoard(boardName, mExternalBoardUrl);
            category.mBoardList.Add(newBoard);
            NTAppState.getMainWindow().appendBoardToExternalCategoryTree(newBoard);
            ListBoxItem subitem = new ListBoxItem();
            subitem.Content = boardName;
            lstExternalBoardList.Items.Add(subitem);

            if (NTUserPreference.NTCloudIsEnabled)
            {
                BackgroundWorker worker;
                worker = ((BackgroundWorker)this.FindResource("bgUploadExBoardWorker"));
                worker.RunWorkerAsync(description);
            }


        }

        private void bgUploadExBoard_DoWork(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            string description = e.Argument as string;
            if (description == null)
                return;

            string result;
            if (NTUserPreference.NTUserCloudIsEnabled)
            {
                result = NTHttpAccess.UserCloudUploadExternalBoards(description);
            }
            else
            {
                result = NTHttpAccess.ntUploadExternalBoards(description);
            }
            NTDebug.l(result);


        }



        private bool confirmExternalBoard(string url)
        {
            bool bRet = false;
            try
            {
                if (url.Length == 0)
                    throw new Exception();
                

                int idx = url.IndexOf("http://", StringComparison.CurrentCultureIgnoreCase);
                if (0 > idx)
                    throw new Exception();

                idx = NTHttpUtils.parseWebHost(url, idx + "http://".Length);
                if (idx < 0)
                    throw new Exception();

                url = chkUrl(url);
               
                string result = NTHttpAccess.getExternalBoardSubject(url, null);

                if(result == null)
                    throw new Exception();

                NTDebug.l(result);

                mExternalBoardSubject = result;
                mExternalBoardUrl = url;
                bRet = true;

            }
            catch
            {
                mExternalBoardSubject = null;
                mExternalBoardUrl = null;
            }
            return bRet;
       }

        private void tabItemManipulate_Loaded(object sender, RoutedEventArgs e)
        {

        }
        private void tabItemNetwork_Loaded(object sender, RoutedEventArgs e)
        {

        }

        private int _threadFontSizeValue = 0;
        public int mThreadFontSizeValue
        {
            get { return _threadFontSizeValue; }
            set
            {
                _threadFontSizeValue = value;
                if (_threadFontSizeValue < 1)
                    _threadFontSizeValue = 1;
                else if (_threadFontSizeValue > 36)
                    _threadFontSizeValue = 36;
                mEdtThreadFontSize.Text = value.ToString();
            }
        }

        private void mBtnThreadFontSizeUp_Click(object sender, RoutedEventArgs e)
        {
            mThreadFontSizeValue++;
        }
        private void mBtnThreadFontSizeDown_Click(object sender, RoutedEventArgs e)
        {
            mThreadFontSizeValue--;
        }
        private void mEdtThreadFontSize_TextChanged(object sender,
            TextChangedEventArgs e)
        {
            if (!int.TryParse(mEdtThreadFontSize.Text, out _threadFontSizeValue))
                mEdtThreadFontSize.Text = _threadFontSizeValue.ToString();
        }
        private void mEdtUpdateInterval_TextChanged(object sender,
            TextChangedEventArgs e)
        {
            if (!int.TryParse(mEdtUpdateInterval.Text, out _favoriteUpdateDuration))
                mEdtThreadFontSize.Text = _favoriteUpdateDuration.ToString();
            else
            {
                if (_favoriteUpdateDuration < 0 || _favoriteUpdateDuration > 60)
                    mEdtThreadFontSize.Text = _favoriteUpdateDuration.ToString();
            }
        }

        private int _favoriteUpdateDuration =
            NTUserPreference.DEFAULT_FAVORITE_UPDATE_DURATION;
        public int FavoriteUpdateDuration
        {
            get { return _favoriteUpdateDuration; }
            set
            {
                if (value < 0 || value > 60)
                    _favoriteUpdateDuration =
                    NTUserPreference.DEFAULT_FAVORITE_UPDATE_DURATION;
                else
                    _favoriteUpdateDuration = value;
                mEdtUpdateInterval.Text = _favoriteUpdateDuration.ToString();
            }
        }

        private int _numValue = 0;
        public int NumValue
        {
            get { return _numValue; }
            set
            {
                _numValue = value;
                if (_numValue < 1)
                    _numValue = 1;
                else if (_numValue > 20)
                    _numValue = 20;
                mEdtThreadNum.Text = value.ToString();
            }
        }

        private void mBtnThreadNumUp_Click(object sender, RoutedEventArgs e)
        {
            NumValue++;
        }
        private void mBtnThreadNumDown_Click(object sender, RoutedEventArgs e)
        {
            NumValue--;
        }

        private void mEdtThreadNum_TextChanged(object sender,
            TextChangedEventArgs e)
        {
            if (!int.TryParse(mEdtThreadNum.Text, out _numValue))
                mEdtThreadNum.Text = _numValue.ToString();
        }

        private void tabItemExternalBoard_Loaded(object sender, RoutedEventArgs e)
        {
            string[] lines = NTFileAccess.retrieveExternalBoards();
            if (lines != null)
            {
                foreach(string line in lines){
                    int idx = line.IndexOf("<>");
                    if (idx < 0)
                        continue;
                    ListBoxItem item = new ListBoxItem();
                    item.Content = line.Substring(idx + 2);
                    lstExternalBoardList.Items.Add(item);
                }
            }
            btnExternalBoardRegister.IsEnabled = false;
        }

        private void btnExternalBoardRemove_Click(object sender, RoutedEventArgs e)
        {
            ListBoxItem item = lstExternalBoardList.SelectedItem as ListBoxItem;
            if (item == null)
                return;

            string s = item.Content as string;
            if (s == null)
                return;

            lstExternalBoardList.Items.Remove(item);

            NTCategory category = NTDataRoot.getExternalBoards();
            List<string> list = new List<string>();
            NTBoard removeBoard = null;
            int len = category.mBoardList.Count;
            for(int i = 0; i < len; i++)
            {
                NTBoard board = category.mBoardList[i] as NTBoard;
                if (board == null)
                    continue;
                if (board.mName.Equals(s))
                {
                    removeBoard = board;
                    //category.mBoardList.Remove(board);
                }
                else
                {
                    list.Add(board.mAddress + "<>" + board.mName);
                }
            }
            if (removeBoard != null)
            {
                category.mBoardList.Remove(removeBoard);
                if(NTUserPreference.NTCloudIsEnabled){
                    if (NTUserPreference.NTUserCloudIsEnabled)
                    {
                        NTHttpAccess.UserCloudDeleteExternalBoards(
                            removeBoard.mAddress + "<>" + removeBoard.mName);
                    }
                    else
                    {
                        NTHttpAccess.ntDeleteExternalBoards(
                            removeBoard.mAddress + "<>" + removeBoard.mName);
                    }
                }
            }
            NTAppState.getMainWindow().removeBoardFromExternalCategoryTree(s);
            NTFileAccess.writeExternalBoards(list.ToArray());
        }

        private void NTSetupWindow_hlink_OnClick(object sender, RoutedEventArgs e)
        {
            Hyperlink hl = sender as Hyperlink;
            if (hl == null)
                return;

            Uri uri = hl.NavigateUri;
            if (uri == null)
                return;

            Process.Start(uri.ToString());

        }

        private void chkUseMaru_Checked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.MaruIsEnabled = true;
        }

        private void chkUseMaru_Unchecked(object sender, RoutedEventArgs e)
        {
            NTUserPreference.MaruIsEnabled = false;
        }

        private void btnFontRes_Click(object sender, RoutedEventArgs e)
        {
            NTFontSelectDialog dlg = new NTFontSelectDialog();
            if (NTUserPreference.UseResFontTypeface)
                dlg.FontName = NTUserPreference.ResFontTypeface;// "IPAMonaPGothic";
            bool? result = dlg.ShowDialog();
            if(result.HasValue && (bool)result)
                edtFontRes.Text = dlg.FontName;

        }
        private void btnFontAA_Click(object sender, RoutedEventArgs e)
        {
            NTFontSelectDialog dlg = new NTFontSelectDialog();
            if (NTUserPreference.UseAAFontTypeface)
                dlg.FontName = NTUserPreference.AAFontTypeface;// "IPAMonaPGothic";
            bool? result = dlg.ShowDialog();
            if (result.HasValue && (bool)result)
                edtFontAA.Text = dlg.FontName;

        }

        private void btnInitAAText_Click(object sender, RoutedEventArgs e)
        {
            edtAATextData.Text = "　 \n";
        }
        
    }
}
